/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;

public class WebSocketClient
extends Client {
    private final WebSocketServerHandshaker handshaker;

    WebSocketClient(@NotNull Channel channel2, @NotNull WebSocketServerHandshaker handshaker) {
        if (channel2 == null) {
            WebSocketClient.$$$reportNull$$$0(0);
        }
        if (handshaker == null) {
            WebSocketClient.$$$reportNull$$$0(1);
        }
        super(channel2);
        this.handshaker = handshaker;
    }

    @Override
    @NotNull
    public ChannelFuture send(@NotNull ByteBuf message2) {
        if (message2 == null) {
            WebSocketClient.$$$reportNull$$$0(2);
        }
        if (this.channel.isOpen()) {
            ChannelFuture channelFuture = this.channel.writeAndFlush((Object)new TextWebSocketFrame(message2));
            if (channelFuture == null) {
                WebSocketClient.$$$reportNull$$$0(3);
            }
            return channelFuture;
        }
        ChannelFuture channelFuture = this.channel.newFailedFuture((Throwable)new ClosedChannelException());
        if (channelFuture == null) {
            WebSocketClient.$$$reportNull$$$0(4);
        }
        return channelFuture;
    }

    @Override
    public void sendHeartbeat() {
        this.channel.writeAndFlush((Object)new PingWebSocketFrame());
    }

    public void disconnect(@NotNull CloseWebSocketFrame frame) {
        if (frame == null) {
            WebSocketClient.$$$reportNull$$$0(5);
        }
        this.handshaker.close(this.channel, frame);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handshaker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/webSocket/WebSocketClient";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/webSocket/WebSocketClient";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "send";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disconnect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

