/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtil;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcDomainBean;
import org.jetbrains.io.jsonRpc.JsonRpcServer$findDomain$1;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt$sam$java_util_function_Function$0;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u0013\"\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0014JG\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u001cJQ\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u001a2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00162\f\b\u0002\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u001fJ1\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u000e\u0010#\u001a\n\u0018\u00010$j\u0004\u0018\u0001`%H\u0002\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020\tH\u0002J\u0018\u0010)\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0016J\"\u0010,\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J \u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0007J3\u00102\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u0013\"\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00103J;\u00102\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u0013\"\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00104J \u00105\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001a2\b\u0010*\u001a\u0004\u0018\u00010+J\"\u00106\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0016J7\u00107\u001a\u0002082\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "clientManager", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "(Lorg/jetbrains/io/jsonRpc/ClientManager;)V", "messageIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "testDomain", "Lkotlin/Pair;", "", "", "call", "Lorg/jetbrains/concurrency/Promise;", "T", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "domain", "command", "params", "", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "doEncodeMessage", "Lio/netty/buffer/ByteBuf;", "byteBufAllocator", "Lio/netty/buffer/ByteBufAllocator;", "id", "", "rawData", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "encodeMessage", "messageId", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Lio/netty/buffer/ByteBuf;", "encodeParameters", "", "buffer", "_sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;Ljava/lang/StringBuilder;)V", "findDomain", "domainName", "messageReceived", "message", "", "processClientError", "error", "registerTestDomain", "name", "disposable", "Lcom/intellij/openapi/Disposable;", "send", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "sendErrorResponse", "sendResponse", "sendWithRawPart", "", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Z", "intellij.platform.builtInServer.impl"})
public final class JsonRpcServer
implements MessageServer {
    private final AtomicInteger messageIdCounter;
    @TestOnly
    private Pair<String, ? extends Object> testDomain;
    private final ClientManager clientManager;

    @TestOnly
    public final void registerTestDomain(@NotNull String name, @NotNull Object domain, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.testDomain = new Pair((Object)name, domain);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this){
            final /* synthetic */ JsonRpcServer this$0;

            public final void dispose() {
                JsonRpcServer.access$setTestDomain$p(this.this$0, null);
            }
            {
                this.this$0 = jsonRpcServer;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message2) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("IN " + message2);
        }
        JsonReaderEx reader = new JsonReaderEx(message2);
        reader.beginArray();
        int messageId = reader.peek() == JsonToken.NUMBER ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise == null) {
                    JsonRpcServerKt.access$getLOG$p().error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise.setResult(JsonUtil.nextAny(reader));
            } else {
                AsyncPromise asyncPromise = promise;
                Intrinsics.checkNotNull((Object)asyncPromise);
                asyncPromise.setError("error");
            }
            return;
        }
        String string = domainName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"domainName");
        Object domain = this.findDomain(string);
        if (domain == null) {
            this.processClientError(client, "Cannot find domain " + domainName, messageId);
            return;
        }
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId, message2);
            return;
        }
        Object[] parameters2 = null;
        if (reader.hasNext()) {
            SmartList list2 = new SmartList();
            JsonUtil.readListBody(reader, (List)list2);
            Object object = list2.get(0);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)((List)object));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ArrayUtil.toObjectArray(list[0] as List<*>)");
            parameters2 = objectArray;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"ArrayUtilRt.EMPTY_OBJECT_ARRAY");
            parameters2 = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        boolean isStatic = domain instanceof Class;
        Method[] methods = null;
        if (isStatic) {
            Method[] methodArray = ((Class)domain).getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"(domain as Class<*>).declaredMethods");
            methods = methodArray;
        } else {
            Method[] methodArray = domain.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"domain.javaClass.methods");
            methods = methodArray;
        }
        for (Method method2 : methods) {
            if (!Intrinsics.areEqual((Object)method2.getName(), (Object)command)) continue;
            method2.setAccessible(true);
            Object result2 = method2.invoke(isStatic ? null : domain, Arrays.copyOf(parameters2, parameters2.length));
            if (messageId != -1) {
                if (result2 instanceof ByteBuf) {
                    ByteBuf $this$releaseIfError$iv = (ByteBuf)result2;
                    boolean $i$f$releaseIfError = false;
                    try {
                        boolean bl = false;
                        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, (ByteBuf)result2, null, 44, null));
                    }
                    catch (Exception e$iv) {
                        try {
                            $this$releaseIfError$iv.release();
                        }
                        finally {
                            throw (Throwable)e$iv;
                        }
                    }
                } else {
                    Object[] objectArray;
                    ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                    if (result2 == null) {
                        objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = result2;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"if (result == null) Arra\u2026RRAY else arrayOf(result)");
                    client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, null, objectArray, 28, null));
                }
            }
            return;
        }
        this.processClientError(client, "Cannot find method " + domain + '.' + command, messageId);
    }

    private final Object findDomain(String domainName) {
        Pair<String, ? extends Object> testDomain = this.testDomain;
        if (testDomain != null && Intrinsics.areEqual((Object)((String)testDomain.getFirst()), (Object)domainName)) {
            return testDomain.getSecond();
        }
        Object object = (Function1)JsonRpcServer$findDomain$1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new JsonRpcServerKt$sam$java_util_function_Function$0(function1);
        }
        JsonRpcDomainBean jsonRpcDomainBean = (JsonRpcDomainBean)((Object)JsonRpcDomainBean.EP_NAME.getByKey((Object)domainName, JsonRpcServer.class, (Function)object));
        return jsonRpcDomainBean != null ? jsonRpcDomainBean.getInstance() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClientError(Client client, @NonNls String error, int messageId) {
        try {
            JsonRpcServerKt.access$getLOG$p().error(error);
        }
        finally {
            if (messageId != -1) {
                this.sendErrorResponse(client, messageId, error);
            }
        }
    }

    public final void sendResponse(@NotNull Client client, int messageId, @Nullable ByteBuf rawData) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, rawData, null, 44, null));
    }

    public static /* synthetic */ void sendResponse$default(JsonRpcServer jsonRpcServer, Client client, int n, ByteBuf byteBuf, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byteBuf = null;
        }
        jsonRpcServer.sendResponse(client, n, byteBuf);
    }

    public final void sendErrorResponse(@NotNull Client client, int messageId, @Nullable CharSequence message2) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, "e", null, null, new CharSequence[]{message2}, 24, null));
    }

    public final boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @NotNull ByteBuf rawData, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        return client.send(this.encodeMessage(byteBufAllocator, -1, domain, command, rawData, params)).cause() == null;
    }

    public final void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, -1, domain, command, null, params, 16, null));
    }

    @NotNull
    public final <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        int messageId = this.messageIdCounter.getAndIncrement();
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        ByteBuf message2 = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
        Promise promise = client.send(messageId, message2);
        Intrinsics.checkNotNull(promise);
        return promise;
    }

    public final void send(@NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.clientManager.hasClients()) {
            int messageId = -1;
            ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"ByteBufAllocator.DEFAULT");
            ByteBuf message2 = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
            ClientManager.send$default(this.clientManager, messageId, message2, null, 4, null);
        }
    }

    private final ByteBuf encodeMessage(ByteBufAllocator byteBufAllocator, int messageId, String domain, String command, ByteBuf rawData, Object[] params) {
        ByteBuf buffer = this.doEncodeMessage(byteBufAllocator, messageId, domain, command, params, rawData);
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("OUT " + buffer.toString(Charsets.UTF_8));
        }
        return buffer;
    }

    static /* synthetic */ ByteBuf encodeMessage$default(JsonRpcServer jsonRpcServer, ByteBufAllocator byteBufAllocator, int n, String string, String string2, ByteBuf byteBuf, Object[] objectArray, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            byteBuf = null;
        }
        if ((n2 & 0x20) != 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"ArrayUtilRt.EMPTY_OBJECT_ARRAY");
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return jsonRpcServer.encodeMessage(byteBufAllocator, n, string, string2, byteBuf, objectArray);
    }

    private final ByteBuf doEncodeMessage(ByteBufAllocator byteBufAllocator, int id2, String domain, String command, Object[] params, ByteBuf rawData) {
        ByteBuf buffer;
        ByteBuf byteBuf = buffer = byteBufAllocator.ioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer");
        JsonRpcServerKt.access$writeByte(byteBuf, '[');
        StringBuilder sb = null;
        if (id2 != -1) {
            sb = new StringBuilder();
            StringBuilder stringBuilder = sb.append(id2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"sb.append(id)");
            JsonRpcServerKt.access$writeAscii(buffer, stringBuilder);
            sb.setLength(0);
        }
        if (domain != null) {
            if (id2 != -1) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            }
            ByteBuf byteBuf2 = JsonRpcServerKt.access$writeByte(buffer, '\"');
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer.writeByte('\"')");
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(byteBuf2, domain), '\"');
            if (command != null) {
                ByteBuf byteBuf3 = JsonRpcServerKt.access$writeByte(buffer, ',');
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf3, (String)"buffer.writeByte(',')");
                ByteBuf byteBuf4 = JsonRpcServerKt.access$writeByte(byteBuf3, '\"');
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf4, (String)"buffer.writeByte(',').writeByte('\"')");
                JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(byteBuf4, command), '\"');
            }
        }
        ByteBuf effectiveBuffer = buffer;
        Object[] objectArray = params;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        if (!(objectArray2.length == 0) || rawData != null) {
            ByteBuf byteBuf5 = JsonRpcServerKt.access$writeByte(buffer, ',');
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf5, (String)"buffer.writeByte(',')");
            JsonRpcServerKt.access$writeByte(byteBuf5, '[');
            this.encodeParameters(buffer, params, sb);
            if (rawData != null) {
                objectArray = params;
                bl = false;
                objectArray2 = objectArray;
                bl2 = false;
                if (!(objectArray2.length == 0)) {
                    JsonRpcServerKt.access$writeByte(buffer, ',');
                }
                effectiveBuffer = (ByteBuf)byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
                buffer = byteBufAllocator.ioBuffer();
            }
            ByteBuf byteBuf6 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf6, (String)"buffer");
            JsonRpcServerKt.access$writeByte(byteBuf6, ']');
        }
        JsonRpcServerKt.access$writeByte(buffer, ']');
        ByteBuf byteBuf7 = effectiveBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf7, (String)"effectiveBuffer");
        return JsonRpcServerKt.access$addBuffer(byteBuf7, buffer);
    }

    private final void encodeParameters(ByteBuf buffer, Object[] params, StringBuilder _sb) {
        StringBuilder sb = _sb;
        JsonWriter writer = null;
        boolean hasPrev = false;
        for (Object param : params) {
            if (hasPrev) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            } else {
                hasPrev = true;
            }
            Object object = param;
            if (object instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, buffer);
                continue;
            }
            if (object == null) {
                JsonRpcServerKt.access$writeAscii(buffer, "null");
                continue;
            }
            if (object instanceof Boolean) {
                JsonRpcServerKt.access$writeAscii(buffer, param.toString());
                continue;
            }
            if (object instanceof Number) {
                Object object2;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if ((object2 = param) instanceof Integer) {
                    sb.append(((Number)param).intValue());
                } else if (object2 instanceof Long) {
                    sb.append(((Number)param).longValue());
                } else if (object2 instanceof Float) {
                    sb.append(((Number)param).floatValue());
                } else if (object2 instanceof Double) {
                    sb.append(((Number)param).doubleValue());
                } else {
                    sb.append(param.toString());
                }
                JsonRpcServerKt.access$writeAscii(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (object instanceof Consumer) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                Object object3 = param;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.Consumer<kotlin.text.StringBuilder /* = java.lang.StringBuilder */>");
                }
                ((Consumer)object3).consume((Object)sb);
                ByteBufUtil.writeUtf8((ByteBuf)buffer, (CharSequence)sb);
                sb.setLength(0);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter((Writer)new ByteBufUtf8Writer(buffer));
            }
            TypeAdapter typeAdapter = JsonRpcServerKt.access$getGson$p().getAdapter(param.getClass());
            if (typeAdapter == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any>");
            }
            typeAdapter.write(writer, param);
        }
    }

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        this.clientManager = clientManager;
        this.messageIdCounter = new AtomicInteger();
        boolean bl = false;
        Map beans = new LinkedHashMap();
        ExtensionPointName<JsonRpcDomainBean> extensionPointName = JsonRpcDomainBean.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"JsonRpcDomainBean.EP_NAME");
        for (JsonRpcDomainBean bean : extensionPointName.getExtensionList()) {
            String string = bean.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bean.name");
            JsonRpcDomainBean jsonRpcDomainBean = bean;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jsonRpcDomainBean), (String)"bean");
            JsonRpcDomainBean prev2 = beans.put(string, jsonRpcDomainBean);
            if (prev2 == null || prev2.overridable) continue;
            throw (Throwable)new IllegalArgumentException(bean.name + " is already registered");
        }
    }

    public static final /* synthetic */ Pair access$getTestDomain$p(JsonRpcServer $this) {
        return $this.testDomain;
    }

    public static final /* synthetic */ void access$setTestDomain$p(JsonRpcServer $this, Pair pair) {
        $this.testDomain = pair;
    }
}

