/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.CaseInsensitiveUrlHashingStrategy;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0006J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\bJ\u0010\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020#R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "(Ljava/util/List;ZLcom/intellij/util/Url;Z)V", "canonicalizedUrlToSourceIndex", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getCanonicalizedUrlToSourceIndex", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "canonicalizedUrlToSourceIndex$delegate", "Lkotlin/Lazy;", "canonicalizedUrls", "", "getCanonicalizedUrls", "()[Lcom/intellij/util/Url;", "canonicalizedUrls$delegate", "findSourceIndex", "", "sourceUrl", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceIndex$intellij_platform_scriptDebugger_backend", "findSourceIndexByFile", "findSourceIndexByFile$intellij_platform_scriptDebugger_backend", "getSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSourceIndex", "url", "getUrlIfLocalFile", "Companion", "intellij.platform.scriptDebugger.backend"})
public final class SourceResolver {
    @NotNull
    private final Lazy canonicalizedUrls$delegate;
    private final Lazy canonicalizedUrlToSourceIndex$delegate;
    private final List<String> rawSources;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Url[] getCanonicalizedUrls() {
        Lazy lazy = this.canonicalizedUrls$delegate;
        SourceResolver sourceResolver = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Url[])lazy.getValue();
    }

    private final Object2IntMap<Url> getCanonicalizedUrlToSourceIndex() {
        Lazy lazy = this.canonicalizedUrlToSourceIndex$delegate;
        SourceResolver sourceResolver = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Object2IntMap)lazy.getValue();
    }

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int index2 = entry.getSource();
        return index2 < 0 ? null : this.getCanonicalizedUrls()[index2];
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getCanonicalizedUrlToSourceIndex().getInt((Object)url);
    }

    public final int findSourceIndex$intellij_platform_scriptDebugger_backend(@NotNull SourceFileResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        int resolveByCanonicalizedUrls = resolver.resolve(this.getCanonicalizedUrlToSourceIndex());
        return resolveByCanonicalizedUrls != -1 ? resolveByCanonicalizedUrls : resolver.resolve(this.rawSources);
    }

    public final int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int index2 = this.getCanonicalizedUrlToSourceIndex().getInt((Object)sourceUrl);
        if (index2 != -1) {
            return index2;
        }
        if (sourceFile != null) {
            return this.findSourceIndexByFile$intellij_platform_scriptDebugger_backend(sourceFile, localFileUrlOnly);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int findSourceIndexByFile$intellij_platform_scriptDebugger_backend(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        int index2;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (!localFileUrlOnly && (index2 = this.getCanonicalizedUrlToSourceIndex().getInt((Object)Urls.newFromVirtualFile((VirtualFile)sourceFile).trimParameters())) != -1) {
            return index2;
        }
        if (!sourceFile.isInLocalFileSystem()) {
            return -1;
        }
        index2 = this.getCanonicalizedUrlToSourceIndex().getInt((Object)ScriptDebuggerUrls.newLocalFileUrl(sourceFile));
        if (index2 != -1) {
            return index2;
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true) {
            int n = 0;
            int n2 = this.getCanonicalizedUrls().length;
            while (n < n2) {
                void i2;
                Url url = this.getCanonicalizedUrls()[i2];
                if (Urls.INSTANCE.equalsIgnoreParameters(url, canonicalFile)) {
                    return (int)i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    @Nullable
    public final Url getUrlIfLocalFile(@NotNull MappingEntry entry) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Url url = (Url)ArraysKt.getOrNull((Object[])this.getCanonicalizedUrls(), (int)entry.getSource());
        if (url != null) {
            Url url2 = url;
            boolean bl = false;
            boolean bl2 = false;
            Url it = url2;
            boolean bl3 = false;
            object = it.isInLocalFileSystem() ? it : null;
        } else {
            object = null;
        }
        return object;
    }

    public SourceResolver(@NotNull List<String> rawSources, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter(rawSources, (String)"rawSources");
        this.rawSources = rawSources;
        this.canonicalizedUrls$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Url[]>(this, baseUrl, trimFileScheme, baseUrlIsFile){
            final /* synthetic */ SourceResolver this$0;
            final /* synthetic */ Url $baseUrl;
            final /* synthetic */ boolean $trimFileScheme;
            final /* synthetic */ boolean $baseUrlIsFile;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Url[] invoke() {
                int n = SourceResolver.access$getRawSources$p(this.this$0).size();
                Url[] urlArray = new Url[n];
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    Url url;
                    int n3 = n2;
                    int n4 = n2++;
                    Url[] urlArray2 = urlArray;
                    boolean bl = false;
                    urlArray2[n4] = url = SourceResolverKt.canonicalizeUrl((String)SourceResolver.access$getRawSources$p(this.this$0).get((int)it), this.$baseUrl, this.$trimFileScheme, this.$baseUrlIsFile);
                }
                return urlArray;
            }
            {
                this.this$0 = sourceResolver;
                this.$baseUrl = url;
                this.$trimFileScheme = bl;
                this.$baseUrlIsFile = bl2;
                super(0);
            }
        }));
        this.canonicalizedUrlToSourceIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Object2IntMap<Url>>(this){
            final /* synthetic */ SourceResolver this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Object2IntMap<Url> invoke() {
                void var1_1;
                Object2IntMap map2 = SystemInfo.isFileSystemCaseSensitive ? (Object2IntMap)new Object2IntOpenHashMap(SourceResolver.access$getRawSources$p(this.this$0).size()) : (Object2IntMap)new Object2IntOpenCustomHashMap(SourceResolver.access$getRawSources$p(this.this$0).size(), (Hash.Strategy)CaseInsensitiveUrlHashingStrategy.INSTANCE);
                map2.defaultReturnValue(-1);
                int n = 0;
                int n2 = ((Collection)SourceResolver.access$getRawSources$p(this.this$0)).size();
                while (n < n2) {
                    void i2;
                    map2.put((Object)this.this$0.getCanonicalizedUrls()[i2], (int)i2);
                    ++i2;
                }
                return var1_1;
            }
            {
                this.this$0 = sourceResolver;
                super(0);
            }
        }));
    }

    public /* synthetic */ SourceResolver(List list2, boolean bl, Url url, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(list2, bl, url, bl2);
    }

    public static final /* synthetic */ List access$getRawSources$p(SourceResolver $this) {
        return $this.rawSources;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "isAbsolute", "", "path", "", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

