/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMapDataCache;", "", "()V", "cache", "", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "getOrCreate", "sourceMapData", "", "mapDebugName", "intellij.platform.scriptDebugger.backend"})
public final class SourceMapDataCache {
    private static final Map<SourceMapDataImpl, SourceMapDataEx> cache;
    @NotNull
    public static final SourceMapDataCache INSTANCE;

    @Nullable
    public final SourceMapDataEx getOrCreate(@NotNull String sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        SourceMapDataImpl sourceMapDataImpl = SourceMapDecoderKt.parseMapSafely(sourceMapData, mapDebugName);
        if (sourceMapDataImpl == null) {
            return null;
        }
        SourceMapDataImpl data2 = sourceMapDataImpl;
        SourceMapDataEx value2 = cache.get(data2);
        if (value2 != null) {
            return value2;
        }
        MappingList[] sourceIndexToMappings = SourceMapDecoderKt.calculateReverseMappings(data2);
        GeneratedMappingList generatedMappings2 = new GeneratedMappingList(data2.getMappings());
        SourceMapDataEx result2 = new SourceMapDataEx(data2, sourceIndexToMappings, generatedMappings2);
        cache.put(data2, result2);
        return result2;
    }

    public static /* synthetic */ SourceMapDataEx getOrCreate$default(SourceMapDataCache sourceMapDataCache, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return sourceMapDataCache.getOrCreate(string, string2);
    }

    private SourceMapDataCache() {
    }

    static {
        SourceMapDataCache sourceMapDataCache;
        INSTANCE = sourceMapDataCache = new SourceMapDataCache();
        Map map2 = Collections.synchronizedMap(ContainerUtil.createSoftKeySoftValueMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026Impl, SourceMapDataEx>())");
        cache = map2;
    }
}

