/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.reference.SoftReference;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010$\u001a\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u001e\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMapData;", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "filePath", "Ljava/nio/file/Path;", "initialData", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "(Ljava/nio/file/Path;Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;)V", "cachedData", "Lcom/intellij/reference/SoftReference;", "file", "", "getFile", "()Ljava/lang/String;", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "hasNameMappings", "", "getHasNameMappings", "()Z", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getMappings", "()Ljava/util/List;", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceIndexToMappings", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "sources", "getSources", "sourcesContent", "getSourcesContent", "calculateData", "getData", "intellij.platform.scriptDebugger.backend"})
final class FileBackedSourceMapData
implements SourceMapData {
    private SoftReference<SourceMapDataEx> cachedData;
    @Nullable
    private final String file;
    @NotNull
    private final List<String> sources;
    private final boolean hasNameMappings;
    private final Path filePath;

    @Override
    @Nullable
    public String getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    @Nullable
    public List<String> getSourcesContent() {
        return this.getData().getSourceMapData().getSourcesContent();
    }

    @Override
    public boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    @Override
    @NotNull
    public List<MappingEntry> getMappings() {
        return this.getData().getSourceMapData().getMappings();
    }

    @NotNull
    public final MappingList[] getSourceIndexToMappings() {
        return this.getData().getSourceIndexToMappings();
    }

    @NotNull
    public final Mappings getGeneratedMappings() {
        return this.getData().getGeneratedMappings();
    }

    private final SourceMapDataEx calculateData() {
        String text2 = PathKt.readText((Path)this.filePath);
        return SourceMapDataCache.INSTANCE.getOrCreate(text2, ((Object)this.filePath).toString());
    }

    private final SourceMapDataEx getData() {
        SourceMapDataEx cached = (SourceMapDataEx)this.cachedData.get();
        if (cached != null) {
            return cached;
        }
        SourceMapDataEx sourceMapDataEx = this.calculateData();
        if (sourceMapDataEx == null) {
            throw (Throwable)new RuntimeException("Cannot decode " + this.filePath);
        }
        SourceMapDataEx calculated = sourceMapDataEx;
        this.cachedData = new SoftReference((Object)calculated);
        return calculated;
    }

    public FileBackedSourceMapData(@NotNull Path filePath, @NotNull SourceMapDataEx initialData) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)initialData, (String)"initialData");
        this.filePath = filePath;
        this.cachedData = new SoftReference((Object)initialData);
        this.file = initialData.getSourceMapData().getFile();
        this.sources = initialData.getSourceMapData().getSources();
        this.hasNameMappings = initialData.getSourceMapData().getHasNameMappings();
    }
}

