/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "SCRIPT", "Lorg/jetbrains/debugger/ScriptBase;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "()V", "idToScript", "Ljava/util/concurrent/ConcurrentMap;", "", "getIdToScript", "()Ljava/util/concurrent/ConcurrentMap;", "clear", "", "listener", "Lorg/jetbrains/debugger/DebugEventListener;", "findScriptById", "id", "(Ljava/lang/String;)Lorg/jetbrains/debugger/ScriptBase;", "findScriptByUrl", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)Lorg/jetbrains/debugger/ScriptBase;", "rawUrl", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "Lorg/jetbrains/debugger/Script;", "", "rawUrlToOurUrl", "intellij.platform.scriptDebugger.backend"})
public abstract class ScriptManagerBaseEx<SCRIPT extends ScriptBase>
extends ScriptManagerBase<SCRIPT> {
    @NotNull
    private final ConcurrentMap<String, SCRIPT> idToScript = new ConcurrentHashMap();

    @NotNull
    protected final ConcurrentMap<String, SCRIPT> getIdToScript() {
        return this.idToScript;
    }

    @Override
    public final void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkNotNullParameter(scriptProcessor, (String)"scriptProcessor");
        Iterator iterator2 = this.idToScript.values().iterator();
        while (iterator2.hasNext()) {
            ScriptBase script;
            ScriptBase scriptBase = script = (ScriptBase)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)scriptBase, (String)"script");
            if (((Boolean)scriptProcessor.invoke((Object)scriptBase)).booleanValue()) continue;
            return;
        }
    }

    @Nullable
    public final SCRIPT findScriptById(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return (SCRIPT)((ScriptBase)this.idToScript.get(id2));
    }

    public final void clear(@NotNull DebugEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.idToScript.clear();
        listener2.scriptsCleared();
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        return (SCRIPT)this.findScriptByUrl(this.rawUrlToOurUrl(rawUrl));
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull Url url) {
        ScriptBase scriptBase;
        Object v0;
        ScriptBase it;
        boolean bl;
        Iterable iterable;
        boolean bl2;
        Iterable iterable2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            iterable2 = this.idToScript.values();
            bl2 = false;
            iterable = iterable2;
            bl = false;
            for (Object t : iterable) {
                it = (ScriptBase)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)url, (Object)it.getUrl())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((scriptBase = (ScriptBase)v0) == null) {
            Object v2;
            block4: {
                iterable2 = this.idToScript.values();
                bl2 = false;
                iterable = iterable2;
                bl = false;
                for (Object t : iterable) {
                    it = (ScriptBase)t;
                    boolean bl4 = false;
                    if (!url.equalsIgnoreParameters(it.getUrl())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            scriptBase = v2;
        }
        return (SCRIPT)scriptBase;
    }

    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        Url url = Urls.parseEncoded((String)rawUrl);
        Intrinsics.checkNotNull((Object)url);
        return url;
    }
}

