/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.CharSequenceBackedByChars;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LogEntry;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/debugger/MessagingLogger;", "", "debugFile", "", "(Ljava/lang/String;)V", "processFuture", "Ljava/util/concurrent/Future;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/debugger/LogEntry;", "add", "", "outMessage", "Lio/netty/buffer/ByteBuf;", "marker", "message", "", "close", "closeOnChannelClose", "channel", "Lio/netty/channel/Channel;", "intellij.platform.scriptDebugger.backend"})
public final class MessagingLogger {
    private final Future<?> processFuture;
    private final LinkedBlockingQueue<LogEntry> queue;

    public final void add(@NotNull CharSequence message2, @NotNull String marker) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        if (!StringsKt.startsWith$default((CharSequence)message2, (CharSequence)"{\"method\":\"Network.", (boolean)false, (int)2, null)) {
            this.queue.add(new LogEntry(message2, marker));
        }
    }

    public static /* synthetic */ void add$default(MessagingLogger messagingLogger, CharSequence charSequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "IN";
        }
        messagingLogger.add(charSequence, string);
    }

    public final void add(@NotNull ByteBuf outMessage, @NotNull String marker) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)outMessage, (String)"outMessage");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        CharSequence charSequence2 = charSequence = outMessage.getCharSequence(outMessage.readerIndex(), outMessage.readableBytes(), Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"charSequence");
        this.add(charSequence2, marker);
    }

    public static /* synthetic */ void add$default(MessagingLogger messagingLogger, ByteBuf byteBuf, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "OUT";
        }
        messagingLogger.add(byteBuf, string);
    }

    public final void close() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this){
            final /* synthetic */ MessagingLogger this$0;

            public final void invoke() {
                MessagingLogger.access$getProcessFuture$p(this.this$0).cancel(true);
            }
            {
                this.this$0 = messagingLogger;
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public final void closeOnChannelClose(@NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        ChannelFuture channelFuture = channel2.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"channel.closeFuture()");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ MessagingLogger this$0;
            {
                this.this$0 = messagingLogger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                try {
                    this.this$0.add("\"Closed\"", "Channel");
                }
                finally {
                    this.this$0.close();
                }
            }
        });
    }

    public MessagingLogger(final @NotNull String debugFile) {
        Intrinsics.checkNotNullParameter((Object)debugFile, (String)"debugFile");
        this.queue = new LinkedBlockingQueue();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                File file2 = new File(FileUtil.expandUserHome((String)debugFile));
                FileUtilRt.createParentDirs((File)file2);
                FileOutputStream out = new FileOutputStream(file2);
                OutputStream outputStream = out;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
                writer.write("[\n");
                writer.flush();
                FileChannel fileChannel = out.getChannel();
                SimpleDateFormat dateFormatter = new SimpleDateFormat("HH.mm.ss,SSS");
                try {
                    try {
                        while (true) {
                            LogEntry entry = (LogEntry)queue.take();
                            writer.write("{\"timestamp\": \"" + dateFormatter.format(entry.getTime$intellij_platform_scriptDebugger_backend()) + "\", ");
                            CharSequence message2 = entry.getMessage();
                            writer.write('\"' + entry.getMarker() + "\": ");
                            writer.flush();
                            if (message2 instanceof CharSequenceBackedByChars) {
                                fileChannel.write(((CharSequenceBackedByChars)message2).getByteBuffer());
                            } else {
                                fileChannel.write(Charsets.UTF_8.encode(CharBuffer.wrap(message2)));
                            }
                            writer.write("},\n");
                            writer.flush();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        writer.write("]");
                        writer.flush();
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    writer.write("]");
                    writer.flush();
                    out.close();
                    throw throwable;
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"ApplicationManager.getAp\u2026out.close()\n      }\n    }");
        this.processFuture = future2;
    }

    public static final /* synthetic */ Future access$getProcessFuture$p(MessagingLogger $this) {
        return $this.processFuture;
    }
}

