/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.AsyncFramesHeader;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptExecutionStack;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0003\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/debugger/ExecutionStackView;", "Lorg/jetbrains/debugger/ScriptExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "displayName", "", "isCurrent", "", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/String;Z)V", "getSuspendContext", "()Lorg/jetbrains/debugger/SuspendContext;", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getViewSupport$intellij_platform_scriptDebugger_ui", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "copyWithIsCurrent", "getTopFrame", "intellij.platform.scriptDebugger.ui"})
public final class ExecutionStackView
extends ScriptExecutionStack {
    private CallFrameView topCallFrameView;
    @NotNull
    private final SuspendContext<?> suspendContext;
    @NotNull
    private final DebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CallFrameView getTopFrame() {
        block6: {
            CallFrameView callFrameView;
            Object topCallFrame;
            block5: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block5;
                CallFrameView callFrameView2 = this.topCallFrameView;
                Intrinsics.checkNotNull((Object)callFrameView2);
                if (!(Intrinsics.areEqual((Object)callFrameView2.getCallFrame(), topCallFrame) ^ true)) break block6;
            }
            ExecutionStackView executionStackView = this;
            Object obj2 = topCallFrame;
            if (obj2 != null) {
                void it;
                Object obj3 = obj2;
                boolean bl = false;
                boolean bl2 = false;
                Object obj4 = obj3;
                ExecutionStackView executionStackView2 = executionStackView;
                boolean bl3 = false;
                CallFrameView callFrameView3 = new CallFrameView((CallFrame)it, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, this.suspendContext.getVm(), this.suspendContext.getMethodReturnValue(), 16, null);
                executionStackView = executionStackView2;
                callFrameView = callFrameView3;
            } else {
                callFrameView = null;
            }
            executionStackView.topCallFrameView = callFrameView;
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Promise<CallFrame[]> promise = this.suspendContext.getFrames();
        SuspendContext<?> context$iv = this.suspendContext;
        boolean $i$f$onSuccess = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onSuccess$iv.onSuccess((Consumer)new ContextDependentAsyncResultConsumer<CallFrame[]>(context$iv, context$iv, this, firstFrameIndex, container){
            final /* synthetic */ SuspendContext $context;
            final /* synthetic */ ExecutionStackView this$0;
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;
            {
                this.$context = $captured_local_variable$1;
                this.this$0 = executionStackView;
                this.$firstFrameIndex$inlined = n;
                this.$container$inlined = xStackFrameContainer;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void accept(Object result2, @NotNull Vm vm) {
                List result3;
                block6: {
                    int count;
                    CallFrame[] frames;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                        frames = (CallFrame[])result2;
                        boolean bl = false;
                        count = frames.length - this.$firstFrameIndex$inlined;
                        result3 = null;
                        if (count >= 1) break block5;
                        result3 = CollectionsKt.emptyList();
                        break block6;
                    }
                    result3 = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex$inlined;
                    int n2 = frames.length;
                    while (n < n2) {
                        void i2;
                        block8: {
                            boolean isInLibraryContent;
                            SourceInfo sourceInfo;
                            Script script;
                            CallFrame frame;
                            block9: {
                                block7: {
                                    if (i2 != false) break block7;
                                    ArrayList arrayList = (ArrayList)result3;
                                    CallFrameView callFrameView = this.this$0.getTopFrame();
                                    Intrinsics.checkNotNull((Object)callFrameView);
                                    arrayList.add(callFrameView);
                                    break block8;
                                }
                                frame = frames[i2];
                                String asyncFunctionName = frame.getAsyncFunctionName();
                                if (asyncFunctionName != null) {
                                    ((ArrayList)result3).add(new AsyncFramesHeader(asyncFunctionName));
                                }
                                if ((script = this.this$0.getSuspendContext().getVm().getScriptManager().getScript(frame)) == null) break block8;
                                sourceInfo = this.this$0.getViewSupport$intellij_platform_scriptDebugger_ui().getSourceInfo(script, frame);
                                boolean bl = isInLibraryContent = sourceInfo != null && this.this$0.getViewSupport$intellij_platform_scriptDebugger_ui().isInLibraryContent(sourceInfo, script);
                                if (!isInLibraryContent) break block9;
                                XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
                                Intrinsics.checkNotNullExpressionValue((Object)xDebuggerSettingsManager, (String)"XDebuggerSettingsManager.getInstance()");
                                XDebuggerSettingsManager.DataViewSettings dataViewSettings = xDebuggerSettingsManager.getDataViewSettings();
                                Intrinsics.checkNotNullExpressionValue((Object)dataViewSettings, (String)"XDebuggerSettingsManager\u2026stance().dataViewSettings");
                                if (!dataViewSettings.isShowLibraryStackFrames()) break block8;
                            }
                            ((ArrayList)result3).add(new CallFrameView(frame, this.this$0.getViewSupport$intellij_platform_scriptDebugger_ui(), script, sourceInfo, isInLibraryContent, this.this$0.getSuspendContext().getVm(), null, 64, null));
                        }
                        ++i2;
                    }
                }
                this.$container$inlined.addStackFrames(result3, true);
            }
        }), (String)"onSuccess(object : Conte\u2026m) = handler(result)\n  })");
    }

    @NotNull
    public final ExecutionStackView copyWithIsCurrent(boolean isCurrent) {
        if (Intrinsics.areEqual((Object)this.getIcon(), (Object)SuspendContextViewKt.access$getThreadIcon(isCurrent))) {
            return this;
        }
        String string = this.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"displayName");
        return new ExecutionStackView(this.suspendContext, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, string, isCurrent);
    }

    @NotNull
    public final SuspendContext<?> getSuspendContext() {
        return this.suspendContext;
    }

    @NotNull
    public final DebuggerViewSupport getViewSupport$intellij_platform_scriptDebugger_ui() {
        return this.viewSupport;
    }

    public ExecutionStackView(@NotNull SuspendContext<?> suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo, @NlsContexts.ListItem @NotNull String displayName, boolean isCurrent) {
        Intrinsics.checkNotNullParameter(suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        super(suspendContext.getVm(), displayName, SuspendContextViewKt.access$getThreadIcon(isCurrent));
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackView(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            string = "";
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo, string, bl);
    }
}

