/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.liveReload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.NettyKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.liveReload.WebServerFileContentListener;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Service(value={Service.Level.APP})
public final class WebServerPageConnectionService {
    public static final String RELOAD_URL_PARAM = "_ij_reload";
    private static final String RELOAD_WS_REQUEST = "reload";
    private static final String RELOAD_WS_URL_PREFIX = "jb-server-page";
    @NotNull
    private final ByteBuf RELOAD_PAGE_MESSAGE = Unpooled.copiedBuffer((CharSequence)"reload", (Charset)CharsetUtil.US_ASCII).asReadOnly();
    @Nullable
    private ClientManager myServer;
    @Nullable
    private JsonRpcServer myRpcServer;
    @NotNull
    private final AtomicInteger ourListenersCount = new AtomicInteger(0);
    @Nullable
    private volatile Disposable ourListenerDisposable;
    @NotNull
    private final Set<VirtualFile> myRequestedFiles = ConcurrentHashMap.newKeySet();

    public static WebServerPageConnectionService getInstance() {
        return (WebServerPageConnectionService)ApplicationManager.getApplication().getService(WebServerPageConnectionService.class);
    }

    @Nullable
    public CharSequence fileRequested(@NotNull FullHttpRequest request, @NotNull Supplier<? extends VirtualFile> fileSupplier) {
        VirtualFile file2;
        if (request == null) {
            WebServerPageConnectionService.$$$reportNull$$$0(0);
        }
        if (fileSupplier == null) {
            WebServerPageConnectionService.$$$reportNull$$$0(1);
        }
        boolean isReloadRequest = false;
        String uri = request.uri();
        if (uri != null && uri.contains(RELOAD_URL_PARAM)) {
            QueryStringDecoder decoder = new QueryStringDecoder(uri);
            isReloadRequest = decoder.parameters().containsKey(RELOAD_URL_PARAM);
        }
        if ((isReloadRequest || !this.myRequestedFiles.isEmpty()) && (file2 = fileSupplier.get()) != null) {
            this.myRequestedFiles.add(file2);
        }
        if (!isReloadRequest) {
            return null;
        }
        Object host = NettyKt.getHost((HttpRequest)request);
        if (host == null) {
            host = "localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        }
        return new StringBuilder().append("\n<script>\n").append("new WebSocket('ws://").append((String)host).append("/").append(RELOAD_WS_URL_PREFIX).append("').onmessage = function (msg) {\n").append("  if (msg.data === '").append(RELOAD_WS_REQUEST).append("') {\n").append("    window.location.reload();\n").append("  }\n").append("};\n").append("</script>");
    }

    public boolean isFileRequested(@NotNull VirtualFile file2) {
        if (file2 == null) {
            WebServerPageConnectionService.$$$reportNull$$$0(2);
        }
        return this.myRequestedFiles.contains(file2);
    }

    public void reloadAll() {
        ClientManager server = this.myServer;
        if (server != null) {
            server.send(-1, this.RELOAD_PAGE_MESSAGE.retainedDuplicate(), null);
        }
    }

    private void clientConnected() {
        if (this.ourListenersCount.incrementAndGet() == 1) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)ApplicationManager.getApplication(), (String)WebServerFileContentListener.class.getSimpleName());
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new WebServerFileContentListener(), disposable2);
            this.ourListenerDisposable = disposable2;
        }
    }

    private void clientDisconnected() {
        if (this.ourListenersCount.decrementAndGet() == 0) {
            Disposer.dispose((Disposable)Objects.requireNonNull(this.ourListenerDisposable));
            this.ourListenerDisposable = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileRequested";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileRequested";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class WebServerPageRequestHandler
    extends WebSocketHandshakeHandler {
        WebServerPageRequestHandler() {
        }

        @Override
        protected void serverCreated(@NotNull ClientManager server) {
            if (server == null) {
                WebServerPageRequestHandler.$$$reportNull$$$0(0);
            }
            WebServerPageConnectionService instance = WebServerPageConnectionService.getInstance();
            instance.myServer = server;
            instance.myRpcServer = new JsonRpcServer(server);
        }

        @Override
        public boolean isSupported(@NotNull FullHttpRequest request) {
            if (request == null) {
                WebServerPageRequestHandler.$$$reportNull$$$0(1);
            }
            return super.isSupported(request) && WebServerPageRequestHandler.checkPrefix((String)request.uri(), (String)WebServerPageConnectionService.RELOAD_WS_URL_PREFIX);
        }

        @Override
        @NotNull
        protected MessageServer getMessageServer() {
            JsonRpcServer jsonRpcServer = WebServerPageConnectionService.getInstance().myRpcServer;
            if (jsonRpcServer == null) {
                WebServerPageRequestHandler.$$$reportNull$$$0(2);
            }
            return jsonRpcServer;
        }

        @Override
        public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters2) {
            if (client == null) {
                WebServerPageRequestHandler.$$$reportNull$$$0(3);
            }
            WebServerPageConnectionService.getInstance().clientConnected();
        }

        @Override
        public void disconnected(@NotNull Client client) {
            if (client == null) {
                WebServerPageRequestHandler.$$$reportNull$$$0(4);
            }
            WebServerPageConnectionService.getInstance().clientDisconnected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$WebServerPageRequestHandler";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$WebServerPageRequestHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageServer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serverCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "connected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "disconnected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

