/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.liveReload;

import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;

class WebServerFileContentListener
implements AsyncFileListener {
    private static final AsyncFileListener.ChangeApplier RELOAD_ALL = new AsyncFileListener.ChangeApplier(){

        public void afterVfsChange() {
            WebServerPageConnectionService.getInstance().reloadAll();
        }
    };

    WebServerFileContentListener() {
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            WebServerFileContentListener.$$$reportNull$$$0(0);
        }
        boolean hasRelatedFileChanged = false;
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2 = vFileEvent.getFile();
            if (file2 == null || !WebServerPageConnectionService.getInstance().isFileRequested(file2)) continue;
            hasRelatedFileChanged = true;
            break;
        }
        if (!hasRelatedFileChanged) {
            return null;
        }
        return RELOAD_ALL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/builtInWebServer/liveReload/WebServerFileContentListener", "prepareChange"));
    }
}

