/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeSpeedSearch
extends TreeSpeedSearch {
    public final int SEARCH_DEPTH = Registry.intValue((String)"debugger.variablesView.rss.depth");
    private static final String COUNTER_PROPERTY = "debugger.speed.search.tree.option.hint.counter";
    private static final String CAN_EXPAND_PROPERTY = "debugger.speed.search.tree.option.can.expand";
    private MyActionButton mySearchOption = null;
    private ShortcutSet myOptionShortcutSet;

    XDebuggerTreeSpeedSearch(XDebuggerTree tree, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree, toStringConvertor, PropertiesComponent.getInstance().getBoolean(CAN_EXPAND_PROPERTY, false));
        this.setComparator(new SpeedSearchComparator(false, false){

            @Override
            public int matchingDegree(String pattern, String text2) {
                return this.matchingFragments(pattern, text2) != null ? 1 : 0;
            }

            @Override
            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.myRecentSearchText = pattern;
                int index2 = StringUtil.indexOfIgnoreCase((String)text2, (String)pattern, (int)0);
                return index2 >= 0 ? Collections.singleton(TextRange.from((int)index2, (int)pattern.length())) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch$1";
                objectArray[2] = "matchingFragments";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.setSearchOption((AnAction)new SearchCollapsedNodesAction());
    }

    @Override
    @Nullable
    protected Object findNextElement(String s) {
        Object current2;
        int selectedIndex = this.getSelectedIndex();
        ListIterator<Object> it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current2 = it.previous();
            it.next();
        } else {
            current2 = null;
        }
        String _s = s.trim();
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (!this.myCanExpand) {
            XDebuggerTreeSpeedSearch.showHint(this.mySearchOption);
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(0);
            while (i2.hasNext()) {
                Object element3 = i2.next();
                if (!this.isMatchingElement(element3, _s)) continue;
                return element3;
            }
        }
        return current2 != null && this.isMatchingElement(current2, _s) ? current2 : null;
    }

    @Override
    @Nullable
    protected Object findElement(@NotNull String s) {
        TreePath element2;
        int selectedIndex;
        if (s == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(0);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element2 = (TreePath)it.next();
            if (!((JTree)this.myComponent).isVisible(element2) || !this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (selectedIndex > 0 || this.myCanExpand) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element2 = (TreePath)it.next();
                if (!((JTree)this.myComponent).isVisible(element2) || !this.isMatchingElement(element2, _s)) continue;
                return element2;
            }
        }
        if (this.myCanExpand) {
            while (it.hasNext()) {
                element2 = (TreePath)it.next();
                if (!this.isMatchingElement(element2, _s)) continue;
                return element2;
            }
            if (selectedIndex > 0) {
                while (it.hasPrevious()) {
                    it.previous();
                }
                while (it.hasNext() && it.nextIndex() != selectedIndex) {
                    element2 = (TreePath)it.next();
                    if (!this.isMatchingElement(element2, _s)) continue;
                    return element2;
                }
            }
        }
        return null;
    }

    private static void showHint(JComponent component2) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        int counter = propertiesComponent.getInt(COUNTER_PROPERTY, 0);
        if (counter >= 1) {
            return;
        }
        JComponent label2 = HintUtil.createInformationLabel(new SimpleColoredText(FindBundle.message("find.expand.nodes", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES));
        LightweightHint hint = new LightweightHint(label2);
        Point point = new Point(component2.getWidth() / 2, 0);
        HintHint hintHint = new HintHint(component2, point).setPreferredPosition(Balloon.Position.above).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
        ApplicationManager.getApplication().invokeLater(() -> {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            hint.show(component2, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        });
        propertiesComponent.setValue(COUNTER_PROPERTY, counter + 1, 0);
    }

    @Override
    @NotNull
    protected JBIterable<TreePath> allPaths() {
        XDebuggerTreeNode root = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class);
        int initialLevel = root != null ? root.getPath().getPathCount() : 0;
        JBIterable jBIterable = ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)((JTree)this.myComponent)).expand(n -> ((JTree)this.myComponent).isExpanded((TreePath)n) || this.myCanExpand && n.getPathCount() - initialLevel < this.SEARCH_DEPTH)).traverse().filter(o -> !(o.getLastPathComponent() instanceof LoadingNode) && !o.equals(root.getPath()));
        if (jBIterable == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    protected void setSearchOption(AnAction searchOption) {
        this.mySearchOption = new MyActionButton(searchOption, false);
        this.myOptionShortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)searchOption);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.mySearchOption.isShowing() && this.myOptionShortcutSet != null) {
            KeyStroke eventKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
            boolean match2 = Arrays.stream(this.myOptionShortcutSet.getShortcuts()).filter(s -> s.isKeyboard()).map(s -> (KeyboardShortcut)s).anyMatch(s -> eventKeyStroke.equals(s.getFirstKeyStroke()) || eventKeyStroke.equals(s.getSecondKeyStroke()));
            if (match2) {
                this.mySearchOption.click();
                e.consume();
                return;
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    @NotNull
    protected SpeedSearchBase.SearchPopup createPopup(String s) {
        return new DebuggerSearchPopup(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyActionButton
    extends ActionButton {
        private MyActionButton(@NotNull AnAction action2, boolean focusable) {
            if (action2 == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            super(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(true);
            this.updateIcon();
        }

        @Override
        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext((Component)this);
        }

        @Override
        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @Override
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            return super.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch$MyActionButton", "<init>"));
        }
    }

    private class SearchCollapsedNodesAction
    extends ToggleAction
    implements TooltipDescriptionProvider {
        SearchCollapsedNodesAction() {
            super(FindBundle.message("find.expand.nodes", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.General.Tree);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.General.TreeHovered);
            this.getTemplatePresentation().setSelectedIcon(AllIcons.General.TreeSelected);
            ShortcutSet shortcut = ActionUtil.getMnemonicAsShortcut((AnAction)this);
            if (shortcut != null) {
                this.setShortcutSet(shortcut);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SearchCollapsedNodesAction.$$$reportNull$$$0(0);
            }
            return XDebuggerTreeSpeedSearch.this.myCanExpand;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SearchCollapsedNodesAction.$$$reportNull$$$0(1);
            }
            PropertiesComponent.getInstance().setValue(XDebuggerTreeSpeedSearch.CAN_EXPAND_PROPERTY, state);
            XDebuggerTreeSpeedSearch.this.setCanExpand(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch$SearchCollapsedNodesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class DebuggerSearchPopup
    extends SpeedSearchBase.SearchPopup {
        protected final JPanel myIconsPanel;

        protected DebuggerSearchPopup(String initialString) {
            super(initialString);
            this.myIconsPanel = new NonOpaquePanel();
            this.add((Component)this.myIconsPanel, "East");
            this.myIconsPanel.setBorder((Border)JBUI.Borders.emptyRight((int)5));
            if (XDebuggerTreeSpeedSearch.this.mySearchOption != null) {
                this.myIconsPanel.add(XDebuggerTreeSpeedSearch.this.mySearchOption);
            }
        }

        @Override
        protected void handleInsert(String newText) {
            if (XDebuggerTreeSpeedSearch.this.findElement(newText) == null) {
                this.mySearchField.setForeground(ERROR_FOREGROUND_COLOR);
                if (!XDebuggerTreeSpeedSearch.this.myCanExpand) {
                    XDebuggerTreeSpeedSearch.showHint(XDebuggerTreeSpeedSearch.this.mySearchOption);
                }
            } else {
                this.mySearchField.setForeground(FOREGROUND_COLOR);
            }
        }
    }
}

