/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerTreePanel
implements DnDSource {
    private final XDebuggerTree myTree;
    private final JPanel myMainPanel;

    public XDebuggerTreePanel(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Disposable parentDisposable, @Nullable XSourcePosition sourcePosition, @NotNull @NonNls String popupActionGroupId, @Nullable XValueMarkers<?, ?> markers) {
        if (project == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(2);
        }
        if (popupActionGroupId == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(3);
        }
        this.myTree = new XDebuggerTree(project, editorsProvider, sourcePosition, popupActionGroupId, markers);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myTree);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                XDebuggerTreePanel.this.myMainPanel.removeAll();
            }
        });
    }

    @NotNull
    public XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.myTree;
        if (xDebuggerTree == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(4);
        }
        return xDebuggerTree;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel2 = this.myMainPanel;
        if (jPanel2 == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(5);
        }
        return jPanel2;
    }

    public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
        return this.getNodesToDrag().length > 0;
    }

    private XValueNodeImpl[] getNodesToDrag() {
        return (XValueNodeImpl[])this.myTree.getSelectedNodes(XValueNodeImpl.class, node -> DebuggerUIUtil.hasEvaluationExpression((XValue)node.getValueContainer()));
    }

    public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
        return new DnDDragStartBean((Object)this.getNodesToDrag());
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
        XValueNodeImpl[] nodes;
        if (bean == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(6);
        }
        if ((nodes = this.getNodesToDrag()).length == 1) {
            return DnDAwareTree.getDragImage((Tree)this.myTree, nodes[0].getPath(), dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this.myTree, XDebuggerBundle.message((String)"xdebugger.drag.text.0.elements", (Object[])new Object[]{nodes.length}), dragOrigin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActionGroupId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

