/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.WinFocusStealer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DebuggerFocusManager
implements ExecutionListener,
RegistryValueListener,
ProjectManagerListener {
    private static final Logger LOG = Logger.getInstance(DebuggerFocusManager.class);
    private static final Key<List<ExecutionEnvironment>> ACTIVE_EXECUTIONS = Key.create((String)"DebuggerFocusManager.active.executions");
    private final RegistryValue mySetting = Registry.get((String)"debugger.mayBringFrameToFrontOnBreakpoint");
    private int mySessionCount;
    private boolean myFocusStealingEnabled;

    private DebuggerFocusManager() {
        Application application = ApplicationManager.getApplication();
        this.mySetting.addListener((RegistryValueListener)this, (Disposable)application);
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)this);
    }

    public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        if (executorId == null) {
            DebuggerFocusManager.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DebuggerFocusManager.$$$reportNull$$$0(1);
        }
        if ("Debug".equals(executorId)) {
            this.onDebugStarted(env);
        }
    }

    public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        if (executorId == null) {
            DebuggerFocusManager.$$$reportNull$$$0(2);
        }
        if (env == null) {
            DebuggerFocusManager.$$$reportNull$$$0(3);
        }
        if ("Debug".equals(executorId)) {
            this.onDebugFinished(env);
        }
    }

    public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
        if (executorId == null) {
            DebuggerFocusManager.$$$reportNull$$$0(4);
        }
        if (env == null) {
            DebuggerFocusManager.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            DebuggerFocusManager.$$$reportNull$$$0(6);
        }
        if ("Debug".equals(executorId)) {
            this.onDebugFinished(env);
        }
    }

    private void onDebugStarted(@NotNull ExecutionEnvironment env) {
        Project project;
        ArrayList<ExecutionEnvironment> executions;
        if (env == null) {
            DebuggerFocusManager.$$$reportNull$$$0(7);
        }
        if ((executions = (ArrayList<ExecutionEnvironment>)(project = env.getProject()).getUserData(ACTIVE_EXECUTIONS)) == null) {
            executions = new ArrayList<ExecutionEnvironment>();
            project.putUserData(ACTIVE_EXECUTIONS, executions);
        }
        executions.add(env);
        this.update(1);
    }

    private void onDebugFinished(@NotNull ExecutionEnvironment env) {
        Project project;
        List executions;
        if (env == null) {
            DebuggerFocusManager.$$$reportNull$$$0(8);
        }
        if ((executions = Objects.requireNonNull((List)(project = env.getProject()).getUserData(ACTIVE_EXECUTIONS))).remove(env)) {
            this.update(-1);
        } else {
            LOG.error("Unexpected event for " + env);
        }
    }

    public void afterValueChanged(@NotNull RegistryValue value2) {
        if (value2 == null) {
            DebuggerFocusManager.$$$reportNull$$$0(9);
        }
        this.update(0);
    }

    public void projectClosed(@NotNull Project project) {
        List executions;
        if (project == null) {
            DebuggerFocusManager.$$$reportNull$$$0(10);
        }
        if ((executions = (List)project.getUserData(ACTIVE_EXECUTIONS)) != null) {
            for (ExecutionEnvironment ignored : executions) {
                this.update(-1);
            }
            project.putUserData(ACTIVE_EXECUTIONS, null);
        }
    }

    private synchronized void update(int sessionCountDelta) {
        boolean shouldBeEnabled;
        this.mySessionCount += sessionCountDelta;
        boolean bl = shouldBeEnabled = this.mySessionCount > 0 && this.mySetting.asBoolean();
        if (shouldBeEnabled != this.myFocusStealingEnabled) {
            this.myFocusStealingEnabled = shouldBeEnabled;
            WinFocusStealer.setFocusStealingEnabled(this.myFocusStealingEnabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerFocusManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processStartScheduled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processNotStarted";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onDebugStarted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onDebugFinished";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "afterValueChanged";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

