/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.pinned.items.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.pinned.items.PinToTopMemberValue;
import com.intellij.xdebugger.impl.pinned.items.PinToTopUtilKt;
import com.intellij.xdebugger.impl.pinned.items.PinnedItemInfo;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import icons.PlatformDebuggerImplIcons;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/actions/XDebuggerPinToTopAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "()V", "perform", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.debugger.impl"})
public final class XDebuggerPinToTopAction
extends XDebuggerTreeActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull AnActionEvent e) {
        XValueNodeImpl node;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XValueNodeImpl xValueNodeImpl = node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        Object object = xValueNodeImpl != null ? (XValue)xValueNodeImpl.getValueContainer() : null;
        if (!(object instanceof PinToTopMemberValue)) {
            object = null;
        }
        PinToTopMemberValue valueContainer = (PinToTopMemberValue)object;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        Project project = e.getProject();
        if (valueContainer == null || project == null) {
            presentation3.setEnabledAndVisible(false);
            return;
        }
        XDebuggerPinToTopManager pinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(project);
        if (!pinToTopManager.isPinToTopSupported(node)) {
            presentation3.setEnabledAndVisible(false);
            return;
        }
        presentation3.setVisible(true);
        presentation3.setEnabled(PinToTopUtilKt.canBePinned(node));
        presentation3.setIcon(pinToTopManager.isItemPinned(node) ? PlatformDebuggerImplIcons.PinToTop.UnpinnedItem : PlatformDebuggerImplIcons.PinToTop.PinnedItem);
        presentation3.setText(pinToTopManager.isItemPinned(node) ? XDebuggerBundle.message((String)"xdebugger.unpin.action", (Object[])new Object[0]) : XDebuggerBundle.message((String)"xdebugger.pin.to.top.action", (Object[])new Object[0]));
    }

    @Override
    protected void perform(@Nullable XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (node == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (!PinToTopUtilKt.canBePinned(node)) {
            return;
        }
        XDebuggerPinToTopManager pinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(project2);
        PinnedItemInfo pinnedItemInfo = PinToTopUtilKt.getPinInfo(node);
        if (pinnedItemInfo == null) {
            return;
        }
        PinnedItemInfo pinInfo = pinnedItemInfo;
        if (PinToTopUtilKt.isPinned(node, pinToTopManager)) {
            pinToTopManager.removeItemInfo(pinInfo);
        } else {
            pinToTopManager.addItemInfo(pinInfo);
        }
        XDebuggerUtilImpl.rebuildTreeAndViews(node.getTree());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/actions/XDebuggerPinToTopAction$Companion;", "", "()V", "pinToTopField", "", "event", "Ljava/awt/event/MouseEvent;", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        public final void pinToTopField(@Nullable MouseEvent event, @NotNull XValueNodeImpl node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ActionManager.getInstance().getAction("XDebugger.PinToTop").actionPerformed(AnActionEvent.createFromInputEvent((InputEvent)event, (String)XDebuggerPinToTopAction.class.getName(), (Presentation)new Presentation(), (DataContext)new DataContext(node){
                final /* synthetic */ XValueNodeImpl $node;

                @Nullable
                public Object getData(@NotNull String dataId) {
                    Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                    if (XDebuggerTree.XDEBUGGER_TREE_KEY.is(dataId)) {
                        return this.$node.getTree();
                    }
                    if (CommonDataKeys.PROJECT.is(dataId)) {
                        XDebuggerTree xDebuggerTree = this.$node.getTree();
                        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"node.tree");
                        return xDebuggerTree.getProject();
                    }
                    return null;
                }
                {
                    this.$node = $captured_local_variable$0;
                }
            }));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

