/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

public final class XDebuggerInlayUtil {
    public static final String INLINE_HINTS_DELIMETER = ":";

    public static boolean createLineEndInlay(XValueNodeImpl valueNode, @NotNull XDebugSession session2, @NotNull VirtualFile file2, @NotNull XSourcePosition position, Document document) {
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        if (position == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        if (valueNode.getValuePresentation() != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                int offset = document.getLineEndOffset(position.getLine());
                Project project = session2.getProject();
                FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
                if (editor instanceof TextEditor) {
                    Editor e = ((TextEditor)editor).getEditor();
                    boolean customNode = valueNode instanceof InlineWatchNodeImpl;
                    InlineDebugRenderer renderer = new InlineDebugRenderer(valueNode, position, session2, e);
                    Inlay<InlineDebugRenderer> inlay = ((InlayModelImpl)e.getInlayModel()).addAfterLineEndDebuggerHint(offset, customNode, renderer);
                    if (customNode) {
                        ((InlineWatchNodeImpl)valueNode).inlayCreated(inlay);
                    }
                }
            }, session2.getProject().getDisposed());
            return true;
        }
        return false;
    }

    public static void clearInlays(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditor[] editors2;
            for (FileEditor editor : editors2 = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                e.getInlayModel().getAfterLineEndElementsInRange(0, e.getDocument().getTextLength(), InlineDebugRenderer.class).forEach(Disposer::dispose);
            }
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineEndInlay";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

