/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class BreakpointsTreeCellRenderer {
    private static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES_BOLD = SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);

    BreakpointsTreeCellRenderer() {
    }

    private static void customizeRenderer(Project project, Object value2, boolean selected2, boolean expanded, ColoredTreeCellRenderer renderer) {
        if (value2 instanceof BreakpointItemNode) {
            BreakpointItemNode node = (BreakpointItemNode)((Object)value2);
            BreakpointItem breakpoint = node.getBreakpointItem();
            breakpoint.setupRenderer(renderer, project, selected2);
        } else if (value2 instanceof BreakpointsGroupNode) {
            Object group2 = ((BreakpointsGroupNode)((Object)value2)).getGroup();
            renderer.setIcon(group2.getIcon(expanded));
            if (group2 instanceof XBreakpointCustomGroup && ((XBreakpointCustomGroup)((Object)group2)).isDefault()) {
                renderer.append(group2.getName(), SIMPLE_CELL_ATTRIBUTES_BOLD);
            } else {
                renderer.append(group2.getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            }
        }
    }

    public static class BreakpointsSimpleTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Project myProject;

        public BreakpointsSimpleTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                BreakpointsSimpleTreeCellRenderer.$$$reportNull$$$0(0);
            }
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value2, selected2, expanded, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/breakpoints/ui/tree/BreakpointsTreeCellRenderer$BreakpointsSimpleTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    public static class BreakpointsCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Project myProject;

        public BreakpointsCheckboxTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value2, selected2, expanded, this.getTextRenderer());
        }
    }
}

