/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ConfigurationState;
import com.intellij.xdebugger.impl.InlineWatchState;
import com.intellij.xdebugger.impl.WatchState;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchInplaceEditor;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerWatchesManager {
    private final Map<String, List<XExpression>> watches;
    private final Map<String, Set<InlineWatch>> inlineWatches;
    private final MergingUpdateQueue myInlinesUpdateQueue;
    private Project myProject;

    public XDebuggerWatchesManager(@NotNull Project project) {
        if (project == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(0);
        }
        this.watches = new ConcurrentHashMap<String, List<XExpression>>();
        this.inlineWatches = new ConcurrentHashMap<String, Set<InlineWatch>>();
        this.myProject = project;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        editorEventMulticaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
        this.myInlinesUpdateQueue = new MergingUpdateQueue("XInlineWatches", 300, true, null, (Disposable)project);
    }

    @NotNull
    public List<XExpression> getWatches(String confName) {
        List list2 = ContainerUtil.notNullize(this.watches.get(confName));
        if (list2 == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void setWatches(@NotNull String configurationName, @NotNull List<XExpression> expressions) {
        if (configurationName == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(2);
        }
        if (expressions == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(3);
        }
        if (expressions.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, expressions);
        }
    }

    public List<InlineWatch> getInlineWatches() {
        return this.inlineWatches.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    @NotNull
    public WatchesManagerState saveState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(4);
        }
        List<ConfigurationState> expressions = state.getExpressions();
        expressions.clear();
        this.watches.forEach((key, value2) -> expressions.add(new ConfigurationState((String)key, (List<? extends XExpression>)value2)));
        List<InlineWatchState> inlineExpressionStates = state.getInlineExpressionStates();
        inlineExpressionStates.clear();
        this.inlineWatches.values().stream().flatMap(l -> l.stream()).forEach(value2 -> inlineExpressionStates.add(new InlineWatchState(value2.getExpression(), value2.getLine(), value2.getPosition().getFile().getUrl())));
        WatchesManagerState watchesManagerState = state;
        if (watchesManagerState == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(5);
        }
        return watchesManagerState;
    }

    public void clearContext() {
        this.watches.clear();
        this.inlineWatches.clear();
    }

    public void loadState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(6);
        }
        this.clearContext();
        for (ConfigurationState configurationState : state.getExpressions()) {
            List<WatchState> expressionStates = configurationState.getExpressionStates();
            if (ContainerUtil.isEmpty(expressionStates)) continue;
            this.watches.put(configurationState.getName(), ContainerUtil.mapNotNull(expressionStates, XExpressionState::toXExpression));
        }
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
        for (InlineWatchState inlineWatchState : state.getInlineExpressionStates()) {
            if (inlineWatchState == null || inlineWatchState.getFileUrl() == null || inlineWatchState.getWatchState() == null) continue;
            VirtualFile file2 = fileManager.findFileByUrl(inlineWatchState.getFileUrl());
            XSourcePosition position = debuggerUtil.createPosition(file2, inlineWatchState.getLine());
            XExpression expression = inlineWatchState.getWatchState().toXExpression();
            InlineWatch watch = new InlineWatch(expression, position);
            this.inlineWatches.computeIfAbsent(inlineWatchState.getFileUrl(), k -> new HashSet()).add(watch);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.inlineWatches.values().stream().flatMap(set2 -> set2.stream()).forEach(InlineWatch::setMarker), ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    public void showInplaceEditor(@NotNull XSourcePosition presentationPosition, @NotNull Editor mainEditor, @NotNull XDebugSession session2, @Nullable XExpression expression) {
        if (presentationPosition == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(7);
        }
        if (mainEditor == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(8);
        }
        if (session2 == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(9);
        }
        InlineWatchInplaceEditor inplaceEditor = new InlineWatchInplaceEditor(presentationPosition, session2, mainEditor, expression);
        inplaceEditor.show();
    }

    public void inlineWatchesRemoved(List<InlineWatch> removed, XInlineWatchesView watchesView) {
        this.inlineWatches.values().forEach(set2 -> set2.removeAll(removed));
        this.getWatchesViews().filter(v -> v != watchesView).forEach(view -> view.removeInlineWatches(removed));
    }

    public void addInlineWatchExpression(@NotNull XExpression expression, int index2, XSourcePosition position, boolean navigateToWatchNode) {
        if (expression == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        InlineWatch watch = new InlineWatch(expression, position);
        watch.setMarker();
        String fileUrl = position.getFile().getUrl();
        this.inlineWatches.computeIfAbsent(fileUrl, k -> new HashSet()).add(watch);
        this.getWatchesViews().forEach(view -> view.addInlineWatchExpression(watch, index2, navigateToWatchNode));
    }

    private void updateInlines(@NotNull Document document) {
        Collection<InlineWatch> inlines;
        if (document == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(11);
        }
        if ((inlines = this.getDocumentInlines(document)).isEmpty()) {
            return;
        }
        HashSet<InlineWatch> toRemove2 = new HashSet<InlineWatch>();
        for (InlineWatch inlineWatch : inlines) {
            inlineWatch.updatePosition();
            if (inlineWatch.isValid()) continue;
            toRemove2.add(inlineWatch);
        }
        this.removeInlines(toRemove2);
    }

    private void removeInlines(Collection<InlineWatch> remove) {
        for (InlineWatch watch : remove) {
            this.inlineWatches.get(watch.getPosition().getFile().getUrl()).remove(watch);
        }
        this.getWatchesViews().forEach(view -> view.removeInlineWatches(remove));
    }

    private Stream<XInlineWatchesView> getWatchesViews() {
        return Arrays.stream(XDebuggerManager.getInstance((Project)this.myProject).getDebugSessions()).map(s -> ((XDebugSessionImpl)s).getSessionTab()).filter(t -> t != null && t.getWatchesView() instanceof XInlineWatchesView).map(t -> (XInlineWatchesView)((Object)t.getWatchesView()));
    }

    @NotNull
    public Collection<InlineWatch> getDocumentInlines(Document document) {
        Set<InlineWatch> inlineWatches;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && (inlineWatches = this.inlineWatches.get(file2.getUrl())) != null) {
            return new ArrayList<InlineWatch>(inlineWatches);
        }
        List<InlineWatch> list2 = Collections.emptyList();
        if (list2 == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatches";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentInlines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showInplaceEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateInlines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Document document;
            Collection<InlineWatch> inlines;
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!(inlines = XDebuggerWatchesManager.this.getDocumentInlines(document = e.getDocument())).isEmpty()) {
                XDebuggerWatchesManager.this.myInlinesUpdateQueue.queue(new Update(document){

                    public void run() {
                        XDebuggerWatchesManager.this.updateInlines(document);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/XDebuggerWatchesManager$MyDocumentListener", "documentChanged"));
        }
    }
}

