/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.StorageSnapshotCache;
import com.intellij.workspaceModel.storage.impl.ValuesCache;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00150\u001a2\u0006\u0010\u001b\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0016J5\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00150\u001a2\u0006\u0010\u001b\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageOnBuilder;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;)V", "current", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "getCurrent", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/workspaceModel/storage/impl/StorageSnapshotCache;", "valuesCache", "Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "getCurrentSnapshot", "intellij.platform.workspaceModel.storage"})
public final class VersionedEntityStorageOnBuilder
implements VersionedEntityStorage {
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;
    private final WorkspaceEntityStorageBuilder builder;

    private final ValuesCache getValuesCache() {
        return this.getCurrentSnapshot().getCache();
    }

    @Override
    public long getVersion() {
        return this.builder.getModificationCount();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorage getCurrent() {
        return this.getCurrentSnapshot().getStorage();
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return this.getValuesCache().cachedValue(value2, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return this.getValuesCache().cachedValue(value2, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getValuesCache().clearCachedValue(value2);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getValuesCache().clearCachedValue(value2, parameter);
    }

    private final StorageSnapshotCache getCurrentSnapshot() {
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || this.builder.getModificationCount() != snapshotCache.getStorageVersion()) {
            StorageSnapshotCache storageSnapshotCache = new StorageSnapshotCache(this.builder.getModificationCount(), new ValuesCache(), this.builder.toStorage());
            this.currentSnapshot.set(storageSnapshotCache);
            return storageSnapshotCache;
        }
        return snapshotCache;
    }

    public VersionedEntityStorageOnBuilder(@NotNull WorkspaceEntityStorageBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.builder = builder2;
        this.currentSnapshot = new AtomicReference();
    }
}

