/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.impl.StorageSnapshotCache;
import com.intellij.workspaceModel.storage.impl.ValuesCache;
import com.intellij.workspaceModel.storage.impl.VersionedStorageChangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ5\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u00190\u001e2\u0006\u0010\u001f\u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016J5\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u00190\u001e2\u0006\u0010\u001f\u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010#JX\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00032 \u0010&\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0)0'2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\"0,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\"0,J\u000e\u0010/\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "initialStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;)V", "current", "getCurrent", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "currentPointer", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/workspaceModel/storage/impl/StorageSnapshotCache;", "pointer", "getPointer", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "valuesCache", "Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "replace", "newStorage", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "beforeChanged", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "afterChanged", "replaceSilently", "Current", "intellij.platform.workspaceModel.storage"})
public class VersionedEntityStorageImpl
implements VersionedEntityStorage {
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;
    private volatile Current currentPointer;

    private final ValuesCache getValuesCache() {
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || this.getVersion() != snapshotCache.getStorageVersion()) {
            ValuesCache cache2 = new ValuesCache();
            this.currentSnapshot.set(new StorageSnapshotCache(this.getVersion(), cache2, this.getCurrent()));
            return cache2;
        }
        return snapshotCache.getCache();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorage getCurrent() {
        return this.currentPointer.getStorage();
    }

    @Override
    public long getVersion() {
        return this.currentPointer.getVersion();
    }

    @NotNull
    public final Current getPointer() {
        return this.currentPointer;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return this.getValuesCache().cachedValue(value2, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return this.getValuesCache().cachedValue(value2, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getValuesCache().clearCachedValue(value2);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getValuesCache().clearCachedValue(value2, parameter);
    }

    public final synchronized void replace(@NotNull WorkspaceEntityStorage newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes, @NotNull Function1<? super VersionedStorageChange, Unit> beforeChanged2, @NotNull Function1<? super VersionedStorageChange, Unit> afterChanged) {
        Intrinsics.checkNotNullParameter((Object)newStorage, (String)"newStorage");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(beforeChanged2, (String)"beforeChanged");
        Intrinsics.checkNotNullParameter(afterChanged, (String)"afterChanged");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        VersionedStorageChangeImpl change = new VersionedStorageChangeImpl(this, oldCopy.getStorage(), newStorage, changes);
        beforeChanged2.invoke((Object)change);
        this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
        afterChanged.invoke((Object)change);
    }

    public final synchronized void replaceSilently(@NotNull WorkspaceEntityStorage newStorage) {
        Intrinsics.checkNotNullParameter((Object)newStorage, (String)"newStorage");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
    }

    public VersionedEntityStorageImpl(@NotNull WorkspaceEntityStorage initialStorage) {
        Intrinsics.checkNotNullParameter((Object)initialStorage, (String)"initialStorage");
        this.currentSnapshot = new AtomicReference();
        this.currentPointer = new Current(0L, initialStorage);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "", "version", "", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "(JLcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;)V", "getStorage", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "getVersion", "()J", "intellij.platform.workspaceModel.storage"})
    public static final class Current {
        private final long version;
        @NotNull
        private final WorkspaceEntityStorage storage;

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final WorkspaceEntityStorage getStorage() {
            return this.storage;
        }

        public Current(long version2, @NotNull WorkspaceEntityStorage storage2) {
            Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
            this.version = version2;
            this.storage = storage2;
        }
    }
}

