/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.bridgeEntities;

import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import com.intellij.workspaceModel.storage.impl.WithAssertableConsistency;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/storage/bridgeEntities/JavaSourceRootEntityData;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/JavaSourceRootEntity;", "Lcom/intellij/workspaceModel/storage/impl/WithAssertableConsistency;", "()V", "generated", "", "getGenerated", "()Z", "setGenerated", "(Z)V", "packagePrefix", "", "getPackagePrefix", "()Ljava/lang/String;", "setPackagePrefix", "(Ljava/lang/String;)V", "assertConsistency", "", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "createEntity", "snapshot", "intellij.platform.workspaceModel.storage"})
public final class JavaSourceRootEntityData
extends WorkspaceEntityData<JavaSourceRootEntity>
implements WithAssertableConsistency {
    private boolean generated;
    public String packagePrefix;

    public final boolean getGenerated() {
        return this.generated;
    }

    public final void setGenerated(boolean bl) {
        this.generated = bl;
    }

    @NotNull
    public final String getPackagePrefix() {
        String string = this.packagePrefix;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packagePrefix");
        }
        return string;
    }

    public final void setPackagePrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packagePrefix = string;
    }

    @Override
    @NotNull
    public JavaSourceRootEntity createEntity(@NotNull WorkspaceEntityStorage snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        String string = this.packagePrefix;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packagePrefix");
        }
        JavaSourceRootEntity javaSourceRootEntity = new JavaSourceRootEntity(this.generated, string);
        boolean bl = false;
        boolean bl2 = false;
        JavaSourceRootEntity it = javaSourceRootEntity;
        boolean bl3 = false;
        this.addMetaData((WorkspaceEntity)it, snapshot);
        return javaSourceRootEntity;
    }

    @Override
    public void assertConsistency(@NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        JavaSourceRootEntity thisEntity = this.createEntity(storage2);
        SourceRootEntity attachedSourceRoot = thisEntity.getSourceRoot();
        boolean bl = Intrinsics.areEqual((Object)thisEntity.getEntitySource(), (Object)attachedSourceRoot.getEntitySource());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = StringsKt.trimMargin$default((String)("\n      |Entity source of source root entity and it's java source root entity differs. \n      |   Source root entity source: " + attachedSourceRoot.getEntitySource() + "\n      |   Java source root source: " + thisEntity.getEntitySource() + "\n      |   Source root entity: " + attachedSourceRoot + "\n      |   Java root entity: " + thisEntity + "\n      "), null, (int)1, null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

