/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.watcher;

import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootsChangeListener;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.EntityWithVirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.RootsChangeWatcher;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.VirtualFileUrlWatcher;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "virtualFileUrlWatcher", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/VirtualFileUrlWatcher;", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class RootsChangeWatcher {
    private final ModuleManager moduleManager;
    private final VirtualFileUrlManager virtualFileManager;
    private final VirtualFileUrlWatcher virtualFileUrlWatcher;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RootsChangeWatcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.moduleManager = ModuleManager.getInstance((Project)this.project);
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.virtualFileUrlWatcher = VirtualFileUrlWatcher.Companion.getInstance(this.project);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){
            @Nullable
            private volatile ProjectRootManagerImpl.RootsChangeType result;
            @NotNull
            private final ConcurrentList<Pair<String, String>> changedUrlsList;
            @NotNull
            private final ConcurrentList<Pair<Module, Path>> changedModuleStorePaths;

            @Nullable
            public final ProjectRootManagerImpl.RootsChangeType getResult() {
                return this.result;
            }

            public final void setResult(@Nullable ProjectRootManagerImpl.RootsChangeType rootsChangeType) {
                this.result = rootsChangeType;
            }

            @NotNull
            public final ConcurrentList<Pair<String, String>> getChangedUrlsList() {
                return this.changedUrlsList;
            }

            @NotNull
            public final ConcurrentList<Pair<Module, Path>> getChangedModuleStorePaths() {
                return this.changedModuleStorePaths;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                this.result = null;
                this.changedUrlsList.clear();
                this.changedModuleStorePaths.clear();
                WorkspaceEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(this.getProject()).getEntityStorage().getCurrent();
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void oldUrl;
                    Pair<String, String> pair;
                    String parentUrl;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    VFileEvent vFileEvent = event;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
                        VirtualFile virtualFile = ((VFileDeleteEvent)event).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                        String string = virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.file.url");
                        this.calculateRootsChangeTypeIfNeeded(entityStorage, virtualFileUrlManager.fromUrl(string), ProjectRootManagerImpl.RootsChangeType.ROOTS_REMOVED);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCreateEvent) {
                        String string;
                        VirtualFile virtualFile = ((VFileCreateEvent)event).getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.parent");
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getUrl(), (String)"event.parent.url");
                        int protocolEnd = StringsKt.indexOf$default((CharSequence)parentUrl, (String)"://", (int)0, (boolean)false, (int)6, null);
                        if (protocolEnd != -1) {
                            String string2 = ((VFileCreateEvent)event).getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.path");
                            if (StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) {
                                string = "jar://" + ((VFileCreateEvent)event).getPath() + "!/";
                            } else {
                                StringBuilder stringBuilder = new StringBuilder();
                                String string3 = parentUrl;
                                int n = 0;
                                boolean bl2 = false;
                                String string4 = string3;
                                if (string4 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string5 = string4.substring(n, protocolEnd);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                string = stringBuilder.append(string5).append("://").append(((VFileCreateEvent)event).getPath()).toString();
                            }
                        } else {
                            String string6 = VfsUtilCore.pathToUrl((String)((VFileCreateEvent)event).getPath());
                            string = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"VfsUtilCore.pathToUrl(event.path)");
                        }
                        String url = string;
                        VirtualFileUrl virtualFileUrl = virtualFileManager.fromUrl(url);
                        this.calculateRootsChangeTypeIfNeeded(entityStorage, virtualFileUrl, ProjectRootManagerImpl.RootsChangeType.ROOTS_ADDED);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCopyEvent) {
                        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
                        String string = VfsUtilCore.pathToUrl((String)((VFileCopyEvent)event).getPath());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.path)");
                        this.calculateRootsChangeTypeIfNeeded(entityStorage, virtualFileUrlManager.fromUrl(string), ProjectRootManagerImpl.RootsChangeType.ROOTS_ADDED);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
                    if (event instanceof VFilePropertyChangeEvent) {
                        this.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    if (this.getUrls(event) == null) {
                        continue;
                    }
                    parentUrl = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    if (!(Intrinsics.areEqual((Object)oldUrl, (Object)newUrl) ^ true)) continue;
                    this.calculateRootsChangeTypeIfNeeded(entityStorage, virtualFileManager.fromUrl((String)oldUrl), ProjectRootManagerImpl.RootsChangeType.GENERIC);
                    this.calculateRootsChangeTypeIfNeeded(entityStorage, virtualFileManager.fromUrl(newUrl), ProjectRootManagerImpl.RootsChangeType.GENERIC);
                    this.changedUrlsList.add((Object)new Pair((Object)oldUrl, (Object)newUrl));
                }
                return new AsyncFileListener.ChangeApplier(this){
                    final /* synthetic */ 1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public void beforeVfsChange() {
                        Iterable $this$forEach$iv = (Iterable)this.this$0.getChangedUrlsList();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void oldUrl;
                            Pair $dstr$oldUrl$newUrl = (Pair)element$iv;
                            boolean bl = false;
                            String string = (String)$dstr$oldUrl$newUrl.component1();
                            String newUrl = (String)$dstr$oldUrl$newUrl.component2();
                            RootsChangeWatcher.access$getVirtualFileUrlWatcher$p(this.this$0.this).onVfsChange((String)oldUrl, newUrl);
                        }
                        1.access$fireRootsChangeEvent(this.this$0, true);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void afterVfsChange() {
                        Module oldUrl;
                        Iterable $this$forEach$iv = (Iterable)this.this$0.getChangedUrlsList();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Pair $dstr$oldUrl$newUrl = (Pair)element$iv;
                            boolean bl = false;
                            String string = (String)$dstr$oldUrl$newUrl.component1();
                            String newUrl = (String)$dstr$oldUrl$newUrl.component2();
                            1.access$updateModuleName(this.this$0, (String)oldUrl, newUrl);
                        }
                        $this$forEach$iv = (Iterable)this.this$0.getChangedModuleStorePaths();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void module;
                            Pair $dstr$module$path = (Pair)element$iv;
                            boolean bl = false;
                            oldUrl = (Module)$dstr$module$path.component1();
                            Path path = (Path)$dstr$module$path.component2();
                            ServiceKt.getStateStore((ComponentManager)module).setPath(path);
                            ClasspathStorage.modulePathChanged((Module)module);
                        }
                        Collection collection = (Collection)this.this$0.getChangedModuleStorePaths();
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            RootsChangeWatcher.access$getModuleManager$p(this.this$0.this).incModificationCount();
                        }
                        1.fireRootsChangeEvent$default(this.this$0, false, 1, null);
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
            }

            public final boolean isUnderJarDirectory(@NotNull WorkspaceEntityStorage storage2, @NotNull VirtualFileUrl virtualFileUrl) {
                Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
                Intrinsics.checkNotNullParameter((Object)virtualFileUrl, (String)"virtualFileUrl");
                VirtualFileUrlIndex virtualFileUrlIndex = storage2.getVirtualFileUrlIndex();
                if (virtualFileUrlIndex == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex");
                }
                Set<VirtualFileUrl> indexedJarDirectories = ((VirtualFileIndex)virtualFileUrlIndex).getIndexedJarDirectories();
                VirtualFileUrl parentVirtualFileUrl = virtualFileUrl;
                while (parentVirtualFileUrl != null && !indexedJarDirectories.contains(parentVirtualFileUrl)) {
                    parentVirtualFileUrl = virtualFileManager.getParentVirtualUrl(parentVirtualFileUrl);
                }
                return parentVirtualFileUrl != null && indexedJarDirectories.contains(parentVirtualFileUrl);
            }

            public final void calculateRootsChangeTypeIfNeeded(@NotNull WorkspaceEntityStorage storage2, @NotNull VirtualFileUrl virtualFileUrl, @NotNull ProjectRootManagerImpl.RootsChangeType currentRootsChangeType) {
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
                    Intrinsics.checkNotNullParameter((Object)virtualFileUrl, (String)"virtualFileUrl");
                    Intrinsics.checkNotNullParameter((Object)((Object)currentRootsChangeType), (String)"currentRootsChangeType");
                    if (this.result == ProjectRootManagerImpl.RootsChangeType.GENERIC) {
                        return;
                    }
                    if (this.isUnderJarDirectory(storage2, virtualFileUrl)) {
                        this.result = ProjectRootsChangeListener.Companion.calculateRootsChangeType$intellij_platform_lang_impl(this.result, currentRootsChangeType);
                        return;
                    }
                    boolean bl2 = false;
                    List affectedEntities = new ArrayList();
                    VirtualFileUrlWatcher.Companion.calculateAffectedEntities$intellij_platform_lang_impl(storage2, virtualFileUrl, affectedEntities);
                    List<VirtualFileUrl> list2 = virtualFileUrl.getSubTreeFileUrls();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"virtualFileUrl.subTreeFileUrls");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VirtualFileUrl fileUrl = (VirtualFileUrl)element$iv;
                        boolean bl3 = false;
                        VirtualFileUrl virtualFileUrl2 = fileUrl;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"fileUrl");
                        VirtualFileUrlWatcher.Companion.calculateAffectedEntities$intellij_platform_lang_impl(storage2, virtualFileUrl2, affectedEntities);
                    }
                    Iterable $this$none$iv = affectedEntities;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            EntityWithVirtualFileUrl it = (EntityWithVirtualFileUrl)element$iv;
                            boolean bl4 = false;
                            if (!ProjectRootsChangeListener.Companion.shouldFireRootsChanged$intellij_platform_lang_impl(it.getEntity(), this.getProject())) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                this.result = ProjectRootsChangeListener.Companion.calculateRootsChangeType$intellij_platform_lang_impl(this.result, currentRootsChangeType);
            }

            private final boolean isRootChangeForbidden() {
                if (this.getProject().isDisposed()) {
                    return true;
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
                if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
                    return true;
                }
                return ((ProjectRootManagerBridge)projectRootManager).isFiringEvent();
            }

            private final void fireRootsChangeEvent(boolean beforeRootsChanged) {
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                if (this.result != null && !this.isRootChangeForbidden()) {
                    ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
                    if (projectRootManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge");
                    }
                    ProjectRootManagerBridge projectRootManager2 = (ProjectRootManagerBridge)projectRootManager;
                    if (beforeRootsChanged) {
                        projectRootManager2.getRootsChanged().beforeRootsChanged();
                    } else {
                        ProjectRootManagerImpl.BatchSession<ProjectRootManagerImpl.RootsChangeType> batchSession = projectRootManager2.getRootsChanged();
                        ProjectRootManagerImpl.RootsChangeType rootsChangeType = this.result;
                        Intrinsics.checkNotNull((Object)((Object)rootsChangeType));
                        batchSession.rootsChanged(rootsChangeType);
                    }
                }
            }

            static /* synthetic */ void fireRootsChangeEvent$default(1 var0, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                var0.fireRootsChangeEvent(bl);
            }

            private final void updateModuleName(String oldUrl, String newUrl) {
                String newModuleName;
                if (!this.isImlFile(oldUrl) || !this.isImlFile(newUrl)) {
                    return;
                }
                String oldModuleName = ModulePathKt.getModuleNameByFilePath(oldUrl);
                if (Intrinsics.areEqual((Object)oldModuleName, (Object)(newModuleName = ModulePathKt.getModuleNameByFilePath(newUrl)))) {
                    return;
                }
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.getProject());
                ModuleEntity moduleEntity = (ModuleEntity)workspaceModel.getEntityStorage().getCurrent().resolve(new ModuleId(oldModuleName));
                if (moduleEntity == null) {
                    return;
                }
                ModuleEntity moduleEntity2 = moduleEntity;
                workspaceModel.updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, ModuleEntity>(moduleEntity2, newModuleName){
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    final /* synthetic */ String $newModuleName;

                    @NotNull
                    public final ModuleEntity invoke(@NotNull WorkspaceEntityStorageBuilder diff) {
                        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                        return (ModuleEntity)diff.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)this.$moduleEntity, (Function1)new Function1<ModifiableModuleEntity, Unit>(this){
                            final /* synthetic */ updateModuleName.1 this$0;

                            public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                                $this$modifyEntity.setName(this.this$0.$newModuleName);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.$moduleEntity = moduleEntity;
                        this.$newModuleName = string;
                        super(1);
                    }
                });
            }

            private final void propertyChanged(VFilePropertyChangeEvent event) {
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                if (!virtualFile.isDirectory() || event.getRequestor() instanceof StateStorage || Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") ^ true) {
                    return;
                }
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                Object object = virtualFile2.getParent();
                if (object == null || (object = object.getPath()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.file.parent?.path ?: return");
                Object parentPath = object;
                String newAncestorPath = (String)parentPath + '/' + event.getNewValue();
                String oldAncestorPath = (String)parentPath + '/' + event.getOldValue();
                ModuleManager moduleManager = moduleManager;
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"moduleManager");
                Module[] moduleArray = moduleManager.getModules();
                int n = moduleArray.length;
                for (int j = 0; j < n; ++j) {
                    String moduleFilePath;
                    Module module;
                    Module module2 = module = moduleArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                    if (!module2.isLoaded() || module.isDisposed()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)module.getModuleFilePath(), (String)"module.moduleFilePath");
                    if (!FileUtil.isAncestor((String)oldAncestorPath, (String)moduleFilePath, (boolean)true)) continue;
                    this.changedModuleStorePaths.add((Object)new Pair((Object)module, (Object)Paths.get(newAncestorPath, FileUtil.getRelativePath((String)oldAncestorPath, (String)moduleFilePath, (char)'/'))));
                }
            }

            private final boolean isImlFile(String $this$isImlFile) {
                return Intrinsics.areEqual((Object)Files.getFileExtension((String)$this$isImlFile), (Object)"iml");
            }

            private final Pair<String, String> getUrls(VFileEvent event) {
                String oldUrl = null;
                String newUrl = null;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string2 = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string2;
                } else if (vFileEvent instanceof VFileMoveEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string3 = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string3;
                } else {
                    return null;
                }
                return TuplesKt.to((Object)oldUrl, (Object)newUrl);
            }
            {
                ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"ContainerUtil.createConc\u2026t<Pair<String, String>>()");
                this.changedUrlsList = concurrentList;
                ConcurrentList concurrentList2 = ContainerUtil.createConcurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)concurrentList2, (String)"ContainerUtil.createConc\u2026ist<Pair<Module, Path>>()");
                this.changedModuleStorePaths = concurrentList2;
            }

            public static final /* synthetic */ void access$fireRootsChangeEvent(1 $this, boolean beforeRootsChanged) {
                $this.fireRootsChangeEvent(beforeRootsChanged);
            }

            public static final /* synthetic */ void access$updateModuleName(1 $this, String oldUrl, String newUrl) {
                $this.updateModuleName(oldUrl, newUrl);
            }
        }, (Disposable)this.project);
    }

    public static final /* synthetic */ VirtualFileUrlWatcher access$getVirtualFileUrlWatcher$p(RootsChangeWatcher $this) {
        return $this.virtualFileUrlWatcher;
    }

    @JvmStatic
    @NotNull
    public static final RootsChangeWatcher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher$Companion;", "", "()V", "getInstance", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RootsChangeWatcher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getComponent(RootsChangeWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getComponent(Roo\u2026hangeWatcher::class.java)");
            return (RootsChangeWatcher)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

