/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMapping;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMappingImpl;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMapping;", "externalStorageRoot", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "projectLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;)V", "getExternalStorageRoot", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getExternalSource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "internalSource", "intellij.platform.workspaceModel.ide"})
public final class JpsExternalStorageMappingImpl
implements JpsExternalStorageMapping {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;
    private final JpsProjectConfigLocation projectLocation;

    @Override
    @NotNull
    public JpsFileEntitySource getExternalSource(@NotNull JpsFileEntitySource internalSource) {
        JpsFileEntitySource jpsFileEntitySource;
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        JpsFileEntitySource jpsFileEntitySource2 = internalSource;
        if (jpsFileEntitySource2 instanceof JpsFileEntitySource.FileInDirectory) {
            String directoryPath = JpsPathUtil.urlToPath((String)((JpsFileEntitySource.FileInDirectory)internalSource).getDirectory().getUrl());
            String string = PathUtil.getFileName((String)directoryPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(directoryPath)");
            String directoryName = string;
            String string2 = PathUtil.getParentPath((String)directoryPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getParentPath(directoryPath)");
            String parentPath = string2;
            if (Intrinsics.areEqual((Object)PathUtil.getFileName((String)parentPath), (Object)".idea") && (Intrinsics.areEqual((Object)directoryName, (Object)"libraries") || Intrinsics.areEqual((Object)directoryName, (Object)"artifacts"))) {
                VirtualFileUrl virtualFileUrl = this.getExternalStorageRoot().append("project/" + directoryName + ".xml");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"externalStorageRoot.appe\u2026ject/$directoryName.xml\")");
                jpsFileEntitySource = new JpsFileEntitySource.ExactFile(virtualFileUrl, this.projectLocation);
            } else {
                VirtualFileUrl virtualFileUrl = this.getExternalStorageRoot().append("modules");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"externalStorageRoot.append(\"modules\")");
                jpsFileEntitySource = new JpsFileEntitySource.FileInDirectory(virtualFileUrl, this.projectLocation);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported internal entity source " + internalSource);
        }
        return jpsFileEntitySource;
    }

    @Override
    @NotNull
    public VirtualFileUrl getExternalStorageRoot() {
        return this.externalStorageRoot;
    }

    public JpsExternalStorageMappingImpl(@NotNull VirtualFileUrl externalStorageRoot, @NotNull JpsProjectConfigLocation projectLocation) {
        Intrinsics.checkNotNullParameter((Object)externalStorageRoot, (String)"externalStorageRoot");
        Intrinsics.checkNotNullParameter((Object)projectLocation, (String)"projectLocation");
        this.externalStorageRoot = externalStorageRoot;
        this.projectLocation = projectLocation;
    }
}

