/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.google.common.base.Stopwatch;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelCache;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheImpl;
import com.intellij.workspaceModel.storage.EntityStorageSerializer;
import com.intellij.workspaceModel.storage.EntityTypesResolver;
import com.intellij.workspaceModel.storage.SerializationResult;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImplKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelCache;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "cacheFile", "Ljava/nio/file/Path;", "invalidateProjectCacheMarkerFile", "Ljava/io/File;", "saveAlarm", "Lcom/intellij/util/SingleAlarm;", "serializer", "Lcom/intellij/workspaceModel/storage/EntityStorageSerializer;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "dispose", "", "doCacheSaving", "initCacheFile", "invalidateProjectCache", "loadCache", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "saveCache", "storage", "saveCacheNow", "Companion", "PluginAwareEntityTypesResolver", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class WorkspaceModelCacheImpl
implements Disposable,
WorkspaceModelCache {
    private final Path cacheFile;
    private final File invalidateProjectCacheMarkerFile;
    private final VirtualFileUrlManager virtualFileManager;
    private final EntityStorageSerializer serializer;
    private final SingleAlarm saveAlarm;
    private final Project project;
    private static final Logger LOG;
    private static final String DATA_DIR_NAME = "project-model-cache";
    @TestOnly
    @Nullable
    private static File testCacheFile;
    private static final AtomicBoolean cachesInvalidated;
    private static final File invalidateCachesMarkerFile;
    @NotNull
    public static final Companion Companion;

    private final Path initCacheFile() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && testCacheFile != null) {
            Path testFile;
            File file2 = testCacheFile;
            Intrinsics.checkNotNull((Object)file2);
            Path path = testFile = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"testFile");
            if (!PathKt.exists((Path)path)) {
                String string = "Test cache file defined, but doesn't exist";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return testFile;
        }
        Path path = ProjectUtil.getProjectDataPath((Project)this.project, (String)DATA_DIR_NAME).resolve("cache.data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.getProjectDataPa\u2026ME).resolve(\"cache.data\")");
        return path;
    }

    @Override
    public void saveCacheNow() {
        this.saveAlarm.cancel();
        this.doCacheSaving();
    }

    private final void doCacheSaving() {
        WorkspaceEntityStorage storage2 = WorkspaceModel.Companion.getInstance(this.project).getEntityStorage().getCurrent();
        if (!WorkspaceEntityStorageImplKt.isConsistent(storage2)) {
            this.invalidateProjectCache();
        }
        if (!cachesInvalidated.get()) {
            LOG.debug("Saving project model cache to " + this.cacheFile);
            this.saveCache(storage2);
        }
        if (cachesInvalidated.get()) {
            FileUtil.delete((Path)this.cacheFile);
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final WorkspaceEntityStorage loadCache() {
        try {
            WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder;
            if (!PathKt.exists((Path)this.cacheFile)) {
                return null;
            }
            if (invalidateCachesMarkerFile.exists() && PathKt.lastModified((Path)this.cacheFile).toMillis() < invalidateCachesMarkerFile.lastModified() || this.invalidateProjectCacheMarkerFile.exists() && PathKt.lastModified((Path)this.cacheFile).toMillis() < this.invalidateProjectCacheMarkerFile.lastModified()) {
                LOG.info("Skipping project model cache since '" + invalidateCachesMarkerFile + "' is present and newer than cache file '" + this.cacheFile + '\'');
                FileUtil.delete((Path)this.cacheFile);
                return null;
            }
            LOG.debug("Loading project model cache from " + this.cacheFile);
            Stopwatch stopWatch = Stopwatch.createStarted();
            Closeable closeable = PathKt.inputStream((Path)this.cacheFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                workspaceEntityStorageBuilder = this.serializer.deserializeCache(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            WorkspaceEntityStorageBuilder builder2 = workspaceEntityStorageBuilder;
            LOG.debug("Loaded project model cache from " + this.cacheFile + " in " + stopWatch.stop());
            return builder2;
        }
        catch (Throwable t) {
            LOG.warn("Could not deserialize project model cache from " + this.cacheFile, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCache(WorkspaceEntityStorage storage2) {
        File file2 = FileUtil.createTempFile((File)this.cacheFile.getParent().toFile(), (String)"cache", (String)".tmp");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026oFile(), \"cache\", \".tmp\")");
        File tmpFile = file2;
        try {
            SerializationResult serializationResult;
            Object object = tmpFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                serializationResult = this.serializer.serializeCache(it, storage2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            SerializationResult serializationResult2 = serializationResult;
            if (serializationResult2 instanceof SerializationResult.Fail) {
                LOG.warn("Workspace model cache was not serialized: " + ((SerializationResult.Fail)serializationResult2).getInfo());
            }
            try {
                Files.move(tmpFile.toPath(), this.cacheFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                LOG.warn((Throwable)e);
                Files.move(tmpFile.toPath(), this.cacheFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    private final void invalidateProjectCache() {
        LOG.info("Invalidating project model cache by creating " + this.invalidateProjectCacheMarkerFile);
        cachesInvalidated.set(true);
        try {
            FileUtil.createParentDirs((File)this.invalidateProjectCacheMarkerFile);
            FileUtil.writeToFile((File)this.invalidateProjectCacheMarkerFile, (String)String.valueOf(System.currentTimeMillis()));
        }
        catch (Throwable t) {
            LOG.warn("Cannot update the project invalidation marker file", t);
        }
    }

    public WorkspaceModelCacheImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.serializer = new EntityStorageSerializerImpl(PluginAwareEntityTypesResolver.INSTANCE, this.virtualFileManager);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.cacheFile = this.initCacheFile();
        File file2 = ProjectUtil.getProjectDataPath((Project)this.project, (String)DATA_DIR_NAME).resolve(".invalidate").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.getProjectDataPa\u2026e(\".invalidate\").toFile()");
        this.invalidateProjectCacheMarkerFile = file2;
        LOG.debug("Project Model Cache at " + this.cacheFile);
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        workspaceModelTopics.subscribeImmediately(messageBusConnection, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LOG.debug("Schedule cache update");
                SingleAlarm.request$default(saveAlarm, false, 0, 3, null);
            }

            @Override
            public void beforeChanged(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        this.saveAlarm = SingleAlarmKt.pooledThreadSingleAlarm(1000, this, (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                WorkspaceModelCacheImpl.access$doCacheSaving((WorkspaceModelCacheImpl)this.receiver);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelCacheImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        cachesInvalidated = new AtomicBoolean(false);
        invalidateCachesMarkerFile = new File(PathManagerEx.getAppSystemDir().resolve("projectModelCache").toFile(), ".invalidate");
    }

    public static final /* synthetic */ void access$doCacheSaving(WorkspaceModelCacheImpl $this) {
        $this.doCacheSaving();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$PluginAwareEntityTypesResolver;", "Lcom/intellij/workspaceModel/storage/EntityTypesResolver;", "()V", "getPluginId", "", "clazz", "Ljava/lang/Class;", "resolveClass", "name", "pluginId", "intellij.platform.ide.impl"})
    public static final class PluginAwareEntityTypesResolver
    implements EntityTypesResolver {
        @NotNull
        public static final PluginAwareEntityTypesResolver INSTANCE;

        @Override
        @Nullable
        public String getPluginId(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            PluginId pluginId = PluginManager.getInstance().getPluginOrPlatformByClassName(clazz.getName());
            return pluginId != null ? pluginId.getIdString() : null;
        }

        @Override
        @NotNull
        public Class<?> resolveClass(@NotNull String name, @Nullable String pluginId) {
            ClassLoader classLoader;
            PluginId id2;
            PluginId pluginId2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = pluginId;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                pluginId2 = PluginId.getId((String)it);
            } else {
                pluginId2 = id2 = null;
            }
            if (id2 == null) {
                classLoader = ApplicationManager.class.getClassLoader();
            } else {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(id2);
                if (ideaPluginDescriptor == null) {
                    String string3 = "Could not resolve plugin by id '" + pluginId + "' for type: " + name;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"PluginManagerCore.getPlu\u2026uginId' for type: $name\")");
                IdeaPluginDescriptor plugin2 = ideaPluginDescriptor;
                classLoader = plugin2.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = ApplicationManager.class.getClassLoader();
                }
            }
            ClassLoader classloader = classLoader;
            Class<?> clazz = classloader.loadClass(name);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classloader.loadClass(name)");
            return clazz;
        }

        private PluginAwareEntityTypesResolver() {
        }

        static {
            PluginAwareEntityTypesResolver pluginAwareEntityTypesResolver;
            INSTANCE = pluginAwareEntityTypesResolver = new PluginAwareEntityTypesResolver();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$Companion;", "", "()V", "DATA_DIR_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateCachesMarkerFile", "Ljava/io/File;", "testCacheFile", "getTestCacheFile", "()Ljava/io/File;", "setTestCacheFile", "(Ljava/io/File;)V", "invalidateCaches", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final File getTestCacheFile() {
            return testCacheFile;
        }

        public final void setTestCacheFile(@Nullable File file2) {
            testCacheFile = file2;
        }

        public final void invalidateCaches() {
            LOG.info("Invalidating caches by creating " + invalidateCachesMarkerFile);
            cachesInvalidated.set(true);
            try {
                FileUtil.createParentDirs((File)invalidateCachesMarkerFile);
                FileUtil.writeToFile((File)invalidateCachesMarkerFile, (String)String.valueOf(System.currentTimeMillis()));
            }
            catch (Throwable t) {
                LOG.warn("Cannot update the invalidation marker file", t);
            }
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)invalidateCaches.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

