/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingListener;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelChangeListener;", "entityId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/FacetId;", "(Lcom/intellij/workspaceModel/storage/bridgeEntities/FacetId;)V", "changed", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "printInfo", "action", "", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Companion", "intellij.platform.ide.impl"})
final class EntityTracingListener
implements WorkspaceModelChangeListener {
    private final FacetId entityId;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Sequence<EntityChange<?>> $this$forEach$iv = event.getAllChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange it = (EntityChange)element$iv;
            boolean bl = false;
            EntityChange entityChange = it;
            if (entityChange instanceof EntityChange.Added) {
                this.printInfo("added", (WorkspaceEntity)((EntityChange.Added)it).getEntity());
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                this.printInfo("removed", (WorkspaceEntity)((EntityChange.Removed)it).getEntity());
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            this.printInfo("replaced from", (WorkspaceEntity)((EntityChange.Replaced)it).getOldEntity());
            this.printInfo("replaced to", (WorkspaceEntity)((EntityChange.Replaced)it).getNewEntity());
        }
    }

    private final void printInfo(String action2, WorkspaceEntity entity) {
        WorkspaceEntity workspaceEntity = entity;
        if (!(workspaceEntity instanceof FacetEntity)) {
            workspaceEntity = null;
        }
        FacetEntity facetEntity = (FacetEntity)workspaceEntity;
        if (Intrinsics.areEqual((Object)(facetEntity != null ? facetEntity.persistentId() : null), (Object)this.entityId)) {
            LOG.info(action2 + ": " + ((FacetEntity)entity).getConfigurationXmlTag(), new Throwable());
        }
    }

    public EntityTracingListener(@NotNull FacetId entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        this.entityId = entityId;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EntityTracingListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Override
    public void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

