/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "", "()V", "baseDirectoryUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getBaseDirectoryUrl", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "baseDirectoryUrlString", "", "getBaseDirectoryUrlString", "()Ljava/lang/String;", "exists", "", "DirectoryBased", "FileBased", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$FileBased;", "intellij.platform.workspaceModel.ide"})
public abstract class JpsProjectConfigLocation {
    @NotNull
    public final String getBaseDirectoryUrlString() {
        String string = this.getBaseDirectoryUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseDirectoryUrl.url");
        return string;
    }

    @NotNull
    public abstract VirtualFileUrl getBaseDirectoryUrl();

    public abstract boolean exists();

    private JpsProjectConfigLocation() {
    }

    public /* synthetic */ JpsProjectConfigLocation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\b\u0010\u000f\u001a\u00020\fH\u0016J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "projectDir", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;)V", "baseDirectoryUrl", "getBaseDirectoryUrl", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getProjectDir", "component1", "copy", "equals", "", "other", "", "exists", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.ide"})
    public static final class DirectoryBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl projectDir;

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.projectDir;
        }

        @Override
        public boolean exists() {
            return JpsPathUtil.urlToFile((String)this.projectDir.getUrl()).exists();
        }

        @NotNull
        public final VirtualFileUrl getProjectDir() {
            return this.projectDir;
        }

        public DirectoryBased(@NotNull VirtualFileUrl projectDir) {
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            super(null);
            this.projectDir = projectDir;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.projectDir;
        }

        @NotNull
        public final DirectoryBased copy(@NotNull VirtualFileUrl projectDir) {
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            return new DirectoryBased(projectDir);
        }

        public static /* synthetic */ DirectoryBased copy$default(DirectoryBased directoryBased, VirtualFileUrl virtualFileUrl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFileUrl = directoryBased.projectDir;
            }
            return directoryBased.copy(virtualFileUrl);
        }

        @NotNull
        public String toString() {
            return "DirectoryBased(projectDir=" + this.projectDir + ")";
        }

        public int hashCode() {
            VirtualFileUrl virtualFileUrl = this.projectDir;
            return virtualFileUrl != null ? virtualFileUrl.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DirectoryBased)) break block3;
                    DirectoryBased directoryBased = (DirectoryBased)object;
                    if (!Intrinsics.areEqual((Object)this.projectDir, (Object)directoryBased.projectDir)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$FileBased;", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "iprFile", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "iprFileParent", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;)V", "baseDirectoryUrl", "getBaseDirectoryUrl", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getIprFile", "getIprFileParent", "component1", "component2", "copy", "equals", "", "other", "", "exists", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.ide"})
    public static final class FileBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl iprFile;
        @NotNull
        private final VirtualFileUrl iprFileParent;

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.iprFileParent;
        }

        @Override
        public boolean exists() {
            return JpsPathUtil.urlToFile((String)this.iprFile.getUrl()).exists();
        }

        @NotNull
        public final VirtualFileUrl getIprFile() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl getIprFileParent() {
            return this.iprFileParent;
        }

        public FileBased(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter((Object)iprFile, (String)"iprFile");
            Intrinsics.checkNotNullParameter((Object)iprFileParent, (String)"iprFileParent");
            super(null);
            this.iprFile = iprFile;
            this.iprFileParent = iprFileParent;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl component2() {
            return this.iprFileParent;
        }

        @NotNull
        public final FileBased copy(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter((Object)iprFile, (String)"iprFile");
            Intrinsics.checkNotNullParameter((Object)iprFileParent, (String)"iprFileParent");
            return new FileBased(iprFile, iprFileParent);
        }

        public static /* synthetic */ FileBased copy$default(FileBased fileBased, VirtualFileUrl virtualFileUrl, VirtualFileUrl virtualFileUrl2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFileUrl = fileBased.iprFile;
            }
            if ((n & 2) != 0) {
                virtualFileUrl2 = fileBased.iprFileParent;
            }
            return fileBased.copy(virtualFileUrl, virtualFileUrl2);
        }

        @NotNull
        public String toString() {
            return "FileBased(iprFile=" + this.iprFile + ", iprFileParent=" + this.iprFileParent + ")";
        }

        public int hashCode() {
            VirtualFileUrl virtualFileUrl = this.iprFile;
            VirtualFileUrl virtualFileUrl2 = this.iprFileParent;
            return (virtualFileUrl != null ? virtualFileUrl.hashCode() : 0) * 31 + (virtualFileUrl2 != null ? virtualFileUrl2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileBased)) break block3;
                    FileBased fileBased = (FileBased)object;
                    if (!Intrinsics.areEqual((Object)this.iprFile, (Object)fileBased.iprFile) || !Intrinsics.areEqual((Object)this.iprFileParent, (Object)fileBased.iprFileParent)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

