/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagingErrorDialog;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagesNotificationPanel {
    private final JEditorPane myHtmlViewer;
    private final Map<String, Runnable> myLinkHandlers = new HashMap<String, Runnable>();
    @NlsContexts.DialogTitle
    private String myErrorTitle;
    private PackageManagementService.ErrorDescription myErrorDescription;

    public PackagesNotificationPanel() {
        this.myHtmlViewer = SwingHelper.createHtmlViewer(true, null, null, null);
        this.myHtmlViewer.setVisible(false);
        this.myHtmlViewer.setOpaque(true);
        this.myHtmlViewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Runnable handler2 = PackagesNotificationPanel.this.myLinkHandlers.get(e.getDescription());
                if (handler2 != null) {
                    handler2.run();
                } else if (PackagesNotificationPanel.this.myErrorTitle != null && PackagesNotificationPanel.this.myErrorDescription != null) {
                    PackagesNotificationPanel.showError(PackagesNotificationPanel.this.myErrorTitle, PackagesNotificationPanel.this.myErrorDescription);
                }
            }
        });
    }

    public static void showError(@NotNull @NlsContexts.DialogTitle String title, @NotNull PackageManagementService.ErrorDescription description) {
        if (title == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(0);
        }
        if (description == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(1);
        }
        PackagingErrorDialog dialog2 = new PackagingErrorDialog(title, description);
        dialog2.show();
    }

    public void showResult(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
        if (errorDescription == null) {
            String message2 = IdeBundle.message((String)"package.installed.successfully", (Object[])new Object[0]);
            if (packageName != null) {
                message2 = IdeBundle.message((String)"package.0.installed.successfully", (Object[])new Object[]{packageName});
            }
            this.showSuccess(message2);
        } else {
            String title = IdeBundle.message((String)"failed.to.install.packages.dialog.title", (Object[])new Object[0]);
            if (packageName != null) {
                title = IdeBundle.message((String)"failed.to.install.package.dialog.title", (Object[])new Object[]{packageName});
            }
            String text2 = IdeBundle.message((String)"install.package.failure", (Object[])new Object[]{packageName});
            this.showError(text2, title, errorDescription);
        }
    }

    public void addLinkHandler(String key, Runnable handler2) {
        this.myLinkHandlers.put(key, handler2);
    }

    public void removeAllLinkHandlers() {
        this.myLinkHandlers.clear();
    }

    public JComponent getComponent() {
        return this.myHtmlViewer;
    }

    public void showSuccess(@NlsContexts.NotificationContent String text2) {
        this.showContent(text2, MessageType.INFO.getPopupBackground());
    }

    private void showContent(@NotNull @NlsContexts.NotificationContent String text2, @NotNull Color background) {
        if (text2 == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(2);
        }
        if (background == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(3);
        }
        String htmlText = text2.startsWith("<html>") ? text2 : UIUtil.toHtml((String)text2);
        this.myHtmlViewer.setText(htmlText);
        this.myHtmlViewer.setBackground(background);
        this.setVisibleEditorPane(true);
        this.myErrorTitle = null;
        this.myErrorDescription = null;
    }

    public void showError(@NlsContexts.NotificationContent String text2, @Nullable @NlsContexts.DialogTitle String detailsTitle, PackageManagementService.ErrorDescription errorDescription) {
        this.showContent(text2, MessageType.ERROR.getPopupBackground());
        this.myErrorTitle = detailsTitle;
        this.myErrorDescription = errorDescription;
    }

    public void showWarning(@NlsContexts.NotificationContent String text2) {
        this.showContent(text2, MessageType.WARNING.getPopupBackground());
    }

    public void hide() {
        this.setVisibleEditorPane(false);
    }

    private void setVisibleEditorPane(boolean visible) {
        boolean oldVisible = this.myHtmlViewer.isVisible();
        this.myHtmlViewer.setVisible(visible);
        if (oldVisible != visible) {
            this.myHtmlViewer.revalidate();
            this.myHtmlViewer.repaint();
        }
    }

    public boolean hasLinkHandler(String key) {
        return this.myLinkHandlers.containsKey(key);
    }

    public void removeLinkHandler(String key) {
        this.myLinkHandlers.remove(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/PackagesNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

