/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdePopupManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;

public final class OwnerOptional {
    private Window myPermanentOwner;

    private static Window findOwnerByComponent(Component component2) {
        if (component2 == null) {
            component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (component2 == null) {
            component2 = Window.getWindows()[0];
        }
        return component2 instanceof Window ? (Window)component2 : SwingUtilities.getWindowAncestor(component2);
    }

    private OwnerOptional(Window permanentOwner) {
        this.myPermanentOwner = permanentOwner;
    }

    public static OwnerOptional fromComponent(Component parentComponent) {
        Dialog ownerDialog;
        Window owner = OwnerOptional.findOwnerByComponent(parentComponent);
        IdePopupManager manager2 = IdeEventQueue.getInstance().getPopupManager();
        if (!(!manager2.isPopupWindow(owner) || owner.isFocused() && SystemInfo.isJetBrainsJvm)) {
            for (owner = owner.getOwner(); owner != null && !(owner instanceof Dialog) && !(owner instanceof Frame); owner = owner.getOwner()) {
            }
        }
        if (owner instanceof Dialog && !(ownerDialog = (Dialog)owner).isModal() && !UIUtil.isPossibleOwner((Dialog)ownerDialog)) {
            while (owner instanceof Dialog && !((Dialog)owner).isModal()) {
                owner = owner.getOwner();
            }
        }
        while (owner != null && !owner.isShowing()) {
            owner = owner.getOwner();
        }
        if (owner != null && !(owner instanceof Frame) && !(owner instanceof Dialog)) {
            owner = null;
        }
        return new OwnerOptional(owner);
    }

    public OwnerOptional ifDialog(Consumer<? super Dialog> consumer2) {
        if (this.myPermanentOwner instanceof Dialog) {
            consumer2.consume((Object)((Dialog)this.myPermanentOwner));
        }
        return this;
    }

    public OwnerOptional ifNull(Consumer<? super Frame> consumer2) {
        if (this.myPermanentOwner == null) {
            consumer2.consume(null);
        }
        return this;
    }

    public OwnerOptional ifWindow(Consumer<? super Window> consumer2) {
        if (this.myPermanentOwner != null) {
            consumer2.consume((Object)this.myPermanentOwner);
        }
        return this;
    }

    public OwnerOptional ifFrame(Consumer<? super Frame> consumer2) {
        if (this.myPermanentOwner instanceof Frame) {
            if (this.myPermanentOwner instanceof IdeFrame.Child) {
                IdeFrame.Child ideFrameChild = (IdeFrame.Child)this.myPermanentOwner;
                this.myPermanentOwner = WindowManager.getInstance().getFrame(ideFrameChild.getProject());
            }
            consumer2.consume((Object)((Frame)this.myPermanentOwner));
        }
        return this;
    }

    public Window get() {
        return this.myPermanentOwner;
    }
}

