/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ListItemEditor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListModelEditorBase<T>
extends CollectionModelEditor<T, ListItemEditor<T>> {
    protected final MyModel model;

    public ListModelEditorBase(@NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            ListModelEditorBase.$$$reportNull$$$0(0);
        }
        super(itemEditor);
        this.model = new MyModel();
    }

    @NotNull
    public CollectionListModel<T> getModel() {
        MyModel myModel = this.model;
        if (myModel == null) {
            ListModelEditorBase.$$$reportNull$$$0(1);
        }
        return myModel;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list2 = this.model.items();
        if (list2 == null) {
            ListModelEditorBase.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void reset(@NotNull List<? extends T> items) {
        if (items == null) {
            ListModelEditorBase.$$$reportNull$$$0(3);
        }
        super.reset(items);
        this.model.replaceAll(items);
    }

    public final void ensureNonEmptyNames(@NotNull @NlsContexts.DialogMessage String errorMessage) throws ConfigurationException {
        if (errorMessage == null) {
            ListModelEditorBase.$$$reportNull$$$0(4);
        }
        List<T> items = this.getItems();
        for (int i2 = items.size() - 1; i2 >= 0; --i2) {
            T item = items.get(i2);
            if (!StringUtil.isEmptyOrSpaces((String)((ListItemEditor)this.itemEditor).getName(item))) continue;
            if (((ListItemEditor)this.itemEditor).isEmpty(item)) {
                this.removeEmptyItem(i2);
                continue;
            }
            throw new ConfigurationException(errorMessage);
        }
    }

    protected void removeEmptyItem(int i2) {
    }

    @Override
    protected boolean isEditable(@NotNull T item) {
        if (item == null) {
            ListModelEditorBase.$$$reportNull$$$0(5);
        }
        return ((ListItemEditor)this.itemEditor).isEditable(item);
    }

    @NotNull
    public List<T> apply() {
        List<T> items = this.getItems();
        if (!this.helper.hasModifiedItems()) {
            List<T> list2 = items;
            if (list2 == null) {
                ListModelEditorBase.$$$reportNull$$$0(6);
            }
            return list2;
        }
        this.helper.process((newItem, oldItem) -> {
            ((ListItemEditor)this.itemEditor).applyModifiedProperties(newItem, oldItem);
            this.silentlyReplaceItem(newItem, oldItem, -1);
            return true;
        });
        this.helper.reset(items);
        List<T> list3 = items;
        if (list3 == null) {
            ListModelEditorBase.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Override
    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index2) {
        if (oldItem == null) {
            ListModelEditorBase.$$$reportNull$$$0(8);
        }
        if (newItem == null) {
            ListModelEditorBase.$$$reportNull$$$0(9);
        }
        super.silentlyReplaceItem(oldItem, newItem, index2);
        this.model.checkSelectionOnSilentReplace(oldItem, newItem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ListModelEditorBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ListModelEditorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureNonEmptyNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "silentlyReplaceItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class MyModel
    extends MutableCollectionComboBoxModel<T> {
        protected MyModel() {
        }

        @NotNull
        final List<T> items() {
            List list2 = super.getInternalList();
            if (list2 == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            return list2;
        }

        void checkSelectionOnSilentReplace(@NotNull T oldItem, @NotNull T newItem) {
            if (oldItem == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            if (newItem == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            if (this.mySelection == oldItem) {
                this.mySelection = newItem;
            }
        }

        protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
            if (existingItem == null) {
                MyModel.$$$reportNull$$$0(3);
            }
            ListModelEditorBase.this.helper.remove(existingItem);
        }

        public void removeAll() {
            super.removeAll();
            ListModelEditorBase.this.helper.reset(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/ListModelEditorBase$MyModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldItem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newItem";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "items";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/ListModelEditorBase$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkSelectionOnSilentReplace";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "itemReplaced";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

