/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutSettings;", "", "()V", "currentLayout", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutProviderBean;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getUsedLayout", "indexLayoutSettingFile", "Ljava/nio/file/Path;", "loadUsedLayout", "", "resetUsedLayout", "", "saveCurrentLayout", "setUsedLayout", "bean", "intellij.platform.lang.impl"})
public final class FileBasedIndexLayoutSettings {
    private static final Logger log;
    private static Ref<FileBasedIndexLayoutProviderBean> currentLayout;
    @NotNull
    public static final FileBasedIndexLayoutSettings INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setUsedLayout(@Nullable FileBasedIndexLayoutProviderBean bean) {
        try {
            Files.createDirectories(this.indexLayoutSettingFile().getParent(), new FileAttribute[0]);
            if (bean == null) {
                FileUtil.delete((Path)this.indexLayoutSettingFile());
                return;
            }
            Object object = this.indexLayoutSettingFile();
            OpenOption[] openOptionArray = new OpenOption[]{};
            boolean bl = false;
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(this, *options)");
            object = outputStream;
            int n = 8192;
            bl = false;
            object = (Closeable)new DataOutputStream((OutputStream)(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n)));
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)object;
                boolean bl2 = false;
                EnumeratorStringDescriptor.INSTANCE.save((DataOutput)it, bean.id);
                DataInputOutputUtil.writeINT((DataOutput)((DataOutput)it), (int)bean.version);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean loadUsedLayout() {
        if (!Files.exists(this.indexLayoutSettingFile(), new LinkOption[0])) {
            currentLayout = Ref.create();
            return false;
        }
        String id2 = null;
        int version2 = 0;
        Closeable closeable = PathKt.inputStream((Path)this.indexLayoutSettingFile());
        int n = 8192;
        boolean bl = false;
        closeable = new DataInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl2 = false;
            String string = EnumeratorStringDescriptor.INSTANCE.read((DataInput)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EnumeratorStringDescriptor.INSTANCE.read(it)");
            id2 = string;
            version2 = DataInputOutputUtil.readINT((DataInput)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ExtensionPointName<FileBasedIndexLayoutProviderBean> extensionPointName = FileBasedIndexLayoutProvider.STORAGE_LAYOUT_EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexLayoutProv\u2026er.STORAGE_LAYOUT_EP_NAME");
        for (FileBasedIndexLayoutProviderBean bean : extensionPointName.getExtensionList()) {
            if (!Intrinsics.areEqual((Object)bean.id, (Object)id2) || bean.version != version2) continue;
            currentLayout = Ref.create((Object)bean);
            return false;
        }
        ExtensionPointName<FileBasedIndexLayoutProviderBean> extensionPointName2 = FileBasedIndexLayoutProvider.STORAGE_LAYOUT_EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"FileBasedIndexLayoutProv\u2026er.STORAGE_LAYOUT_EP_NAME");
        for (FileBasedIndexLayoutProviderBean bean : extensionPointName2.getExtensionList()) {
            if (!Intrinsics.areEqual((Object)bean.id, (Object)id2)) continue;
            this.setUsedLayout(bean);
            currentLayout = Ref.create((Object)bean);
            return true;
        }
        this.setUsedLayout(null);
        return true;
    }

    public final synchronized void saveCurrentLayout() {
        this.setUsedLayout(this.getUsedLayout());
    }

    @Nullable
    public final synchronized FileBasedIndexLayoutProviderBean getUsedLayout() {
        Ref<FileBasedIndexLayoutProviderBean> ref = currentLayout;
        if (ref == null) {
            throw (Throwable)new IllegalStateException("File-based index layout settings not loaded yet");
        }
        Ref<FileBasedIndexLayoutProviderBean> layout = ref;
        return (FileBasedIndexLayoutProviderBean)layout.get();
    }

    public final synchronized void resetUsedLayout() {
        currentLayout = null;
    }

    private final Path indexLayoutSettingFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.layout");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getIndexRoot\u2026resolve(\"indices.layout\")");
        return path;
    }

    private FileBasedIndexLayoutSettings() {
    }

    static {
        FileBasedIndexLayoutSettings fileBasedIndexLayoutSettings;
        INSTANCE = fileBasedIndexLayoutSettings = new FileBasedIndexLayoutSettings();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileBasedIndexLayoutSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }
}

