/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.indexing.impl.storage.InMemoryStorageLayout;
import com.intellij.util.indexing.impl.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.snapshot.HashIdForwardIndexAccessor;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\fJ\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J<\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u0014\u0012\u0002\b\u00030\u0012\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u0014\u0012\u0002\b\u00030\u0016H\u0003J<\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00140\u0018\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00140\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout;", "", "()V", "contentLessIndexLock", "Lcom/intellij/util/io/StorageLockContext;", "forcedLayout", "", "createIndexStorage", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "deleteIndexDirectory", "", "getForcedLayoutEP", "Lcom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutProviderBean;", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/AbstractMapForwardIndexAccessor;", "Key", "Value", "indexExtension", "Lcom/intellij/util/indexing/IndexExtension;", "getLayout", "Lcom/intellij/util/indexing/impl/storage/VfsAwareIndexStorageLayout;", "contentHashEnumeratorReopen", "", "DefaultStorageLayout", "SingleEntryStorageLayout", "SnapshotMappingsStorageLayout", "intellij.platform.lang.impl"})
public final class DefaultIndexStorageLayout {
    private static final String forcedLayout;
    private static final StorageLockContext contentLessIndexLock;
    @NotNull
    public static final DefaultIndexStorageLayout INSTANCE;

    @JvmStatic
    @NotNull
    public static final <Key, Value> VfsAwareIndexStorageLayout<Key, Value> getLayout(@NotNull FileBasedIndexExtension<Key, Value> indexExtension, boolean contentHashEnumeratorReopen) throws IOException {
        FileBasedIndexLayoutProviderBean layoutEP;
        Intrinsics.checkNotNullParameter(indexExtension, (String)"indexExtension");
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = INSTANCE.getForcedLayoutEP();
        if (fileBasedIndexLayoutProviderBean == null) {
            fileBasedIndexLayoutProviderBean = layoutEP = FileBasedIndexLayoutSettings.INSTANCE.getUsedLayout();
        }
        if (layoutEP != null) {
            VfsAwareIndexStorageLayout<Key, Value> vfsAwareIndexStorageLayout = layoutEP.getLayoutProvider().getLayout(indexExtension);
            Intrinsics.checkNotNullExpressionValue(vfsAwareIndexStorageLayout, (String)"layoutEP.layoutProvider.getLayout(indexExtension)");
            return vfsAwareIndexStorageLayout;
        }
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new InMemoryStorageLayout<Key, Value>(indexExtension);
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryStorageLayout<Key, Value>(indexExtension);
        }
        return VfsAwareMapReduceIndex.hasSnapshotMapping((IndexExtension)indexExtension) ? (VfsAwareIndexStorageLayout)new SnapshotMappingsStorageLayout<Key, Value>(indexExtension, contentHashEnumeratorReopen) : (VfsAwareIndexStorageLayout)new DefaultStorageLayout<Key, Value>(indexExtension);
    }

    private final FileBasedIndexLayoutProviderBean getForcedLayoutEP() {
        Object object;
        String layout;
        block3: {
            String string = forcedLayout;
            if (string == null) {
                return null;
            }
            layout = string;
            ExtensionPointName<FileBasedIndexLayoutProviderBean> extensionPointName = FileBasedIndexLayoutProvider.STORAGE_LAYOUT_EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexLayoutProv\u2026er.STORAGE_LAYOUT_EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexLayoutProv\u2026LAYOUT_EP_NAME.extensions");
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Object[] objectArray3 = objectArray2;
            boolean bl2 = false;
            for (Object object2 : objectArray3) {
                FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)object2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.id, (Object)layout)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = (FileBasedIndexLayoutProviderBean)object;
        if (fileBasedIndexLayoutProviderBean == null) {
            throw (Throwable)new IllegalStateException("Can't find index storage layout for id = " + layout);
        }
        return fileBasedIndexLayoutProviderBean;
    }

    @ApiStatus.Internal
    private final <Key, Value> AbstractMapForwardIndexAccessor<Key, Value, ?> getForwardIndexAccessor(IndexExtension<Key, Value, ?> indexExtension) {
        return !(indexExtension instanceof SingleEntryFileBasedIndexExtension) || FileBasedIndex.USE_IN_MEMORY_INDEX ? (AbstractMapForwardIndexAccessor)new MapForwardIndexAccessor((DataExternalizer)new InputMapExternalizer<Key, Value>(indexExtension)) : (AbstractMapForwardIndexAccessor)new SingleEntryIndexForwardIndexAccessor<Value>(indexExtension);
    }

    @NotNull
    public final <K, V> VfsAwareIndexStorage<K, V> createIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension2) throws IOException {
        Intrinsics.checkNotNullParameter(extension2, (String)"extension");
        Path path = IndexInfrastructure.getStorageFile(extension2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"IndexInfrastructure.getStorageFile(extension.name)");
        Path storageFile = path;
        return new VfsAwareMapIndexStorage<K, V>(extension2, storageFile, storageFile, extension2.getKeyDescriptor(), extension2.getValueExternalizer(), extension2.getCacheSize(), extension2.keyIsUniqueForIndexedFile(), extension2.traceKeyHashToVirtualFileMapping()){
            final /* synthetic */ FileBasedIndexExtension $extension;
            final /* synthetic */ Path $storageFile;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initMapAndCache() {
                boolean bl = PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() == null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (!this.$extension.dependsOnFileContent()) {
                    PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(DefaultIndexStorageLayout.access$getContentLessIndexLock$p(DefaultIndexStorageLayout.INSTANCE));
                }
                try {
                    super.initMapAndCache();
                }
                finally {
                    PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
                }
            }
            {
                this.$extension = $captured_local_variable$0;
                this.$storageFile = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final void deleteIndexDirectory(FileBasedIndexExtension<?, ?> extension2) {
        FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(extension2.getName()).toFile());
    }

    private DefaultIndexStorageLayout() {
    }

    static {
        DefaultIndexStorageLayout defaultIndexStorageLayout;
        INSTANCE = defaultIndexStorageLayout = new DefaultIndexStorageLayout();
        forcedLayout = System.getProperty("idea.index.storage.forced.layout");
        contentLessIndexLock = new StorageLockContext(true);
    }

    public static final /* synthetic */ StorageLockContext access$getContentLessIndexLock$p(DefaultIndexStorageLayout $this) {
        DefaultIndexStorageLayout defaultIndexStorageLayout = $this;
        return contentLessIndexLock;
    }

    public static final /* synthetic */ AbstractMapForwardIndexAccessor access$getForwardIndexAccessor(DefaultIndexStorageLayout $this, IndexExtension indexExtension) {
        return $this.getForwardIndexAccessor(indexExtension);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$DefaultStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/impl/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;)V", "clearIndexData", "", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class DefaultStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        private final FileBasedIndexExtension<K, V> extension;

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            return INSTANCE.createIndexStorage(this.extension);
        }

        @NotNull
        public ForwardIndex openForwardIndex() throws IOException {
            Path path = IndexInfrastructure.getInputIndexStorageFile(this.extension.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"IndexInfrastructure.getI\u2026orageFile(extension.name)");
            Path indexStorageFile = path;
            StorageLockContext storageLockContext = this.extension.dependsOnFileContent() ? null : DefaultIndexStorageLayout.access$getContentLessIndexLock$p(INSTANCE);
            return (ForwardIndex)new PersistentMapBasedForwardIndex(indexStorageFile, false, false, storageLockContext);
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() {
            return (ForwardIndexAccessor)new MapForwardIndexAccessor((DataExternalizer)new InputMapExternalizer((IndexExtension)this.extension));
        }

        @Override
        public void clearIndexData() {
            INSTANCE.deleteIndexDirectory(this.extension);
        }

        public DefaultStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0018H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$SnapshotMappingsStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/impl/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "contentHashEnumeratorReopen", "", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;Z)V", "mySnapshotInputMappings", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappings;", "getMySnapshotInputMappings", "()Lcom/intellij/util/indexing/snapshot/SnapshotInputMappings;", "mySnapshotInputMappings$delegate", "Lkotlin/Lazy;", "clearIndexData", "", "createOrClearSnapshotInputMappings", "deleteIndexData", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class SnapshotMappingsStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        private final Lazy mySnapshotInputMappings$delegate;
        private final FileBasedIndexExtension<K, V> extension;

        private final SnapshotInputMappings<K, V> getMySnapshotInputMappings() {
            Lazy lazy = this.mySnapshotInputMappings$delegate;
            SnapshotMappingsStorageLayout snapshotMappingsStorageLayout = this;
            Object var3_3 = null;
            boolean bl = false;
            return (SnapshotInputMappings)lazy.getValue();
        }

        private final void deleteIndexData() {
            INSTANCE.deleteIndexDirectory(this.extension);
            FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(this.extension.getName()).toFile());
        }

        @Override
        @NotNull
        public SnapshotInputMappings<K, V> createOrClearSnapshotInputMappings() throws IOException {
            return this.getMySnapshotInputMappings();
        }

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            this.getMySnapshotInputMappings();
            return INSTANCE.createIndexStorage(this.extension);
        }

        @NotNull
        public ForwardIndex openForwardIndex() throws IOException {
            Path storageFile = this.getMySnapshotInputMappings().getInputIndexStorageFile();
            return (ForwardIndex)new IntMapForwardIndex(storageFile, true);
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() throws IOException {
            HashIdForwardIndexAccessor<K, V, FileContent> hashIdForwardIndexAccessor = this.getMySnapshotInputMappings().getForwardIndexAccessor();
            Intrinsics.checkNotNullExpressionValue(hashIdForwardIndexAccessor, (String)"mySnapshotInputMappings.forwardIndexAccessor");
            return (ForwardIndexAccessor)hashIdForwardIndexAccessor;
        }

        @Override
        public void clearIndexData() {
            this.deleteIndexData();
        }

        public SnapshotMappingsStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2, boolean contentHashEnumeratorReopen) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
            this.mySnapshotInputMappings$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<SnapshotInputMappings<K, V>>(this){
                final /* synthetic */ SnapshotMappingsStorageLayout this$0;

                @NotNull
                public final SnapshotInputMappings<K, V> invoke() {
                    return new SnapshotInputMappings<Key, Value>((IndexExtension)SnapshotMappingsStorageLayout.access$getExtension$p(this.this$0), DefaultIndexStorageLayout.access$getForwardIndexAccessor(DefaultIndexStorageLayout.INSTANCE, (IndexExtension)SnapshotMappingsStorageLayout.access$getExtension$p(this.this$0)));
                }
                {
                    this.this$0 = snapshotMappingsStorageLayout;
                    super(0);
                }
            });
            if (!contentHashEnumeratorReopen) {
                this.deleteIndexData();
            }
        }

        public static final /* synthetic */ FileBasedIndexExtension access$getExtension$p(SnapshotMappingsStorageLayout $this) {
            return $this.extension;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$SingleEntryStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/impl/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;)V", "clearIndexData", "", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class SingleEntryStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        private final FileBasedIndexExtension<K, V> extension;

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            return INSTANCE.createIndexStorage(this.extension);
        }

        @NotNull
        public ForwardIndex openForwardIndex() {
            return (ForwardIndex)new EmptyForwardIndex();
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() {
            FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.extension;
            if (fileBasedIndexExtension == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.IndexExtension<kotlin.Int, V, *>");
            }
            return (ForwardIndexAccessor)new SingleEntryIndexForwardIndexAccessor((IndexExtension)fileBasedIndexExtension);
        }

        @Override
        public void clearIndexData() {
            INSTANCE.deleteIndexDirectory(this.extension);
        }

        public SingleEntryStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
        }
    }
}

