/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsEventsMerger {
    private static final boolean DEBUG = FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE || SystemProperties.is((String)"log.index.vfs.events");
    @Nullable
    public static final com.intellij.openapi.diagnostic.Logger LOG = MyLoggerFactory.getLoggerInstance();
    private final AtomicInteger myPublishedEventIndex = new AtomicInteger();
    private final ConcurrentIntObjectMap<ChangeInfo> myChangeInfos = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private static final short FILE_ADDED = 1;
    private static final short FILE_REMOVED = 2;
    private static final short FILE_CONTENT_CHANGED = 4;
    private static final short BEFORE_FILE_CONTENT_CHANGED = 8;
    private static final short FILE_TRANSIENT_STATE_CHANGED = 16;

    void recordFileEvent(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(0);
        }
        if (LOG != null) {
            LOG.info("Request build indices for file:" + file2.getPath() + ", contentChange:" + contentChange);
        }
        this.updateChange(file2, contentChange ? (short)4 : 1);
    }

    void recordBeforeFileEvent(@NotNull VirtualFile file2, boolean contentChanged) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(1);
        }
        if (LOG != null) {
            LOG.info("Request invalidate indices for file:" + file2.getPath() + ", contentChange:" + contentChanged);
        }
        this.updateChange(file2, contentChanged ? (short)8 : 2);
    }

    void recordTransientStateChangeEvent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(2);
        }
        if (LOG != null) {
            LOG.info("Transient state changed for file:" + file2.getPath());
        }
        this.updateChange(file2, (short)16);
    }

    int getPublishedEventIndex() {
        return this.myPublishedEventIndex.get();
    }

    private void updateChange(@NotNull VirtualFile file2, @EventMask short mask) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(3);
        }
        if (file2 instanceof VirtualFileWithId) {
            this.updateChange(((VirtualFileWithId)file2).getId(), file2, mask);
        }
    }

    private void updateChange(int fileId, @NotNull VirtualFile file2, @EventMask short mask) {
        ChangeInfo existingChangeInfo;
        ChangeInfo newChangeInfo;
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(4);
        }
        while (this.myChangeInfos.put(fileId, (Object)(newChangeInfo = new ChangeInfo(file2, mask, existingChangeInfo = (ChangeInfo)this.myChangeInfos.get(fileId)))) != existingChangeInfo) {
        }
        this.myPublishedEventIndex.incrementAndGet();
    }

    void applyMergedEvents(@NotNull VfsEventsMerger merger) {
        if (merger == null) {
            VfsEventsMerger.$$$reportNull$$$0(5);
        }
        for (ChangeInfo info : merger.myChangeInfos.values()) {
            this.updateChange(info.getFileId(), info.file, info.eventMask);
        }
    }

    boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (eventProcessor == null) {
            VfsEventsMerger.$$$reportNull$$$0(6);
        }
        if (!this.myChangeInfos.isEmpty()) {
            int[] fileIds;
            for (int fileId : fileIds = this.myChangeInfos.keys()) {
                ProgressManager.checkCanceled();
                ChangeInfo info = (ChangeInfo)this.myChangeInfos.remove(fileId);
                if (info == null) continue;
                try {
                    if (LOG != null) {
                        LOG.info("Processing " + info);
                    }
                    if (!eventProcessor.process(info)) {
                        return false;
                    }
                }
                catch (ProcessCanceledException pce) {
                    FileBasedIndexImpl.LOG.error((Throwable)pce);
                    assert (false);
                }
            }
        }
        return true;
    }

    boolean hasChanges() {
        return !this.myChangeInfos.isEmpty();
    }

    int getApproximateChangesCount() {
        return this.myChangeInfos.size();
    }

    @NotNull
    public Stream<VirtualFile> getChangedFiles() {
        Stream<VirtualFile> stream = this.myChangeInfos.values().stream().map(ChangeInfo::getFile);
        if (stream == null) {
            VfsEventsMerger.$$$reportNull$$$0(7);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordFileEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordBeforeFileEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordTransientStateChangeEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyMergedEvents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChanges";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLoggerFactory
    implements Logger.Factory {
        @Nullable
        private static final MyLoggerFactory ourFactory;
        @NotNull
        private final RollingFileAppender myAppender;

        MyLoggerFactory() throws IOException {
            Path logPath = IndexDiagnosticDumper.Companion.getIndexingDiagnosticDir().resolve("index-vfs-events.log");
            PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %m\n");
            this.myAppender = new RollingFileAppender((Layout)pattern, logPath.toFile().getAbsolutePath());
            this.myAppender.setMaxFileSize("20MB");
            this.myAppender.setMaxBackupIndex(50);
        }

        @NotNull
        public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                MyLoggerFactory.$$$reportNull$$$0(0);
            }
            Logger logger = Logger.getLogger((String)category);
            logger.removeAllAppenders();
            logger.addAppender((Appender)this.myAppender);
            logger.setAdditivity(false);
            logger.setLevel(Level.INFO);
            return new Log4jBasedLogger(logger);
        }

        @Nullable
        public static com.intellij.openapi.diagnostic.Logger getLoggerInstance() {
            return ourFactory == null ? null : ourFactory.getLoggerInstance("#" + VfsEventsMerger.class.getName());
        }

        static {
            MyLoggerFactory factory2 = null;
            try {
                if (DEBUG) {
                    factory2 = new MyLoggerFactory();
                }
            }
            catch (IOException e) {
                FileBasedIndexImpl.LOG.error((Throwable)e);
            }
            ourFactory = factory2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/util/indexing/events/VfsEventsMerger$MyLoggerFactory", "getLoggerInstance"));
        }
    }

    static class ChangeInfo {
        private final VirtualFile file;
        @EventMask
        private final short eventMask;

        ChangeInfo(@NotNull VirtualFile file2, @EventMask short eventMask, @Nullable ChangeInfo previous) {
            if (file2 == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            this.file = file2;
            this.eventMask = ChangeInfo.mergeEventMask(previous == null ? (short)0 : previous.eventMask, eventMask);
        }

        @EventMask
        private static short mergeEventMask(@EventMask short existingOperation, @EventMask short newOperation) {
            if (newOperation == 2) {
                return 2;
            }
            return (short)(existingOperation | newOperation);
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("file: ").append(this.file.getPath()).append("; ").append("operation: ");
            if ((this.eventMask & 0x10) != 0) {
                builder2.append("TRANSIENT_STATE_CHANGE ");
            }
            if ((this.eventMask & 8) != 0) {
                builder2.append("UPDATE-REMOVE ");
            }
            if ((this.eventMask & 4) != 0) {
                builder2.append("UPDATE ");
            }
            if ((this.eventMask & 2) != 0) {
                builder2.append("REMOVE ");
            }
            if ((this.eventMask & 1) != 0) {
                builder2.append("ADD ");
            }
            return builder2.toString().trim();
        }

        boolean isBeforeContentChanged() {
            return (this.eventMask & 8) != 0;
        }

        boolean isContentChanged() {
            return (this.eventMask & 4) != 0;
        }

        boolean isFileRemoved() {
            return (this.eventMask & 2) != 0;
        }

        boolean isFileAdded() {
            return (this.eventMask & 1) != 0;
        }

        boolean isTransientStateChanged() {
            return (this.eventMask & 0x10) != 0;
        }

        @NotNull
        VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                ChangeInfo.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        int getFileId() {
            int fileId = FileBasedIndex.getFileId((VirtualFile)this.file);
            assert (fileId >= 0);
            return fileId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static @interface EventMask {
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);
    }
}

