/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.resolvers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/JdkRootPortableFilePathResolver;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "intellij.platform.lang.impl"})
public final class JdkRootPortableFilePathResolver
implements PortableFilePathResolver {
    @NotNull
    public static final JdkRootPortableFilePathResolver INSTANCE;

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull Project project, @NotNull PortableFilePath portableFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        if (portableFilePath instanceof PortableFilePath.JdkRoot) {
            boolean $i$f$runReadAction = false;
            return (VirtualFile)ApplicationManager.getApplication().runReadAction(new Computable<T>(portableFilePath){
                final /* synthetic */ PortableFilePath $portableFilePath$inlined;
                {
                    this.$portableFilePath$inlined = portableFilePath;
                }

                public final T compute() {
                    VirtualFile virtualFile;
                    boolean bl = false;
                    Sdk sdk2 = ProjectJdkTable.getInstance().findJdk(((PortableFilePath.JdkRoot)this.$portableFilePath$inlined).getJdkName());
                    if (sdk2 == null) {
                        virtualFile = null;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"ProjectJdkTable.getInsta\u2026return@runReadAction null");
                        Sdk jdk = sdk2;
                        OrderRootType rootType = ((PortableFilePath.JdkRoot)this.$portableFilePath$inlined).getInClassFiles() ? OrderRootType.CLASSES : OrderRootType.SOURCES;
                        Object[] roots = jdk.getRootProvider().getFiles(rootType);
                        Intrinsics.checkNotNullExpressionValue((Object)roots, (String)"roots");
                        virtualFile = (VirtualFile)ArraysKt.getOrNull((Object[])roots, (int)((PortableFilePath.JdkRoot)this.$portableFilePath$inlined).getJdkRootIndex());
                    }
                    return (T)virtualFile;
                }
            });
        }
        return null;
    }

    private JdkRootPortableFilePathResolver() {
    }

    static {
        JdkRootPortableFilePathResolver jdkRootPortableFilePathResolver;
        INSTANCE = jdkRootPortableFilePathResolver = new JdkRootPortableFilePathResolver();
    }
}

