/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\f\u001a\u00060\u0003j\u0002`\u0006H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonProcessingSpeed;", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalTime", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(JJ)V", "getTotalBytes", "()J", "getTotalTime", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "presentableSpeed", "", "toString", "intellij.platform.lang.impl"})
public final class JsonProcessingSpeed {
    private final long totalBytes;
    private final long totalTime;

    @NotNull
    public final String presentableSpeed() {
        if (this.totalTime == 0L) {
            return "0 B/s";
        }
        long bytesPerSecond = (long)((double)this.totalBytes * (double)TimeUnit.SECONDS.toNanos(1L) / (double)this.totalTime);
        return StringUtil.formatFileSize((long)bytesPerSecond) + "/s";
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final long getTotalTime() {
        return this.totalTime;
    }

    public JsonProcessingSpeed(long totalBytes, long totalTime) {
        this.totalBytes = totalBytes;
        this.totalTime = totalTime;
    }

    public final long component1() {
        return this.totalBytes;
    }

    public final long component2() {
        return this.totalTime;
    }

    @NotNull
    public final JsonProcessingSpeed copy(long totalBytes, long totalTime) {
        return new JsonProcessingSpeed(totalBytes, totalTime);
    }

    public static /* synthetic */ JsonProcessingSpeed copy$default(JsonProcessingSpeed jsonProcessingSpeed, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = jsonProcessingSpeed.totalBytes;
        }
        if ((n & 2) != 0) {
            l2 = jsonProcessingSpeed.totalTime;
        }
        return jsonProcessingSpeed.copy(l, l2);
    }

    @NotNull
    public String toString() {
        return "JsonProcessingSpeed(totalBytes=" + this.totalBytes + ", totalTime=" + this.totalTime + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.totalBytes) * 31 + Long.hashCode(this.totalTime);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JsonProcessingSpeed)) break block3;
                JsonProcessingSpeed jsonProcessingSpeed = (JsonProcessingSpeed)object;
                if (this.totalBytes != jsonProcessingSpeed.totalBytes || this.totalTime != jsonProcessingSpeed.totalTime) break block3;
            }
            return true;
        }
        return false;
    }
}

