/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "", "instant", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)V", "getInstant", "()Ljava/time/ZonedDateTime;", "component1", "copy", "equals", "", "other", "hashCode", "", "presentableDateTime", "", "toString", "Deserializer", "Serializer", "intellij.platform.lang.impl"})
public final class JsonDateTime {
    @NotNull
    private final ZonedDateTime instant;

    @NotNull
    public final String presentableDateTime() {
        String string = this.instant.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"instant.format(DateTimeF\u2026atter.RFC_1123_DATE_TIME)");
        return string;
    }

    @NotNull
    public final ZonedDateTime getInstant() {
        return this.instant;
    }

    public JsonDateTime(@NotNull ZonedDateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        this.instant = instant;
    }

    @NotNull
    public final ZonedDateTime component1() {
        return this.instant;
    }

    @NotNull
    public final JsonDateTime copy(@NotNull ZonedDateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return new JsonDateTime(instant);
    }

    public static /* synthetic */ JsonDateTime copy$default(JsonDateTime jsonDateTime, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = jsonDateTime.instant;
        }
        return jsonDateTime.copy(zonedDateTime);
    }

    @NotNull
    public String toString() {
        return "JsonDateTime(instant=" + this.instant + ")";
    }

    public int hashCode() {
        ZonedDateTime zonedDateTime = this.instant;
        return zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JsonDateTime)) break block3;
                JsonDateTime jsonDateTime = (JsonDateTime)object;
                if (!Intrinsics.areEqual((Object)this.instant, (Object)jsonDateTime.instant)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime$Serializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "intellij.platform.lang.impl"})
    public static final class Serializer
    extends JsonSerializer<JsonDateTime> {
        public void serialize(@NotNull JsonDateTime value2, @NotNull JsonGenerator gen, @Nullable SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            gen.writeString(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value2.getInstant()));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime$Deserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.platform.lang.impl"})
    public static final class Deserializer
    extends JsonDeserializer<JsonDateTime> {
        @NotNull
        public JsonDateTime deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(p.getValueAsString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.parse(p.va\u2026tter.ISO_ZONED_DATE_TIME)");
            return new JsonDateTime(zonedDateTime);
        }
    }
}

