/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00060\u001dj\u0002`\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001e\u0010&\u001a\u00060\u001dj\u0002`\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001e\u0010)\u001a\u00060\u001dj\u0002`\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"\u00a8\u00069"}, d2={"Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "", "fileSetName", "", "(Ljava/lang/String;)V", "getFileSetName", "()Ljava/lang/String;", "numberOfFilesForIndexing", "", "getNumberOfFilesForIndexing", "()I", "setNumberOfFilesForIndexing", "(I)V", "numberOfFilesFullyIndexedByInfrastructureExtension", "getNumberOfFilesFullyIndexedByInfrastructureExtension", "setNumberOfFilesFullyIndexedByInfrastructureExtension", "numberOfScannedFiles", "getNumberOfScannedFiles", "setNumberOfScannedFiles", "numberOfSkippedFiles", "getNumberOfSkippedFiles", "setNumberOfSkippedFiles", "scannedFiles", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics$ScannedFile;", "Lkotlin/collections/ArrayList;", "getScannedFiles", "()Ljava/util/ArrayList;", "scanningTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getScanningTime", "()J", "setScanningTime", "(J)V", "timeIndexingWithoutContent", "getTimeIndexingWithoutContent", "setTimeIndexingWithoutContent", "timeProcessingUpToDateFiles", "getTimeProcessingUpToDateFiles", "setTimeProcessingUpToDateFiles", "timeUpdatingContentLessIndexes", "getTimeUpdatingContentLessIndexes", "setTimeUpdatingContentLessIndexes", "addStatus", "", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "unindexedFileStatus", "Lcom/intellij/util/indexing/UnindexedFileStatus;", "statusTime", "project", "Lcom/intellij/openapi/project/Project;", "getIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "file", "ScannedFile", "intellij.platform.lang.impl"})
public final class ScanningStatistics {
    private int numberOfScannedFiles;
    private int numberOfSkippedFiles;
    private int numberOfFilesForIndexing;
    private int numberOfFilesFullyIndexedByInfrastructureExtension;
    private long scanningTime;
    private long timeProcessingUpToDateFiles;
    private long timeUpdatingContentLessIndexes;
    private long timeIndexingWithoutContent;
    @NotNull
    private final ArrayList<ScannedFile> scannedFiles;
    @NotNull
    private final String fileSetName;

    public final int getNumberOfScannedFiles() {
        return this.numberOfScannedFiles;
    }

    public final void setNumberOfScannedFiles(int n) {
        this.numberOfScannedFiles = n;
    }

    public final int getNumberOfSkippedFiles() {
        return this.numberOfSkippedFiles;
    }

    public final void setNumberOfSkippedFiles(int n) {
        this.numberOfSkippedFiles = n;
    }

    public final int getNumberOfFilesForIndexing() {
        return this.numberOfFilesForIndexing;
    }

    public final void setNumberOfFilesForIndexing(int n) {
        this.numberOfFilesForIndexing = n;
    }

    public final int getNumberOfFilesFullyIndexedByInfrastructureExtension() {
        return this.numberOfFilesFullyIndexedByInfrastructureExtension;
    }

    public final void setNumberOfFilesFullyIndexedByInfrastructureExtension(int n) {
        this.numberOfFilesFullyIndexedByInfrastructureExtension = n;
    }

    public final long getScanningTime() {
        return this.scanningTime;
    }

    public final void setScanningTime(long l) {
        this.scanningTime = l;
    }

    public final long getTimeProcessingUpToDateFiles() {
        return this.timeProcessingUpToDateFiles;
    }

    public final void setTimeProcessingUpToDateFiles(long l) {
        this.timeProcessingUpToDateFiles = l;
    }

    public final long getTimeUpdatingContentLessIndexes() {
        return this.timeUpdatingContentLessIndexes;
    }

    public final void setTimeUpdatingContentLessIndexes(long l) {
        this.timeUpdatingContentLessIndexes = l;
    }

    public final long getTimeIndexingWithoutContent() {
        return this.timeIndexingWithoutContent;
    }

    public final void setTimeIndexingWithoutContent(long l) {
        this.timeIndexingWithoutContent = l;
    }

    @NotNull
    public final ArrayList<ScannedFile> getScannedFiles() {
        return this.scannedFiles;
    }

    public final void addStatus(@NotNull VirtualFile fileOrDir, @NotNull UnindexedFileStatus unindexedFileStatus, long statusTime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)unindexedFileStatus, (String)"unindexedFileStatus");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (fileOrDir.isDirectory()) {
            return;
        }
        int n = this.numberOfScannedFiles;
        this.numberOfScannedFiles = n + 1;
        if (unindexedFileStatus.getShouldIndex()) {
            n = this.numberOfFilesForIndexing;
            this.numberOfFilesForIndexing = n + 1;
        }
        this.scanningTime += statusTime;
        this.timeProcessingUpToDateFiles += unindexedFileStatus.getTimeProcessingUpToDateFiles();
        this.timeUpdatingContentLessIndexes += unindexedFileStatus.getTimeUpdatingContentLessIndexes();
        this.timeIndexingWithoutContent += unindexedFileStatus.getTimeIndexingWithoutContent();
        if (unindexedFileStatus.getWasFullyIndexedByInfrastructureExtension()) {
            n = this.numberOfFilesFullyIndexedByInfrastructureExtension;
            this.numberOfFilesFullyIndexedByInfrastructureExtension = n + 1;
        }
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            PortableFilePath portableFilePath = this.getIndexedFilePath(fileOrDir, project);
            Collection collection = this.scannedFiles;
            ScannedFile scannedFile = new ScannedFile(portableFilePath, !unindexedFileStatus.getShouldIndex(), unindexedFileStatus.getWasFullyIndexedByInfrastructureExtension());
            boolean bl = false;
            collection.add(scannedFile);
        }
    }

    private final PortableFilePath getIndexedFilePath(VirtualFile file2, Project project) {
        PortableFilePath portableFilePath;
        try {
            portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file2, project);
        }
        catch (Exception e) {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string);
        }
        return portableFilePath;
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public ScanningStatistics(@NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.fileSetName = fileSetName;
        boolean bl = false;
        this.scannedFiles = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/diagnostic/ScanningStatistics$ScannedFile;", "", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "isUpToDate", "", "wasFullyIndexedByInfrastructureExtension", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;ZZ)V", "()Z", "getPortableFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getWasFullyIndexedByInfrastructureExtension", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class ScannedFile {
        @NotNull
        private final PortableFilePath portableFilePath;
        private final boolean isUpToDate;
        private final boolean wasFullyIndexedByInfrastructureExtension;

        @NotNull
        public final PortableFilePath getPortableFilePath() {
            return this.portableFilePath;
        }

        public final boolean isUpToDate() {
            return this.isUpToDate;
        }

        public final boolean getWasFullyIndexedByInfrastructureExtension() {
            return this.wasFullyIndexedByInfrastructureExtension;
        }

        public ScannedFile(@NotNull PortableFilePath portableFilePath, boolean isUpToDate, boolean wasFullyIndexedByInfrastructureExtension) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            this.portableFilePath = portableFilePath;
            this.isUpToDate = isUpToDate;
            this.wasFullyIndexedByInfrastructureExtension = wasFullyIndexedByInfrastructureExtension;
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.portableFilePath;
        }

        public final boolean component2() {
            return this.isUpToDate;
        }

        public final boolean component3() {
            return this.wasFullyIndexedByInfrastructureExtension;
        }

        @NotNull
        public final ScannedFile copy(@NotNull PortableFilePath portableFilePath, boolean isUpToDate, boolean wasFullyIndexedByInfrastructureExtension) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            return new ScannedFile(portableFilePath, isUpToDate, wasFullyIndexedByInfrastructureExtension);
        }

        public static /* synthetic */ ScannedFile copy$default(ScannedFile scannedFile, PortableFilePath portableFilePath, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = scannedFile.portableFilePath;
            }
            if ((n & 2) != 0) {
                bl = scannedFile.isUpToDate;
            }
            if ((n & 4) != 0) {
                bl2 = scannedFile.wasFullyIndexedByInfrastructureExtension;
            }
            return scannedFile.copy(portableFilePath, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ScannedFile(portableFilePath=" + this.portableFilePath + ", isUpToDate=" + this.isUpToDate + ", wasFullyIndexedByInfrastructureExtension=" + this.wasFullyIndexedByInfrastructureExtension + ")";
        }

        public int hashCode() {
            PortableFilePath portableFilePath = this.portableFilePath;
            int n = (portableFilePath != null ? portableFilePath.hashCode() : 0) * 31;
            int n2 = this.isUpToDate ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.wasFullyIndexedByInfrastructureExtension ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ScannedFile)) break block3;
                    ScannedFile scannedFile = (ScannedFile)object;
                    if (!Intrinsics.areEqual((Object)this.portableFilePath, (Object)scannedFile.portableFilePath) || this.isUpToDate != scannedFile.isUpToDate || this.wasFullyIndexedByInfrastructureExtension != scannedFile.wasFullyIndexedByInfrastructureExtension) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

