/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001:\u00041234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020%J\u0014\u0010&\u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001J\t\u00100\u001a\u00020\u0018H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00100\nj\b\u0012\u0004\u0012\u00020\u0010`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R-\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR-\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001e0\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001e`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u00065"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "biggestContributorsPerFileTypeLimit", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "providerStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonFileProviderIndexStatistics;", "Lkotlin/collections/ArrayList;", "getProviderStatistics", "()Ljava/util/ArrayList;", "scanningStatistics", "Lcom/intellij/util/indexing/diagnostic/dto/JsonScanningStatistics;", "getScanningStatistics", "times", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "getTimes", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "totalStatsPerFileType", "Ljava/util/HashMap;", "", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getTotalStatsPerFileType", "()Ljava/util/HashMap;", "totalStatsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "getTotalStatsPerIndexer", "addProviderStatistics", "", "statistics", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "addScanningStatistics", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "addSnapshotInputMappingStatistics", "snapshotInputMappingsStatistics", "", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappingsStatistics;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "BiggestFileTypeContributor", "IndexingTimes", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistory {
    private final int biggestContributorsPerFileTypeLimit;
    @NotNull
    private final IndexingTimes times;
    @NotNull
    private final ArrayList<JsonScanningStatistics> scanningStatistics;
    @NotNull
    private final ArrayList<JsonFileProviderIndexStatistics> providerStatistics;
    @NotNull
    private final HashMap<String, StatsPerFileType> totalStatsPerFileType;
    @NotNull
    private final HashMap<String, StatsPerIndexer> totalStatsPerIndexer;
    @NotNull
    private final Project project;

    @NotNull
    public final IndexingTimes getTimes() {
        return this.times;
    }

    @NotNull
    public final ArrayList<JsonScanningStatistics> getScanningStatistics() {
        return this.scanningStatistics;
    }

    @NotNull
    public final ArrayList<JsonFileProviderIndexStatistics> getProviderStatistics() {
        return this.providerStatistics;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getTotalStatsPerFileType() {
        return this.totalStatsPerFileType;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getTotalStatsPerIndexer() {
        return this.totalStatsPerIndexer;
    }

    public final void addScanningStatistics(@NotNull ScanningStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Collection collection = this.scanningStatistics;
        JsonScanningStatistics jsonScanningStatistics = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        collection.add(jsonScanningStatistics);
    }

    /*
     * WARNING - void declaration
     */
    public final void addProviderStatistics(@NotNull IndexingJobStatistics statistics) {
        Object totalStats;
        Object answer$iv;
        Object value$iv;
        Object fileType;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv22;
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Map.Entry entry3 = this.providerStatistics;
        Iterator iterator2 = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        entry3.add(iterator2);
        Object object = statistics.getStatsPerFileType();
        boolean bl2 = false;
        iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Map.Entry entry2 = entry3 = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            object = (String)entry2.getKey();
            entry2 = entry3;
            bl3 = false;
            IndexingJobStatistics.StatsPerFileType fileTypeStats = (IndexingJobStatistics.StatsPerFileType)entry2.getValue();
            $this$getOrPut$iv22 = this.totalStatsPerFileType;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(fileType);
            if (value$iv == null) {
                boolean bl4 = false;
                boolean bl5 = false;
                answer$iv = new StatsPerFileType(0, 0L, 0L, 0L, new LimitedPriorityQueue<BiggestFileTypeContributor>(this.biggestContributorsPerFileTypeLimit, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BiggestFileTypeContributor it = (BiggestFileTypeContributor)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getIndexingTimeInAllThreads());
                        it = (BiggestFileTypeContributor)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getIndexingTimeInAllThreads());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                }));
                $this$getOrPut$iv22.put(fileType, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Object object3 = totalStats = (StatsPerFileType)object2;
            ((StatsPerFileType)object3).setTotalNumberOfFiles(((StatsPerFileType)object3).getTotalNumberOfFiles() + fileTypeStats.getNumberOfFiles());
            Object object4 = totalStats;
            ((StatsPerFileType)object4).setTotalBytes(((StatsPerFileType)object4).getTotalBytes() + fileTypeStats.getTotalBytes());
            Object object5 = totalStats;
            ((StatsPerFileType)object5).setTotalIndexingTimeInAllThreads(((StatsPerFileType)object5).getTotalIndexingTimeInAllThreads() + fileTypeStats.getIndexingTime().getSumTime());
            Object object6 = totalStats;
            ((StatsPerFileType)object6).setTotalContentLoadingTimeInAllThreads(((StatsPerFileType)object6).getTotalContentLoadingTimeInAllThreads() + fileTypeStats.getContentLoadingTime().getSumTime());
            ((StatsPerFileType)totalStats).getBiggestFileTypeContributors().addElement(new BiggestFileTypeContributor(statistics.getFileSetName(), fileTypeStats.getNumberOfFiles(), fileTypeStats.getTotalBytes(), fileTypeStats.getIndexingTime().getSumTime()));
        }
        fileType = statistics.getStatsPerIndexer();
        boolean fileTypeStats = false;
        for (Map.Entry entry3 : fileType.entrySet()) {
            Object object7;
            void indexId;
            totalStats = entry3;
            boolean $this$getOrPut$iv22 = false;
            fileType = (String)totalStats.getKey();
            totalStats = entry3;
            $this$getOrPut$iv22 = false;
            IndexingJobStatistics.StatsPerIndexer stats = (IndexingJobStatistics.StatsPerIndexer)totalStats.getValue();
            $this$getOrPut$iv22 = this.totalStatsPerIndexer;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(indexId);
            if (value$iv == null) {
                boolean bl6 = false;
                answer$iv = new StatsPerIndexer(0, 0, 0L, 0L, new StatsPerIndexer.SnapshotInputMappingStats(0L, 0L));
                $this$getOrPut$iv22.put(indexId, answer$iv);
                object7 = answer$iv;
            } else {
                object7 = value$iv;
            }
            Object object8 = totalStats = (StatsPerIndexer)object7;
            ((StatsPerIndexer)object8).setTotalNumberOfFiles(((StatsPerIndexer)object8).getTotalNumberOfFiles() + stats.getNumberOfFiles());
            Object object9 = totalStats;
            ((StatsPerIndexer)object9).setTotalNumberOfFilesIndexedByExtensions(((StatsPerIndexer)object9).getTotalNumberOfFilesIndexedByExtensions() + stats.getNumberOfFilesIndexedByExtensions());
            Object object10 = totalStats;
            ((StatsPerIndexer)object10).setTotalBytes(((StatsPerIndexer)object10).getTotalBytes() + stats.getTotalBytes());
            Object object11 = totalStats;
            ((StatsPerIndexer)object11).setTotalIndexingTimeInAllThreads(((StatsPerIndexer)object11).getTotalIndexingTimeInAllThreads() + stats.getIndexingTime().getSumTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addSnapshotInputMappingStatistics(@NotNull List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics) {
        Intrinsics.checkNotNullParameter(snapshotInputMappingsStatistics, (String)"snapshotInputMappingsStatistics");
        for (SnapshotInputMappingsStatistics mappingsStatistic : snapshotInputMappingsStatistics) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Map map2 = this.totalStatsPerIndexer;
            ID<?, ?> iD = mappingsStatistic.getIndexId();
            Intrinsics.checkNotNullExpressionValue(iD, (String)"mappingsStatistic.indexId");
            Intrinsics.checkNotNullExpressionValue((Object)iD.getName(), (String)"mappingsStatistic.indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(0, 0, 0L, 0L, new StatsPerIndexer.SnapshotInputMappingStats(0L, 0L));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            StatsPerIndexer totalStats = (StatsPerIndexer)object;
            StatsPerIndexer.SnapshotInputMappingStats snapshotInputMappingStats = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStats.setRequests(snapshotInputMappingStats.getRequests() + mappingsStatistic.getTotalRequests());
            StatsPerIndexer.SnapshotInputMappingStats snapshotInputMappingStats2 = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStats2.setMisses(snapshotInputMappingStats2.getMisses() + mappingsStatistic.getTotalMisses());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectIndexingHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.biggestContributorsPerFileTypeLimit = 10;
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now(ZoneOffset.UTC)");
        this.times = new IndexingTimes(zonedDateTime, null, null, null, null, null, null, false, 254, null);
        boolean bl = false;
        this.scanningStatistics = new ArrayList();
        bl = false;
        this.providerStatistics = new ArrayList();
        bl = false;
        this.totalStatsPerFileType = new HashMap();
        bl = false;
        this.totalStatsPerIndexer = new HashMap();
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final ProjectIndexingHistory copy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ProjectIndexingHistory(project);
    }

    public static /* synthetic */ ProjectIndexingHistory copy$default(ProjectIndexingHistory projectIndexingHistory, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = projectIndexingHistory.project;
        }
        return projectIndexingHistory.copy(project);
    }

    @NotNull
    public String toString() {
        return "ProjectIndexingHistory(project=" + this.project + ")";
    }

    public int hashCode() {
        Project project = this.project;
        return project != null ? project.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProjectIndexingHistory)) break block3;
                ProjectIndexingHistory projectIndexingHistory = (ProjectIndexingHistory)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)projectIndexingHistory.project)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u001e\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JM\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0005j\u0002`\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalContentLoadingTimeInAllThreads", "biggestFileTypeContributors", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "(IJJJLcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;)V", "getBiggestFileTypeContributors", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalContentLoadingTimeInAllThreads", "setTotalContentLoadingTimeInAllThreads", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        private long totalContentLoadingTimeInAllThreads;
        @NotNull
        private final LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        public final long getTotalContentLoadingTimeInAllThreads() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        public final void setTotalContentLoadingTimeInAllThreads(long l) {
            this.totalContentLoadingTimeInAllThreads = l;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> getBiggestFileTypeContributors() {
            return this.biggestFileTypeContributors;
        }

        public StatsPerFileType(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.totalContentLoadingTimeInAllThreads = totalContentLoadingTimeInAllThreads;
            this.biggestFileTypeContributors = biggestFileTypeContributors;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final long component2() {
            return this.totalBytes;
        }

        public final long component3() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final long component4() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> component5() {
            return this.biggestFileTypeContributors;
        }

        @NotNull
        public final StatsPerFileType copy(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            return new StatsPerFileType(totalNumberOfFiles, totalBytes, totalIndexingTimeInAllThreads, totalContentLoadingTimeInAllThreads, biggestFileTypeContributors);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, int n, long l, long l2, long l3, LimitedPriorityQueue limitedPriorityQueue, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerFileType.totalNumberOfFiles;
            }
            if ((n2 & 2) != 0) {
                l = statsPerFileType.totalBytes;
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerFileType.totalIndexingTimeInAllThreads;
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileType.totalContentLoadingTimeInAllThreads;
            }
            if ((n2 & 0x10) != 0) {
                limitedPriorityQueue = statsPerFileType.biggestFileTypeContributors;
            }
            return statsPerFileType.copy(n, l, l2, l3, limitedPriorityQueue);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalBytes=" + this.totalBytes + ", totalIndexingTimeInAllThreads=" + this.totalIndexingTimeInAllThreads + ", totalContentLoadingTimeInAllThreads=" + this.totalContentLoadingTimeInAllThreads + ", biggestFileTypeContributors=" + this.biggestFileTypeContributors + ")";
        }

        public int hashCode() {
            LimitedPriorityQueue<BiggestFileTypeContributor> limitedPriorityQueue = this.biggestFileTypeContributors;
            return (((Integer.hashCode(this.totalNumberOfFiles) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalIndexingTimeInAllThreads)) * 31 + Long.hashCode(this.totalContentLoadingTimeInAllThreads)) * 31 + (limitedPriorityQueue != null ? limitedPriorityQueue.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (this.totalNumberOfFiles != statsPerFileType.totalNumberOfFiles || this.totalBytes != statsPerFileType.totalBytes || this.totalIndexingTimeInAllThreads != statsPerFileType.totalIndexingTimeInAllThreads || this.totalContentLoadingTimeInAllThreads != statsPerFileType.totalContentLoadingTimeInAllThreads || !Intrinsics.areEqual(this.biggestFileTypeContributors, statsPerFileType.biggestFileTypeContributors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\nH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0007j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "", "providerName", "", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "indexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(Ljava/lang/String;IJJ)V", "getIndexingTimeInAllThreads", "()J", "getNumberOfFiles", "()I", "getProviderName", "()Ljava/lang/String;", "getTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class BiggestFileTypeContributor {
        @NotNull
        private final String providerName;
        private final int numberOfFiles;
        private final long totalBytes;
        private final long indexingTimeInAllThreads;

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final long getIndexingTimeInAllThreads() {
            return this.indexingTimeInAllThreads;
        }

        public BiggestFileTypeContributor(@NotNull String providerName, int numberOfFiles, long totalBytes, long indexingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerName = providerName;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
            this.indexingTimeInAllThreads = indexingTimeInAllThreads;
        }

        @NotNull
        public final String component1() {
            return this.providerName;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final long component3() {
            return this.totalBytes;
        }

        public final long component4() {
            return this.indexingTimeInAllThreads;
        }

        @NotNull
        public final BiggestFileTypeContributor copy(@NotNull String providerName, int numberOfFiles, long totalBytes, long indexingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new BiggestFileTypeContributor(providerName, numberOfFiles, totalBytes, indexingTimeInAllThreads);
        }

        public static /* synthetic */ BiggestFileTypeContributor copy$default(BiggestFileTypeContributor biggestFileTypeContributor, String string, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = biggestFileTypeContributor.providerName;
            }
            if ((n2 & 2) != 0) {
                n = biggestFileTypeContributor.numberOfFiles;
            }
            if ((n2 & 4) != 0) {
                l = biggestFileTypeContributor.totalBytes;
            }
            if ((n2 & 8) != 0) {
                l2 = biggestFileTypeContributor.indexingTimeInAllThreads;
            }
            return biggestFileTypeContributor.copy(string, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "BiggestFileTypeContributor(providerName=" + this.providerName + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ", indexingTimeInAllThreads=" + this.indexingTimeInAllThreads + ")";
        }

        public int hashCode() {
            String string = this.providerName;
            return (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.indexingTimeInAllThreads);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BiggestFileTypeContributor)) break block3;
                    BiggestFileTypeContributor biggestFileTypeContributor = (BiggestFileTypeContributor)object;
                    if (!Intrinsics.areEqual((Object)this.providerName, (Object)biggestFileTypeContributor.providerName) || this.numberOfFiles != biggestFileTypeContributor.numberOfFiles || this.totalBytes != biggestFileTypeContributor.totalBytes || this.indexingTimeInAllThreads != biggestFileTypeContributor.indexingTimeInAllThreads) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J\r\u0010 \u001a\u00060\u0006j\u0002`\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\b\u001a\u00060\u0006j\u0002`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "", "totalNumberOfFiles", "", "totalNumberOfFilesIndexedByExtensions", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "snapshotInputMappingStats", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "(IIJJLcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;)V", "getSnapshotInputMappingStats", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "setSnapshotInputMappingStats", "(Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalNumberOfFilesIndexedByExtensions", "setTotalNumberOfFilesIndexedByExtensions", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "SnapshotInputMappingStats", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        private int totalNumberOfFiles;
        private int totalNumberOfFilesIndexedByExtensions;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        @NotNull
        private SnapshotInputMappingStats snapshotInputMappingStats;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final int getTotalNumberOfFilesIndexedByExtensions() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public final void setTotalNumberOfFilesIndexedByExtensions(int n) {
            this.totalNumberOfFilesIndexedByExtensions = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        @NotNull
        public final SnapshotInputMappingStats getSnapshotInputMappingStats() {
            return this.snapshotInputMappingStats;
        }

        public final void setSnapshotInputMappingStats(@NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"<set-?>");
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public StatsPerIndexer(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalNumberOfFilesIndexedByExtensions = totalNumberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final int component2() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public final long component3() {
            return this.totalBytes;
        }

        public final long component4() {
            return this.totalIndexingTimeInAllThreads;
        }

        @NotNull
        public final SnapshotInputMappingStats component5() {
            return this.snapshotInputMappingStats;
        }

        @NotNull
        public final StatsPerIndexer copy(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            return new StatsPerIndexer(totalNumberOfFiles, totalNumberOfFilesIndexedByExtensions, totalBytes, totalIndexingTimeInAllThreads, snapshotInputMappingStats);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, int n, int n2, long l, long l2, SnapshotInputMappingStats snapshotInputMappingStats, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = statsPerIndexer.totalNumberOfFiles;
            }
            if ((n3 & 2) != 0) {
                n2 = statsPerIndexer.totalNumberOfFilesIndexedByExtensions;
            }
            if ((n3 & 4) != 0) {
                l = statsPerIndexer.totalBytes;
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexer.totalIndexingTimeInAllThreads;
            }
            if ((n3 & 0x10) != 0) {
                snapshotInputMappingStats = statsPerIndexer.snapshotInputMappingStats;
            }
            return statsPerIndexer.copy(n, n2, l, l2, snapshotInputMappingStats);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalNumberOfFilesIndexedByExtensions=" + this.totalNumberOfFilesIndexedByExtensions + ", totalBytes=" + this.totalBytes + ", totalIndexingTimeInAllThreads=" + this.totalIndexingTimeInAllThreads + ", snapshotInputMappingStats=" + this.snapshotInputMappingStats + ")";
        }

        public int hashCode() {
            SnapshotInputMappingStats snapshotInputMappingStats = this.snapshotInputMappingStats;
            return (((Integer.hashCode(this.totalNumberOfFiles) * 31 + Integer.hashCode(this.totalNumberOfFilesIndexedByExtensions)) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalIndexingTimeInAllThreads)) * 31 + (snapshotInputMappingStats != null ? ((Object)snapshotInputMappingStats).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (this.totalNumberOfFiles != statsPerIndexer.totalNumberOfFiles || this.totalNumberOfFilesIndexedByExtensions != statsPerIndexer.totalNumberOfFilesIndexedByExtensions || this.totalBytes != statsPerIndexer.totalBytes || this.totalIndexingTimeInAllThreads != statsPerIndexer.totalIndexingTimeInAllThreads || !Intrinsics.areEqual((Object)this.snapshotInputMappingStats, (Object)statsPerIndexer.snapshotInputMappingStats)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "", "requests", "", "misses", "(JJ)V", "hits", "getHits", "()J", "getMisses", "setMisses", "(J)V", "getRequests", "setRequests", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
        public static final class SnapshotInputMappingStats {
            private long requests;
            private long misses;

            public final long getHits() {
                return this.requests - this.misses;
            }

            public final long getRequests() {
                return this.requests;
            }

            public final void setRequests(long l) {
                this.requests = l;
            }

            public final long getMisses() {
                return this.misses;
            }

            public final void setMisses(long l) {
                this.misses = l;
            }

            public SnapshotInputMappingStats(long requests2, long misses) {
                this.requests = requests2;
                this.misses = misses;
            }

            public final long component1() {
                return this.requests;
            }

            public final long component2() {
                return this.misses;
            }

            @NotNull
            public final SnapshotInputMappingStats copy(long requests2, long misses) {
                return new SnapshotInputMappingStats(requests2, misses);
            }

            public static /* synthetic */ SnapshotInputMappingStats copy$default(SnapshotInputMappingStats snapshotInputMappingStats, long l, long l2, int n, Object object) {
                if ((n & 1) != 0) {
                    l = snapshotInputMappingStats.requests;
                }
                if ((n & 2) != 0) {
                    l2 = snapshotInputMappingStats.misses;
                }
                return snapshotInputMappingStats.copy(l, l2);
            }

            @NotNull
            public String toString() {
                return "SnapshotInputMappingStats(requests=" + this.requests + ", misses=" + this.misses + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.requests) * 31 + Long.hashCode(this.misses);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SnapshotInputMappingStats)) break block3;
                        SnapshotInputMappingStats snapshotInputMappingStats = (SnapshotInputMappingStats)object;
                        if (this.requests != snapshotInputMappingStats.requests || this.misses != snapshotInputMappingStats.misses) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003JY\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010,\u001a\u00020\f2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "", "updatingStart", "Ljava/time/ZonedDateTime;", "updatingEnd", "indexingDuration", "Ljava/time/Duration;", "pushPropertiesDuration", "indexExtensionsDuration", "scanFilesDuration", "suspendedDuration", "wasInterrupted", "", "(Ljava/time/ZonedDateTime;Ljava/time/ZonedDateTime;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Z)V", "getIndexExtensionsDuration", "()Ljava/time/Duration;", "setIndexExtensionsDuration", "(Ljava/time/Duration;)V", "getIndexingDuration", "setIndexingDuration", "getPushPropertiesDuration", "setPushPropertiesDuration", "getScanFilesDuration", "setScanFilesDuration", "getSuspendedDuration", "setSuspendedDuration", "getUpdatingEnd", "()Ljava/time/ZonedDateTime;", "setUpdatingEnd", "(Ljava/time/ZonedDateTime;)V", "getUpdatingStart", "getWasInterrupted", "()Z", "setWasInterrupted", "(Z)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class IndexingTimes {
        @NotNull
        private final ZonedDateTime updatingStart;
        @NotNull
        private ZonedDateTime updatingEnd;
        @NotNull
        private Duration indexingDuration;
        @NotNull
        private Duration pushPropertiesDuration;
        @NotNull
        private Duration indexExtensionsDuration;
        @NotNull
        private Duration scanFilesDuration;
        @NotNull
        private Duration suspendedDuration;
        private boolean wasInterrupted;

        @NotNull
        public final ZonedDateTime getUpdatingStart() {
            return this.updatingStart;
        }

        @NotNull
        public final ZonedDateTime getUpdatingEnd() {
            return this.updatingEnd;
        }

        public final void setUpdatingEnd(@NotNull ZonedDateTime zonedDateTime) {
            Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"<set-?>");
            this.updatingEnd = zonedDateTime;
        }

        @NotNull
        public final Duration getIndexingDuration() {
            return this.indexingDuration;
        }

        public final void setIndexingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexingDuration = duration;
        }

        @NotNull
        public final Duration getPushPropertiesDuration() {
            return this.pushPropertiesDuration;
        }

        public final void setPushPropertiesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.pushPropertiesDuration = duration;
        }

        @NotNull
        public final Duration getIndexExtensionsDuration() {
            return this.indexExtensionsDuration;
        }

        public final void setIndexExtensionsDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexExtensionsDuration = duration;
        }

        @NotNull
        public final Duration getScanFilesDuration() {
            return this.scanFilesDuration;
        }

        public final void setScanFilesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.scanFilesDuration = duration;
        }

        @NotNull
        public final Duration getSuspendedDuration() {
            return this.suspendedDuration;
        }

        public final void setSuspendedDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.suspendedDuration = duration;
        }

        public final boolean getWasInterrupted() {
            return this.wasInterrupted;
        }

        public final void setWasInterrupted(boolean bl) {
            this.wasInterrupted = bl;
        }

        public IndexingTimes(@NotNull ZonedDateTime updatingStart, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            this.updatingStart = updatingStart;
            this.updatingEnd = updatingEnd;
            this.indexingDuration = indexingDuration;
            this.pushPropertiesDuration = pushPropertiesDuration;
            this.indexExtensionsDuration = indexExtensionsDuration;
            this.scanFilesDuration = scanFilesDuration;
            this.suspendedDuration = suspendedDuration;
            this.wasInterrupted = wasInterrupted;
        }

        public /* synthetic */ IndexingTimes(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                zonedDateTime2 = zonedDateTime;
            }
            if ((n & 4) != 0) {
                Duration duration6 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"Duration.ZERO");
                duration = duration6;
            }
            if ((n & 8) != 0) {
                Duration duration7 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"Duration.ZERO");
                duration2 = duration7;
            }
            if ((n & 0x10) != 0) {
                Duration duration8 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"Duration.ZERO");
                duration3 = duration8;
            }
            if ((n & 0x20) != 0) {
                Duration duration9 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"Duration.ZERO");
                duration4 = duration9;
            }
            if ((n & 0x40) != 0) {
                Duration duration10 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"Duration.ZERO");
                duration5 = duration10;
            }
            if ((n & 0x80) != 0) {
                bl = false;
            }
            this(zonedDateTime, zonedDateTime2, duration, duration2, duration3, duration4, duration5, bl);
        }

        @NotNull
        public final ZonedDateTime component1() {
            return this.updatingStart;
        }

        @NotNull
        public final ZonedDateTime component2() {
            return this.updatingEnd;
        }

        @NotNull
        public final Duration component3() {
            return this.indexingDuration;
        }

        @NotNull
        public final Duration component4() {
            return this.pushPropertiesDuration;
        }

        @NotNull
        public final Duration component5() {
            return this.indexExtensionsDuration;
        }

        @NotNull
        public final Duration component6() {
            return this.scanFilesDuration;
        }

        @NotNull
        public final Duration component7() {
            return this.suspendedDuration;
        }

        public final boolean component8() {
            return this.wasInterrupted;
        }

        @NotNull
        public final IndexingTimes copy(@NotNull ZonedDateTime updatingStart, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            return new IndexingTimes(updatingStart, updatingEnd, indexingDuration, pushPropertiesDuration, indexExtensionsDuration, scanFilesDuration, suspendedDuration, wasInterrupted);
        }

        public static /* synthetic */ IndexingTimes copy$default(IndexingTimes indexingTimes, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                zonedDateTime = indexingTimes.updatingStart;
            }
            if ((n & 2) != 0) {
                zonedDateTime2 = indexingTimes.updatingEnd;
            }
            if ((n & 4) != 0) {
                duration = indexingTimes.indexingDuration;
            }
            if ((n & 8) != 0) {
                duration2 = indexingTimes.pushPropertiesDuration;
            }
            if ((n & 0x10) != 0) {
                duration3 = indexingTimes.indexExtensionsDuration;
            }
            if ((n & 0x20) != 0) {
                duration4 = indexingTimes.scanFilesDuration;
            }
            if ((n & 0x40) != 0) {
                duration5 = indexingTimes.suspendedDuration;
            }
            if ((n & 0x80) != 0) {
                bl = indexingTimes.wasInterrupted;
            }
            return indexingTimes.copy(zonedDateTime, zonedDateTime2, duration, duration2, duration3, duration4, duration5, bl);
        }

        @NotNull
        public String toString() {
            return "IndexingTimes(updatingStart=" + this.updatingStart + ", updatingEnd=" + this.updatingEnd + ", indexingDuration=" + this.indexingDuration + ", pushPropertiesDuration=" + this.pushPropertiesDuration + ", indexExtensionsDuration=" + this.indexExtensionsDuration + ", scanFilesDuration=" + this.scanFilesDuration + ", suspendedDuration=" + this.suspendedDuration + ", wasInterrupted=" + this.wasInterrupted + ")";
        }

        public int hashCode() {
            ZonedDateTime zonedDateTime = this.updatingStart;
            ZonedDateTime zonedDateTime2 = this.updatingEnd;
            Duration duration = this.indexingDuration;
            Duration duration2 = this.pushPropertiesDuration;
            Duration duration3 = this.indexExtensionsDuration;
            Duration duration4 = this.scanFilesDuration;
            Duration duration5 = this.suspendedDuration;
            int n = (((((((zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0) * 31 + (zonedDateTime2 != null ? ((Object)zonedDateTime2).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (duration3 != null ? ((Object)duration3).hashCode() : 0)) * 31 + (duration4 != null ? ((Object)duration4).hashCode() : 0)) * 31 + (duration5 != null ? ((Object)duration5).hashCode() : 0)) * 31;
            int n2 = this.wasInterrupted ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexingTimes)) break block3;
                    IndexingTimes indexingTimes = (IndexingTimes)object;
                    if (!Intrinsics.areEqual((Object)this.updatingStart, (Object)indexingTimes.updatingStart) || !Intrinsics.areEqual((Object)this.updatingEnd, (Object)indexingTimes.updatingEnd) || !Intrinsics.areEqual((Object)this.indexingDuration, (Object)indexingTimes.indexingDuration) || !Intrinsics.areEqual((Object)this.pushPropertiesDuration, (Object)indexingTimes.pushPropertiesDuration) || !Intrinsics.areEqual((Object)this.indexExtensionsDuration, (Object)indexingTimes.indexExtensionsDuration) || !Intrinsics.areEqual((Object)this.scanFilesDuration, (Object)indexingTimes.scanFilesDuration) || !Intrinsics.areEqual((Object)this.suspendedDuration, (Object)indexingTimes.suspendedDuration) || this.wasInterrupted != indexingTimes.wasInterrupted) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

