/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.presentation.JsonToHtmlConverterKt;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "Lcom/intellij/openapi/Disposable;", "()V", "isDisposed", "", "cleanupOldDiagnostics", "", "indexDiagnosticDirectory", "Ljava/nio/file/Path;", "dispose", "dumpProjectIndexingHistoryIfNecessary", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "dumpProjectIndexingHistoryToLogSubdirectory", "getFilesForNewJsonAndHtmlDiagnostics", "Lkotlin/Pair;", "Companion", "ProjectIndexingHistoryListener", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumper
implements Disposable {
    private boolean isDisposed;
    private static final DateTimeFormatter diagnosticDateTimeFormatter;
    private static final String fileNamePrefix = "diagnostic-";
    @TestOnly
    private static boolean shouldDumpInUnitTestMode;
    private static final Logger LOG;
    private static final Lazy jacksonMapper$delegate;
    @NotNull
    private static final Lazy indexingDiagnosticDir$delegate;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpProjectIndexingHistoryIfNecessary(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
                try {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode() || shouldDumpInUnitTestMode) break block4;
                }
                catch (Throwable throwable) {
                    ProjectIndexingHistoryListener.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<ProjectIndexingHistoryListener>(projectIndexingHistory){
                        final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

                        public final void accept(ProjectIndexingHistoryListener it) {
                            it.onFinishedIndexing(this.$projectIndexingHistory);
                        }
                        {
                            this.$projectIndexingHistory = projectIndexingHistory;
                        }
                    });
                    throw throwable;
                }
                ProjectIndexingHistoryListener.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new /* invalid duplicate definition of identical inner class */);
                return;
            }
            if (!projectIndexingHistory.getTimes().getWasInterrupted() || IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters()) break block5;
            ProjectIndexingHistoryListener.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(this, projectIndexingHistory){
            final /* synthetic */ IndexDiagnosticDumper this$0;
            final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

            public final void run() {
                IndexDiagnosticDumper.access$dumpProjectIndexingHistoryToLogSubdirectory(this.this$0, this.$projectIndexingHistory);
            }
            {
                this.this$0 = indexDiagnosticDumper;
                this.$projectIndexingHistory = projectIndexingHistory;
            }
        });
        ProjectIndexingHistoryListener.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(ProjectIndexingHistory projectIndexingHistory) {
        try {
            void diagnosticJson;
            boolean bl = !this.isDisposed;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Path indexDiagnosticDirectory = ProjectUtil.getProjectCachePath$default((Project)projectIndexingHistory.getProject(), (Path)Companion.getIndexingDiagnosticDir(), (boolean)false, null, (int)6, null);
            PathKt.createDirectories((Path)indexDiagnosticDirectory);
            Pair<Path, Path> pair = this.getFilesForNewJsonAndHtmlDiagnostics(indexDiagnosticDirectory);
            Path path = (Path)pair.component1();
            Path diagnosticHtml = (Path)pair.component2();
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            IndexDiagnosticDumper.Companion.getJacksonMapper().writerWithDefaultPrettyPrinter().writeValue(diagnosticJson.toFile(), (Object)jsonIndexDiagnostic);
            PathKt.write$default((Path)diagnosticHtml, (CharSequence)JsonToHtmlConverterKt.generateHtml(jsonIndexDiagnostic), null, (boolean)false, (int)6, null);
            this.cleanupOldDiagnostics(indexDiagnosticDirectory);
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", (Throwable)e);
        }
    }

    private final Pair<Path, Path> getFilesForNewJsonAndHtmlDiagnostics(Path indexDiagnosticDirectory) {
        Path diagnosticJson = null;
        Path diagnosticHtml = null;
        LocalDateTime nowTime = LocalDateTime.now();
        while (true) {
            String timestamp = nowTime.format(diagnosticDateTimeFormatter);
            Intrinsics.checkNotNullExpressionValue((Object)indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".json"), (String)"indexDiagnosticDirectory\u2026mePrefix$timestamp.json\")");
            Intrinsics.checkNotNullExpressionValue((Object)indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".html"), (String)"indexDiagnosticDirectory\u2026mePrefix$timestamp.html\")");
            if (!PathKt.exists((Path)diagnosticJson) && !PathKt.exists((Path)diagnosticHtml)) break;
            nowTime = nowTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L));
        }
        return TuplesKt.to((Object)diagnosticJson, (Object)diagnosticHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupOldDiagnostics(Path indexDiagnosticDirectory) {
        void $this$sortedByDescending$iv;
        List list2;
        AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream files2 = (Stream)autoCloseable;
            boolean bl3 = false;
            Stream stream = files2;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"files");
            list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)cleanupOldDiagnostics.existingDiagnostics.1.1.INSTANCE), (Function1)cleanupOldDiagnostics.existingDiagnostics.1.2.INSTANCE));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        List existingDiagnostics2 = list2;
        Object object = existingDiagnostics2;
        boolean $i$f$sortedByDescending = false;
        boolean bl4 = false;
        List survivedDiagnostics = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J,\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"com/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$cleanupOldDiagnostics$ExistingDiagnostic", "", "timestamp", "Ljava/time/LocalDateTime;", "jsonFile", "Ljava/nio/file/Path;", "htmlFile", "(Ljava/time/LocalDateTime;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getHtmlFile", "()Ljava/nio/file/Path;", "getJsonFile", "getTimestamp", "()Ljava/time/LocalDateTime;", "component1", "component2", "component3", "copy", "(Ljava/time/LocalDateTime;Ljava/nio/file/Path;Ljava/nio/file/Path;)Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$cleanupOldDiagnostics$ExistingDiagnostic;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
                public final class ExistingDiagnostic {
                    @NotNull
                    private final LocalDateTime timestamp;
                    @NotNull
                    private final Path jsonFile;
                    @NotNull
                    private final Path htmlFile;

                    @NotNull
                    public final LocalDateTime getTimestamp() {
                        return this.timestamp;
                    }

                    @NotNull
                    public final Path getJsonFile() {
                        return this.jsonFile;
                    }

                    @NotNull
                    public final Path getHtmlFile() {
                        return this.htmlFile;
                    }

                    public ExistingDiagnostic(@NotNull LocalDateTime timestamp, @NotNull Path jsonFile, @NotNull Path htmlFile) {
                        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
                        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
                        Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
                        this.timestamp = timestamp;
                        this.jsonFile = jsonFile;
                        this.htmlFile = htmlFile;
                    }

                    @NotNull
                    public final LocalDateTime component1() {
                        return this.timestamp;
                    }

                    @NotNull
                    public final Path component2() {
                        return this.jsonFile;
                    }

                    @NotNull
                    public final Path component3() {
                        return this.htmlFile;
                    }

                    @NotNull
                    public final ExistingDiagnostic copy(@NotNull LocalDateTime timestamp, @NotNull Path jsonFile, @NotNull Path htmlFile) {
                        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
                        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
                        Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
                        return new ExistingDiagnostic(timestamp, jsonFile, htmlFile);
                    }

                    public static /* synthetic */ ExistingDiagnostic copy$default(ExistingDiagnostic existingDiagnostic, LocalDateTime localDateTime, Path path, Path path2, int n, Object object) {
                        if ((n & 1) != 0) {
                            localDateTime = existingDiagnostic.timestamp;
                        }
                        if ((n & 2) != 0) {
                            path = existingDiagnostic.jsonFile;
                        }
                        if ((n & 4) != 0) {
                            path2 = existingDiagnostic.htmlFile;
                        }
                        return existingDiagnostic.copy(localDateTime, path, path2);
                    }

                    @NotNull
                    public String toString() {
                        return "ExistingDiagnostic(timestamp=" + this.timestamp + ", jsonFile=" + this.jsonFile + ", htmlFile=" + this.htmlFile + ")";
                    }

                    public int hashCode() {
                        LocalDateTime localDateTime = this.timestamp;
                        Path path = this.jsonFile;
                        Path path2 = this.htmlFile;
                        return ((localDateTime != null ? ((Object)localDateTime).hashCode() : 0) * 31 + (path != null ? ((Object)path).hashCode() : 0)) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof ExistingDiagnostic)) break block3;
                                ExistingDiagnostic existingDiagnostic = (ExistingDiagnostic)object;
                                if (!Intrinsics.areEqual((Object)this.timestamp, (Object)existingDiagnostic.timestamp) || !Intrinsics.areEqual((Object)this.jsonFile, (Object)existingDiagnostic.jsonFile) || !Intrinsics.areEqual((Object)this.htmlFile, (Object)existingDiagnostic.htmlFile)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                ExistingDiagnostic it = (ExistingDiagnostic)b;
                boolean bl2 = false;
                Comparable comparable = it.getTimestamp();
                it = (ExistingDiagnostic)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                LocalDateTime localDateTime = it.getTimestamp();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)localDateTime);
            }
        }), (int)IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles());
        object = Files.list(indexDiagnosticDirectory);
        boolean bl5 = false;
        bl4 = false;
        Throwable throwable3 = null;
        try {
            void $this$forEach$iv;
            Stream files3 = (Stream)object;
            boolean bl6 = false;
            Stream stream = files3;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"files");
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)cleanupOldDiagnostics.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, Boolean>(survivedDiagnostics){
                final /* synthetic */ List $survivedDiagnostics$inlined;
                {
                    this.$survivedDiagnostics$inlined = list2;
                    super(1);
                }

                public final boolean invoke(Path file2) {
                    boolean bl;
                    block3: {
                        Iterable $this$none$iv = this.$survivedDiagnostics$inlined;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                ExistingDiagnostic diagnostic = (ExistingDiagnostic)element$iv;
                                boolean bl2 = false;
                                if (!(Intrinsics.areEqual((Object)file2, (Object)diagnostic.getHtmlFile()) || Intrinsics.areEqual((Object)file2, (Object)diagnostic.getJsonFile()))) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl7 = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable3);
        }
    }

    public synchronized void dispose() {
        this.isDisposed = true;
    }

    static {
        Companion = new Companion(null);
        diagnosticDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
        Logger logger = Logger.getInstance(IndexDiagnosticDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Index\u2026nosticDumper::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)Companion.jacksonMapper.2.INSTANCE);
        indexingDiagnosticDir$delegate = LazyKt.lazy((Function0)Companion.indexingDiagnosticDir.2.INSTANCE);
    }

    public static final /* synthetic */ void access$dumpProjectIndexingHistoryToLogSubdirectory(IndexDiagnosticDumper $this, ProjectIndexingHistory projectIndexingHistory) {
        $this.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistory);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDiagnosticDateTimeFormatter$cp() {
        return diagnosticDateTimeFormatter;
    }

    @JvmStatic
    @NotNull
    public static final IndexDiagnosticDumper getInstance() {
        return Companion.getInstance();
    }

    private static final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
        return IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters();
    }

    private static final int getIndexingDiagnosticsLimitOfFiles() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
    }

    public static final boolean getShouldDumpPathsOfIndexedFiles() {
        return Companion.getShouldDumpPathsOfIndexedFiles();
    }

    public static final boolean getShouldDumpInUnitTestMode() {
        Companion companion = Companion;
        return shouldDumpInUnitTestMode;
    }

    public static final void setShouldDumpInUnitTestMode(boolean bl) {
        Companion companion = Companion;
        shouldDumpInUnitTestMode = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "Companion", "intellij.platform.lang.impl"})
    public static interface ProjectIndexingHistoryListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onFinishedIndexing(@NotNull ProjectIndexingHistory var1);

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.lang.impl"})
        public static final class Companion {
            @NotNull
            private static final ExtensionPointName<ProjectIndexingHistoryListener> EP_NAME;
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ExtensionPointName<ProjectIndexingHistoryListener> getEP_NAME() {
                return EP_NAME;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.projectIndexingHistoryListener");
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026IndexingHistoryListener\")");
                EP_NAME = extensionPointName;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020)H\u0007J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u00128BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001c8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u001c8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "diagnosticDateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "fileNamePrefix", "", "indexingDiagnosticDir", "Ljava/nio/file/Path;", "getIndexingDiagnosticDir", "()Ljava/nio/file/Path;", "indexingDiagnosticDir$delegate", "Lkotlin/Lazy;", "indexingDiagnosticsLimitOfFiles", "", "getIndexingDiagnosticsLimitOfFiles$annotations", "getIndexingDiagnosticsLimitOfFiles", "()I", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "shouldDumpDiagnosticsForInterruptedUpdaters", "", "getShouldDumpDiagnosticsForInterruptedUpdaters$annotations", "getShouldDumpDiagnosticsForInterruptedUpdaters", "()Z", "shouldDumpInUnitTestMode", "getShouldDumpInUnitTestMode$annotations", "getShouldDumpInUnitTestMode", "setShouldDumpInUnitTestMode", "(Z)V", "shouldDumpPathsOfIndexedFiles", "getShouldDumpPathsOfIndexedFiles$annotations", "getShouldDumpPathsOfIndexedFiles", "getInstance", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "readJsonIndexDiagnostic", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnostic;", "file", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IndexDiagnosticDumper getInstance() {
            boolean $i$f$service = false;
            Class<IndexDiagnosticDumper> serviceClass$iv = IndexDiagnosticDumper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (IndexDiagnosticDumper)object;
        }

        @JvmStatic
        private static /* synthetic */ void getShouldDumpDiagnosticsForInterruptedUpdaters$annotations() {
        }

        private final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
            return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.for.interrupted.index.updaters", (boolean)false);
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsLimitOfFiles$annotations() {
        }

        private final int getIndexingDiagnosticsLimitOfFiles() {
            return SystemProperties.getIntProperty((String)"intellij.indexes.diagnostics.limit.of.files", (int)20);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpPathsOfIndexedFiles$annotations() {
        }

        public final boolean getShouldDumpPathsOfIndexedFiles() {
            return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.paths.of.indexed.files", (boolean)false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpInUnitTestMode$annotations() {
        }

        public final boolean getShouldDumpInUnitTestMode() {
            return shouldDumpInUnitTestMode;
        }

        public final void setShouldDumpInUnitTestMode(boolean bl) {
            shouldDumpInUnitTestMode = bl;
        }

        private final ObjectMapper getJacksonMapper() {
            Lazy lazy = jacksonMapper$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ObjectMapper)lazy.getValue();
        }

        @NotNull
        public final JsonIndexDiagnostic readJsonIndexDiagnostic(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object object = this.getJacksonMapper().readValue(file2.toFile(), JsonIndexDiagnostic.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.readValue(\u2026exDiagnostic::class.java)");
            return (JsonIndexDiagnostic)object;
        }

        @NotNull
        public final Path getIndexingDiagnosticDir() {
            Lazy lazy = indexingDiagnosticDir$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Path)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

