/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.indexing.ID;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001e\u0010\t\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\n\u0012\u001e\u0010\r\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\n\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R)\u0010\r\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R)\u0010\t\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/diagnostic/FileIndexingStatistics;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "indexesProvidedByExtensions", "", "Lcom/intellij/util/indexing/ID;", "wasFullyIndexedByExtensions", "", "perIndexerUpdateTimes", "", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "perIndexerDeleteTimes", "(Lcom/intellij/openapi/fileTypes/FileType;Ljava/util/Set;ZLjava/util/Map;Ljava/util/Map;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getIndexesProvidedByExtensions", "()Ljava/util/Set;", "indexingTime", "getIndexingTime", "()J", "getPerIndexerDeleteTimes", "()Ljava/util/Map;", "getPerIndexerUpdateTimes", "getWasFullyIndexedByExtensions", "()Z", "intellij.platform.lang.impl"})
public final class FileIndexingStatistics {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Set<ID<?, ?>> indexesProvidedByExtensions;
    private final boolean wasFullyIndexedByExtensions;
    @NotNull
    private final Map<ID<?, ?>, Long> perIndexerUpdateTimes;
    @NotNull
    private final Map<ID<?, ?>, Long> perIndexerDeleteTimes;

    public final long getIndexingTime() {
        return CollectionsKt.sumOfLong((Iterable)this.perIndexerUpdateTimes.values()) + CollectionsKt.sumOfLong((Iterable)this.perIndexerDeleteTimes.values());
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final Set<ID<?, ?>> getIndexesProvidedByExtensions() {
        return this.indexesProvidedByExtensions;
    }

    public final boolean getWasFullyIndexedByExtensions() {
        return this.wasFullyIndexedByExtensions;
    }

    @NotNull
    public final Map<ID<?, ?>, Long> getPerIndexerUpdateTimes() {
        return this.perIndexerUpdateTimes;
    }

    @NotNull
    public final Map<ID<?, ?>, Long> getPerIndexerDeleteTimes() {
        return this.perIndexerDeleteTimes;
    }

    public FileIndexingStatistics(@NotNull FileType fileType, @NotNull Set<? extends ID<?, ?>> indexesProvidedByExtensions, boolean wasFullyIndexedByExtensions, @NotNull Map<ID<?, ?>, Long> perIndexerUpdateTimes, @NotNull Map<ID<?, ?>, Long> perIndexerDeleteTimes) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(indexesProvidedByExtensions, (String)"indexesProvidedByExtensions");
        Intrinsics.checkNotNullParameter(perIndexerUpdateTimes, (String)"perIndexerUpdateTimes");
        Intrinsics.checkNotNullParameter(perIndexerDeleteTimes, (String)"perIndexerDeleteTimes");
        this.fileType = fileType;
        this.indexesProvidedByExtensions = indexesProvidedByExtensions;
        this.wasFullyIndexedByExtensions = wasFullyIndexedByExtensions;
        this.perIndexerUpdateTimes = perIndexerUpdateTimes;
        this.perIndexerDeleteTimes = perIndexerDeleteTimes;
    }
}

