/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    @VisibleForTesting
    public static volatile TestMode ourTestMode;
    public static final ExecutorService GLOBAL_INDEXING_EXECUTOR;
    private static final int MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING;
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED;
    @NotNull
    private static final Key<UnindexedFilesUpdater> RUNNING_TASK;
    private static final Object ourLastRunningTaskLock;
    private final FileBasedIndexImpl myIndex;
    private final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myRunExtensionsForFilesMarkedAsIndexed;
    private final PushedFilePropertiesUpdater myPusher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnindexedFilesUpdater(@NotNull Project project, boolean startSuspended, boolean runExtensionsForFilesMarkedAsIndexed) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        super((Object)project);
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project;
        this.myStartSuspended = startSuspended;
        this.myRunExtensionsForFilesMarkedAsIndexed = runExtensionsForFilesMarkedAsIndexed;
        this.myPusher = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
        this.myProject.putUserData(CONTENT_SCANNED, null);
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater runningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (runningTask != null) {
                DumbService.getInstance((Project)project).cancelTask((DumbModeTask)runningTask);
            }
            this.myProject.putUserData(RUNNING_TASK, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater lastRunningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (lastRunningTask == this) {
                this.myProject.putUserData(RUNNING_TASK, null);
            }
        }
    }

    public UnindexedFilesUpdater(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this(project, false, !UnindexedFilesUpdater.isProjectContentFullyScanned(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnindexedFiles(@NotNull ProjectIndexingHistory projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        int totalFiles;
        Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles;
        List<IndexableFilesIterator> orderedProviders;
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(3);
        }
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        LOG.info("Started");
        ProgressSuspender suspender = ProgressSuspender.getSuspender(indicator);
        if (suspender != null) {
            this.listenToProgressSuspenderForSuspendedTimeDiagnostic(suspender, projectIndexingHistory);
        }
        if (this.myStartSuspended) {
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        indicator.setIndeterminate(true);
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Instant pushPropertiesStart = Instant.now();
        try {
            this.myPusher.pushAllPropertiesNow();
        }
        finally {
            projectIndexingHistory.getTimes().setPushPropertiesDuration(Duration.between(pushPropertiesStart, Instant.now()));
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Pushing properties"));
        this.myIndex.clearIndicesIfNecessary();
        snapshot = PerformanceWatcher.takeSnapshot();
        Instant scanFilesStart = Instant.now();
        try {
            orderedProviders = this.getOrderedProviders();
            providerToFiles = this.collectIndexableFilesConcurrently(this.myProject, indicator, orderedProviders, projectIndexingHistory);
            this.myProject.putUserData(CONTENT_SCANNED, (Object)true);
        }
        finally {
            projectIndexingHistory.getTimes().setScanFilesDuration(Duration.between(scanFilesStart, Instant.now()));
        }
        String scanningCompletedMessage = UnindexedFilesUpdater.getLogScanningCompletedStageMessage(projectIndexingHistory);
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage(scanningCompletedMessage));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleInitialVfsRefresh();
        }
        if ((totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum()) == 0) {
            LOG.info("Finish. No files to index with loading content.");
            return;
        }
        if (SystemProperties.getBooleanProperty((String)"idea.indexes.pretendNoFiles", (boolean)false)) {
            LOG.info("Finish. System property 'idea.indexes.pretendNoFiles' is enabled.");
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator, UnindexedFilesUpdater.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.myIndex.resetSnapshotInputMappingStatistics();
        Instant startIndexing = Instant.now();
        try {
            this.indexFiles(orderedProviders, providerToFiles, projectIndexingHistory, poweredIndicator);
        }
        finally {
            projectIndexingHistory.getTimes().setIndexingDuration(Duration.between(startIndexing, Instant.now()));
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Finished. Unindexed files update"));
        List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics = this.myIndex.dumpSnapshotInputMappingStatistics();
        projectIndexingHistory.addSnapshotInputMappingStatistics(snapshotInputMappingsStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFiles(@NotNull List<IndexableFilesIterator> orderedProviders, @NotNull Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles, @NotNull ProjectIndexingHistory projectIndexingHistory, @NotNull ProgressIndicator progressIndicator) {
        if (orderedProviders == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(4);
        }
        if (providerToFiles == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(5);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(6);
        }
        if (progressIndicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(7);
        }
        int totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum();
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(progressIndicator, totalFiles);
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Use " + numberOfIndexingThreads + " indexing " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads));
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
        int index2 = 0;
        while (index2 < orderedProviders.size()) {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            String indexingProgressText = "";
            StringBuilder providerDebugName = new StringBuilder();
            while (files2.size() < MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING && index2 < orderedProviders.size()) {
                IndexableFilesIterator provider2 = orderedProviders.get(index2++);
                List providerFiles = providerToFiles.getOrDefault(provider2, Collections.emptyList());
                files2.addAll(providerFiles);
                indexingProgressText = provider2.getIndexingProgressText();
                if (providerDebugName.length() > 0) {
                    providerDebugName.append(", ");
                }
                providerDebugName.append(provider2.getDebugName());
            }
            concurrentTasksProgressManager.setText(indexingProgressText);
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(files2.size());
            try {
                IndexingJobStatistics statistics;
                IndexUpdateRunner.IndexingInterruptedException exception = null;
                try {
                    statistics = indexUpdateRunner.indexFiles(this.myProject, providerDebugName.toString(), files2, subTaskIndicator);
                }
                catch (IndexUpdateRunner.IndexingInterruptedException e) {
                    exception = e;
                    statistics = e.myStatistics;
                }
                try {
                    projectIndexingHistory.addProviderStatistics(statistics);
                }
                catch (Exception e) {
                    LOG.error("Failed to add indexing statistics for " + providerDebugName, (Throwable)e);
                }
                if (exception == null) continue;
                ExceptionUtil.rethrow((Throwable)exception.getCause());
            }
            finally {
                subTaskIndicator.finished();
            }
        }
    }

    @NotNull
    private static String getLogScanningCompletedStageMessage(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(8);
        }
        ArrayList<JsonScanningStatistics> statistics = projectIndexingHistory.getScanningStatistics();
        int numberOfScannedFiles = statistics.stream().mapToInt(s -> s.getNumberOfScannedFiles()).sum();
        int numberOfFilesForIndexing = statistics.stream().mapToInt(s -> s.getNumberOfFilesForIndexing()).sum();
        String string = "Scanning completed. Number of scanned files: " + numberOfScannedFiles + "; Number of files for indexing: " + numberOfFilesForIndexing;
        if (string == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void listenToProgressSuspenderForSuspendedTimeDiagnostic(final @NotNull ProgressSuspender suspender, final @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (suspender == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(10);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(11);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){
            private volatile Instant suspensionStart = null;

            @Override
            public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
                if (changedSuspender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (suspender == changedSuspender) {
                    if (suspender.isSuspended()) {
                        this.suspensionStart = Instant.now();
                    } else {
                        Instant now = Instant.now();
                        Instant start2 = this.suspensionStart;
                        this.suspensionStart = null;
                        if (start2 != null && start2.compareTo(now) < 0) {
                            Duration thisDuration = Duration.between(start2, now);
                            Duration currentTotalDuration = projectIndexingHistory.getTimes().getSuspendedDuration();
                            Duration newTotalSuspendedDuration = currentTotalDuration.plus(thisDuration);
                            projectIndexingHistory.getTimes().setSuspendedDuration(newTotalSuspendedDuration);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedSuspender", "com/intellij/util/indexing/UnindexedFilesUpdater$1", "suspendedStatusChanged"));
            }
        });
    }

    static boolean isProjectContentFullyScanned(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(12);
        }
        return Boolean.TRUE.equals(project.getUserData(CONTENT_SCANNED));
    }

    @NotNull
    private List<IndexableFilesIterator> getOrderedProviders() {
        List<IndexableFilesIterator> originalOrderedProviders = this.myIndex.getOrderedIndexableFilesProviders(this.myProject);
        ArrayList<IndexableFilesIterator> orderedProviders = new ArrayList<IndexableFilesIterator>();
        originalOrderedProviders.stream().filter(p -> !(p.getOrigin() instanceof SdkOrigin)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p.getOrigin() instanceof SdkOrigin).collect(Collectors.toCollection(() -> orderedProviders));
        ArrayList<IndexableFilesIterator> arrayList = orderedProviders;
        if (arrayList == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<IndexableFilesIterator, List<VirtualFile>> collectIndexableFilesConcurrently(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull List<IndexableFilesIterator> providers, @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(15);
        }
        if (providers == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(16);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(17);
        }
        if (providers.isEmpty()) {
            Map<IndexableFilesIterator, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                UnindexedFilesUpdater.$$$reportNull$$$0(18);
            }
            return map2;
        }
        List sessions = ContainerUtil.map((Collection)IndexableFileScanner.EP_NAME.getExtensionList(), scanner -> scanner.startSession(project));
        UnindexedFilesFinder unindexedFileFinder = new UnindexedFilesFinder(project, this.myIndex, this.myRunExtensionsForFilesMarkedAsIndexed);
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> providerToFiles = new IdentityHashMap<IndexableFilesIterator, List<VirtualFile>>();
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator, providers.size());
        Ref allTasksFinished = Ref.create((Object)false);
        List tasks = ContainerUtil.map(providers, provider2 -> {
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ArrayList files2 = new ArrayList();
            ScanningStatistics scanningStatistics = new ScanningStatistics(provider2.getDebugName());
            providerToFiles.put((IndexableFilesIterator)provider2, files2);
            @NotNull List fileScannerVisitors = ContainerUtil.mapNotNull((Collection)sessions, s -> s.createVisitor(provider2.getOrigin()));
            IndexableFilesDeduplicateFilter thisProviderDeduplicateFilter = IndexableFilesDeduplicateFilter.createDelegatingTo((IndexableFilesDeduplicateFilter)indexableFilesDeduplicateFilter);
            ContentIterator collectingIterator = fileOrDir -> {
                UnindexedFileStatus status;
                if (subTaskIndicator.isCanceled()) {
                    return false;
                }
                PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, fileScannerVisitors);
                long statusTime = System.nanoTime();
                try {
                    status = ourTestMode == TestMode.PUSHING ? null : unindexedFileFinder.getFileStatus(fileOrDir);
                }
                finally {
                    statusTime = System.nanoTime() - statusTime;
                }
                if (status != null) {
                    if (status.getShouldIndex() && ourTestMode == null) {
                        files2.add(fileOrDir);
                    }
                    scanningStatistics.addStatus(fileOrDir, status, statusTime, project);
                }
                return true;
            };
            return () -> {
                subTaskIndicator.setText(provider2.getRootsScanningProgressText());
                try {
                    provider2.iterateFiles(project, collectingIterator, (VirtualFileFilter)thisProviderDeduplicateFilter);
                }
                finally {
                    scanningStatistics.setNumberOfSkippedFiles(thisProviderDeduplicateFilter.getNumberOfSkippedFiles());
                    Ref ref = allTasksFinished;
                    synchronized (ref) {
                        if (!((Boolean)allTasksFinished.get()).booleanValue()) {
                            projectIndexingHistory.addScanningStatistics(scanningStatistics);
                        }
                    }
                    subTaskIndicator.finished();
                }
            };
        });
        LOG.info("Scanning: use " + UnindexedFilesUpdater.getNumberOfScanningThreads() + " scanning threads");
        try {
            PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        }
        finally {
            Ref ref = allTasksFinished;
            synchronized (ref) {
                allTasksFinished.set((Object)true);
            }
        }
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> identityHashMap = providerToFiles;
        if (identityHashMap == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(19);
        }
        return identityHashMap;
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesUpdater$2", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue((String)"indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(20);
        }
        ProjectIndexingHistory projectIndexingHistory = new ProjectIndexingHistory(this.myProject);
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(projectIndexingHistory, indicator);
        }
        catch (Throwable e) {
            projectIndexingHistory.getTimes().setWasInterrupted(true);
            if (e instanceof ControlFlowException) {
                LOG.info("Cancelled");
            }
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
            projectIndexingHistory.getTimes().setUpdatingEnd(ZonedDateTime.now(ZoneOffset.UTC));
            IndexDiagnosticDumper.getInstance().dumpProjectIndexingHistoryIfNecessary(projectIndexingHistory);
        }
    }

    public static int getNumberOfIndexingThreads() {
        int threadCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadCount = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, 4));
        }
        return threadCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadCount = Registry.intValue((String)"caches.indexerThreadsCount");
        return threadCount <= 0 ? 4 : threadCount;
    }

    public static int getNumberOfScanningThreads() {
        int scanningThreadCount = Registry.intValue((String)"caches.scanningThreadsCount");
        if (scanningThreadCount > 0) {
            return scanningThreadCount;
        }
        int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
        return Math.max(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, UnindexedFilesUpdater.getNumberOfIndexingThreads());
    }

    static {
        GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        MINIMUM_NUMBER_OF_FILES_TO_RUN_CONCURRENT_INDEXING = SystemProperties.getIntProperty((String)"intellij.indexing.minimum.number.of.files.to.run.concurrent.indexing", (int)100);
        CONTENT_SCANNED = Key.create((String)"CONTENT_SCANNED");
        RUNNING_TASK = Key.create((String)"RUNNING_INDEX_UPDATER_TASK");
        ourLastRunningTaskLock = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedProviders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspender";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedProviders";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIndexableFilesConcurrently";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateUnindexedFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listenToProgressSuspenderForSuspendedTimeDiagnostic";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isProjectContentFullyScanned";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectIndexableFilesConcurrently";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TestMode {
        PUSHING,
        PUSHING_AND_SCANNING;

    }
}

