/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;

final class ProjectFilesCondition
implements Condition<VirtualFile> {
    private static final int MAX_FILES_TO_UPDATE_FROM_OTHER_PROJECT = 2;
    private final VirtualFile myRestrictedTo;
    private final GlobalSearchScope myFilter;
    private int myFilesFromOtherProjects;
    private final ProjectIndexableFilesFilter myIndexableFilesFilter;

    ProjectFilesCondition(ProjectIndexableFilesFilter indexableFilesFilter, GlobalSearchScope filter, VirtualFile restrictedTo, boolean includeFilesFromOtherProjects) {
        this.myRestrictedTo = restrictedTo;
        this.myFilter = filter;
        this.myIndexableFilesFilter = indexableFilesFilter;
        if (!includeFilesFromOtherProjects) {
            this.myFilesFromOtherProjects = 2;
        }
    }

    public boolean value(VirtualFile file2) {
        int fileId = ((VirtualFileWithId)file2).getId();
        if (this.myIndexableFilesFilter != null && !(file2 instanceof DeletedVirtualFileStub) && !this.myIndexableFilesFilter.containsFileId(fileId)) {
            if (this.myFilesFromOtherProjects >= 2) {
                return false;
            }
            ++this.myFilesFromOtherProjects;
            return true;
        }
        if (file2 instanceof DeletedVirtualFileStub) {
            return true;
        }
        if (FileBasedIndexImpl.belongsToScope(file2, this.myRestrictedTo, this.myFilter)) {
            return true;
        }
        if (this.myFilesFromOtherProjects < 2) {
            ++this.myFilesFromOtherProjects;
            return true;
        }
        return false;
    }
}

