/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class PersistentIndicesConfiguration {
    private static final int BASE_INDICES_CONFIGURATION_VERSION = 1;

    PersistentIndicesConfiguration() {
    }

    static void saveConfiguration() {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(PersistentIndicesConfiguration.indicesConfigurationFile(), new OpenOption[0])));){
            DataInputOutputUtil.writeINT((DataOutput)out, (int)1);
            IndexVersion.savePersistentIndexStamp(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void loadConfiguration() {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(PersistentIndicesConfiguration.indicesConfigurationFile(), new OpenOption[0])));){
            if (DataInputOutputUtil.readINT((DataInput)in) == 1) {
                IndexVersion.initPersistentIndexStamp(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path indicesConfigurationFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.config");
        if (path == null) {
            PersistentIndicesConfiguration.$$$reportNull$$$0(0);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/PersistentIndicesConfiguration", "indicesConfigurationFile"));
    }
}

