/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\b&\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\r\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0010H$J\u001a\u0010\u0011\u001a\u00020\u00072\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/IndexDataInitializer;", "T", "Ljava/util/concurrent/Callable;", "()V", "call", "()Ljava/lang/Object;", "executeTask", "", "callable", "Lcom/intellij/util/ThrowableRunnable;", "finish", "getInitializationFinishedMessage", "", "initializationResult", "(Ljava/lang/Object;)Ljava/lang/String;", "prepareTasks", "", "runParallelTasks", "tasks", "Companion", "intellij.platform.lang.impl"})
public abstract class IndexDataInitializer<T>
implements Callable<T> {
    private static final Logger LOG;
    private static final boolean ourDoParallelIndicesInitialization;
    @JvmField
    public static final boolean ourDoAsyncIndicesInitialization;
    private static final ExecutorService ourGenesisExecutor;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public T call() {
        T t;
        Logger logger = Logger.getInstance((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass.name)");
        Logger log = logger;
        Instant started = Instant.now();
        try {
            Collection<ThrowableRunnable<?>> tasks = this.prepareTasks();
            this.runParallelTasks(tasks);
            T result2 = this.finish();
            String message2 = this.getInitializationFinishedMessage(result2);
            log.info("Index data initialization done: " + Duration.between(started, Instant.now()).toMillis() + " ms. " + message2);
            t = result2;
        }
        catch (Throwable t2) {
            log.error("Index data initialization failed", t2);
            throw t2;
        }
        return t;
    }

    @NotNull
    protected abstract String getInitializationFinishedMessage(T var1);

    protected abstract T finish();

    @NotNull
    protected abstract Collection<ThrowableRunnable<?>> prepareTasks();

    /*
     * WARNING - void declaration
     */
    private final void runParallelTasks(Collection<? extends ThrowableRunnable<?>> tasks) throws InterruptedException {
        if (tasks.isEmpty()) {
            return;
        }
        if (ourDoParallelIndicesInitialization) {
            void $this$mapTo$iv$iv;
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Index Instantiation Pool", (Executor)AppExecutorUtil.getAppExecutorService(), (int)UnindexedFilesUpdater.getNumberOfIndexingThreads());
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026umberOfIndexingThreads())");
            ExecutorService taskExecutor = executorService;
            Iterable $this$map$iv = tasks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ThrowableRunnable throwableRunnable = (ThrowableRunnable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Future<?> future2 = taskExecutor.submit(new Runnable((ThrowableRunnable)it, this, taskExecutor){
                    final /* synthetic */ ThrowableRunnable $it;
                    final /* synthetic */ IndexDataInitializer this$0;
                    final /* synthetic */ ExecutorService $taskExecutor$inlined;
                    {
                        this.$it = throwableRunnable;
                        this.this$0 = indexDataInitializer;
                        this.$taskExecutor$inlined = executorService;
                    }

                    public final void run() {
                        IndexDataInitializer.access$executeTask(this.this$0, this.$it);
                    }
                });
                collection.add(future2);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future it = (Future)element$iv;
                boolean bl = false;
                try {
                    Future future3 = it;
                    Intrinsics.checkNotNull((Object)future3);
                    future3.get();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            taskExecutor.shutdown();
        } else {
            for (ThrowableRunnable<?> callable : tasks) {
                this.executeTask(callable);
            }
        }
    }

    private final void executeTask(ThrowableRunnable<?> callable) {
        Application app = ApplicationManager.getApplication();
        try {
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDisposed()) {
                return;
            }
            callable.run();
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(IndexDataInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Index\u2026aInitializer::class.java)");
        LOG = logger;
        ourDoParallelIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.parallel.indices.initialization", (boolean)true);
        ourDoAsyncIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.async.indices.initialization", (boolean)true);
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Index Data Initializer Pool");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor\n \u2026x Data Initializer Pool\")");
        ourGenesisExecutor = executorService;
    }

    public static final /* synthetic */ void access$executeTask(IndexDataInitializer $this, ThrowableRunnable callable) {
        $this.executeTask(callable);
    }

    @JvmStatic
    @NotNull
    public static final <T> Future<T> submitGenesisTask(@NotNull Callable<T> action2) {
        return Companion.submitGenesisTask(action2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0001\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/IndexDataInitializer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ourDoAsyncIndicesInitialization", "", "ourDoParallelIndicesInitialization", "ourGenesisExecutor", "Ljava/util/concurrent/ExecutorService;", "submitGenesisTask", "Ljava/util/concurrent/Future;", "T", "action", "Ljava/util/concurrent/Callable;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> Future<T> submitGenesisTask(@NotNull Callable<T> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            Future<T> future2 = ourGenesisExecutor.submit(action2);
            Intrinsics.checkNotNullExpressionValue(future2, (String)"ourGenesisExecutor.submit(action)");
            return future2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

