/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileBasedIndexSwitcher {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexSwitcher.class);
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final Semaphore myDumbModeSemaphore;
    private int myNestedLevelCount;

    @TestOnly
    public FileBasedIndexSwitcher() {
        this((FileBasedIndexImpl)FileBasedIndex.getInstance());
    }

    public FileBasedIndexSwitcher(@NotNull FileBasedIndexImpl index2) {
        if (index2 == null) {
            FileBasedIndexSwitcher.$$$reportNull$$$0(0);
        }
        this.myDumbModeSemaphore = new Semaphore();
        this.myNestedLevelCount = 0;
        this.myFileBasedIndex = index2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app.isDispatchThread());
        LOG.assertTrue(!app.isWriteAccessAllowed());
        try {
            if (this.myNestedLevelCount == 0) {
                boolean unitTestMode = app.isUnitTestMode();
                if (!unitTestMode) {
                    boolean wasUp = this.myDumbModeSemaphore.isUp();
                    this.myDumbModeSemaphore.down();
                    if (wasUp) {
                        for (Project project : ProjectUtil.getOpenProjects()) {
                            DumbService dumbService = DumbService.getInstance((Project)project);
                            dumbService.cancelAllTasksAndWait();
                            dumbService.queueTask(new DumbModeTask(this.myDumbModeSemaphore){

                                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                                    if (indicator == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    indicator.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                                    FileBasedIndexSwitcher.this.myDumbModeSemaphore.waitFor();
                                }

                                public String toString() {
                                    return "Plugin loading/unloading";
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexSwitcher$1", "performInDumbMode"));
                                }
                            });
                        }
                    }
                }
                this.myFileBasedIndex.waitUntilIndicesAreInitialized();
                this.myFileBasedIndex.performShutdown(true);
                this.myFileBasedIndex.dropRegisteredIndexes();
                IndexingStamp.dropTimestampMemoryCaches();
            }
        }
        finally {
            ++this.myNestedLevelCount;
        }
    }

    public void turnOn() {
        this.turnOn(null);
    }

    public void turnOn(@Nullable Runnable beforeIndexTasksStarted) {
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        --this.myNestedLevelCount;
        if (this.myNestedLevelCount == 0) {
            RebuildStatus.reset();
            this.myFileBasedIndex.loadIndexes();
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (unitTestMode) {
                this.myFileBasedIndex.waitUntilIndicesAreInitialized();
            }
            if (!unitTestMode) {
                this.myDumbModeSemaphore.up();
            }
            if (beforeIndexTasksStarted != null) {
                beforeIndexTasksStarted.run();
            }
            IndexingFlag.cleanupProcessedFlag();
            for (Project project : ProjectUtil.getOpenProjects()) {
                DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/indexing/FileBasedIndexSwitcher", "<init>"));
    }
}

