/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.intellij.AppTopics;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartFMap;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.AuthenticContent;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DocumentContent;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexFileTypeListener;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableFilesFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.PsiContent;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.StaleIndexesChecker;
import com.intellij.util.indexing.StorageBufferingHandler;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.events.ChangedFilesCollector;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;
import com.intellij.util.indexing.events.IndexedFilesListener;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.snapshot.SnapshotHashEnumeratorService;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingException;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.SimpleMessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileBasedIndexImpl
extends FileBasedIndexEx {
    private static final ThreadLocal<VirtualFile> ourIndexedFile = new ThreadLocal();
    private static final ThreadLocal<VirtualFile> ourFileToBeIndexed = new ThreadLocal();
    public static final Logger LOG = Logger.getInstance(FileBasedIndexImpl.class);
    private volatile RegisteredIndexes myRegisteredIndexes;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    private final NotNullLazyValue<ChangedFilesCollector> myChangedFilesCollector = NotNullLazyValue.createValue(() -> (ChangedFilesCollector)AsyncEventSupport.EP_NAME.findExtensionOrFail(ChangedFilesCollector.class));
    private final List<IndexableFileSet> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap = new HashMap<IndexableFileSet, Project>();
    private final SimpleMessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    private final boolean myIsUnitTestMode;
    @Nullable
    private Runnable myShutDownTask;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private final AtomicInteger myLocalModCount = new AtomicInteger();
    private final AtomicInteger myFilesModCount = new AtomicInteger();
    private final Set<Project> myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
    private final IntSet myStaleIds = new IntOpenHashSet();
    private final Lock myReadLock;
    public final Lock myWriteLock;
    private final ThreadLocal<Boolean> myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock = new ReentrantLock();
    private static final Key<WeakReference<Pair<FileContentImpl, Long>>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageBufferingHandler myStorageBufferingHandler = new StorageBufferingHandler(){

        @Override
        @NotNull
        protected Stream<UpdatableIndex<?, ?, ?>> getIndexes() {
            IndexConfiguration state = FileBasedIndexImpl.this.getState();
            Stream<UpdatableIndex<?, ?, ?>> stream = state.getIndexIDs().stream().map(id2 -> FileBasedIndexImpl.this.getIndex(id2));
            if (stream == null) {
                6.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$6", "getIndexes"));
        }
    };
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    private volatile long myLastOtherProjectInclusionStamp;
    public static final boolean DO_TRACE_STUB_INDEX_UPDATE = SystemProperties.getBooleanProperty((String)"idea.trace.stub.index.update", (boolean)false);

    private IndexConfiguration getState() {
        return this.myRegisteredIndexes.getConfigurationState();
    }

    void dropRegisteredIndexes() {
        ScheduledFuture<?> flushingFuture = this.myFlushingFuture;
        LOG.assertTrue(flushingFuture == null || flushingFuture.isCancelled() || flushingFuture.isDone());
        LOG.assertTrue(this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty());
        LOG.assertTrue(this.myProjectsBeingUpdated.isEmpty());
        LOG.assertTrue(!this.getChangedFilesCollector().isUpdateInProgress());
        LOG.assertTrue(this.myTransactionMap.isEmpty());
        this.myRegisteredIndexes = null;
    }

    public FileBasedIndexImpl() {
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        this.myReadLock = lock2.readLock();
        this.myWriteLock = lock2.writeLock();
        this.myFileDocumentManager = FileDocumentManager.getInstance();
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileBasedIndexFileTypeListener());
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                if (FileBasedIndexImpl.this.myRegisteredIndexes != null && !FileBasedIndexImpl.this.myRegisteredIndexes.areIndexesReady()) {
                    new Task.Modal(null, IndexingBundle.message((String)"indexes.preparing.to.shutdown.message", (Object[])new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            FileBasedIndexImpl.this.myRegisteredIndexes.waitUntilAllIndicesAreInitialized();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexImpl$3$1", "run"));
                        }
                    }.queue();
                }
            }
        });
        this.myConnection = connection;
        FileBasedIndexExtension.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<FileBasedIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull FileBasedIndexExtension<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension2.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    void scheduleFullIndexesRescan(@NotNull Collection<ID<?, ?>> indexesToRebuild, @NotNull String reason) {
        if (indexesToRebuild == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(0);
        }
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(1);
        }
        IndexingFlag.cleanupProcessedFlag();
        this.doClearIndices(id2 -> indexesToRebuild.contains(id2));
        FileBasedIndexImpl.scheduleIndexRebuild(reason);
    }

    @VisibleForTesting
    void doClearIndices(@NotNull Predicate<? super ID<?, ?>> filter) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(2);
        }
        try {
            this.waitUntilIndicesAreInitialized();
        }
        catch (ProcessCanceledException e) {
            return;
        }
        IndexingStamp.flushCaches();
        ArrayList clearedIndexes = new ArrayList();
        ArrayList survivedIndexes = new ArrayList();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            if (filter.test(indexId)) {
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                clearedIndexes.add(indexId);
                continue;
            }
            survivedIndexes.add(indexId);
        }
        LOG.info("indexes cleared: " + clearedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")) + "\nsurvived indexes: " + survivedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")));
    }

    public void registerProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(3);
        }
        for (final IndexableFilesContributor extension2 : (IndexableFilesContributor[])IndexableFilesContributor.EP_NAME.getExtensions()) {
            final Predicate contributorsPredicate = extension2.getOwnFilePredicate(project);
            this.registerIndexableSet(new IndexableFileSet(){

                @Override
                public boolean isInSet(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return contributorsPredicate.test(file2);
                }

                public String toString() {
                    return "IndexableFileSet[" + extension2 + "]";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$5", "isInSet"));
                }
            }, project);
        }
    }

    public void removeProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(4);
        }
        HashSet<IndexableFileSet> toRemove2 = new HashSet<IndexableFileSet>();
        for (Map.Entry<IndexableFileSet, Project> entry : this.myIndexableSetToProjectMap.entrySet()) {
            if (!entry.getValue().equals(project)) continue;
            toRemove2.add(entry.getKey());
        }
        for (IndexableFileSet set2 : toRemove2) {
            this.myIndexableSets.remove(set2);
            this.myIndexableSetToProjectMap.remove(set2);
        }
    }

    boolean processChangedFiles(@NotNull Project project, @NotNull Processor<? super VirtualFile> processor2) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(6);
        }
        Iterator iterator2 = Iterators.concat(this.getChangedFilesCollector().getEventMerger().getChangedFiles().iterator(), this.getChangedFilesCollector().getFilesToUpdate().iterator());
        HashSet<VirtualFile> checkedFiles = new HashSet<VirtualFile>();
        Predicate<VirtualFile> filterPredicate = this.filesToBeIndexedForProjectCondition(project);
        while (iterator2.hasNext()) {
            VirtualFile virtualFile = (VirtualFile)iterator2.next();
            if (!filterPredicate.test(virtualFile) || checkedFiles.contains(virtualFile)) continue;
            checkedFiles.add(virtualFile);
            if (processor2.process((Object)virtualFile)) continue;
            return false;
        }
        return true;
    }

    public RegisteredIndexes getRegisteredIndexes() {
        return this.myRegisteredIndexes;
    }

    void setUpShutDownTask() {
        this.myShutDownTask = new MyShutDownTask();
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutDownTask);
    }

    @ApiStatus.Internal
    public void resetSnapshotInputMappingStatistics() {
        for (ID<?, ?> id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(id2);
            if (!(index2 instanceof VfsAwareMapReduceIndex)) continue;
            ((VfsAwareMapReduceIndex)index2).resetSnapshotInputMappingsStatistics();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public List<SnapshotInputMappingsStatistics> dumpSnapshotInputMappingStatistics() {
        List<SnapshotInputMappingsStatistics> list2 = this.getRegisteredIndexes().getState().getIndexIDs().stream().map(id2 -> {
            UpdatableIndex index2 = this.getIndex((ID)id2);
            if (index2 instanceof VfsAwareMapReduceIndex) {
                return ((VfsAwareMapReduceIndex)index2).dumpSnapshotInputMappingsStatistics();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStaleIds(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(8);
        }
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            this.myStaleIds.addAll((IntCollection)staleIds);
        }
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(9);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file2, (Object)restrictedTo) || filter != null && restrictedTo == null && !filter.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(10);
        }
        this.requestReindex(file2, true);
    }

    @ApiStatus.Internal
    public void requestReindex(@NotNull VirtualFile file2, boolean forceRebuild) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(11);
        }
        GistManager.getInstance().invalidateData(file2);
        IndexedFilesListener.InvalidationCause cause = forceRebuild ? IndexedFilesListener.InvalidationCause.FORCE_REBUILD : IndexedFilesListener.InvalidationCause.CHANGED;
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        changedFilesCollector.invalidateIndicesRecursively(file2, cause, changedFilesCollector.getEventMerger());
        if (this.myRegisteredIndexes.isInitialized()) {
            changedFilesCollector.ensureUpToDateAsync();
        }
    }

    public synchronized void loadIndexes() {
        if (this.myRegisteredIndexes == null) {
            LOG.assertTrue(this.myRegisteredIndexes == null);
            this.myStorageBufferingHandler.resetState();
            this.myRegisteredIndexes = new RegisteredIndexes(this.myFileDocumentManager, this);
        }
    }

    @Override
    public void waitUntilIndicesAreInitialized() {
        if (this.myRegisteredIndexes == null) {
            throw new ServiceNotReadyException();
        }
        this.myRegisteredIndexes.waitUntilIndicesAreInitialized();
    }

    static <K, V> void registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink versionRegistrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(13);
        }
        if (versionRegistrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(14);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(15);
        }
        ID name = extension2.getName();
        int version2 = FileBasedIndexImpl.getIndexExtensionVersion(extension2);
        Path versionFile = IndexInfrastructure.getVersionFile(name);
        IndexVersion.IndexVersionDiff diff = IndexVersion.versionDiffers(name, version2);
        versionRegistrationStatusSink.setIndexVersionDiff(name, diff);
        if (diff != IndexVersion.IndexVersionDiff.UP_TO_DATE) {
            boolean versionFileExisted = Files.exists(versionFile, new LinkOption[0]);
            if (extension2.hasSnapshotMapping() && versionFileExisted) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name).toFile());
            }
            Path rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir.toFile());
            }
            IndexVersion.rewriteVersion(name, version2);
            try {
                if (versionFileExisted) {
                    for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                        ex.onFileBasedIndexVersionChanged(name);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        FileBasedIndexImpl.initIndexStorage(extension2, version2, state, versionRegistrationStatusSink, staleInputIdSink);
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension2, int version2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink registrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        HashSet addedTypes;
        FileBasedIndex.InputFilter inputFilter;
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(16);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(17);
        }
        if (registrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(18);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(19);
        }
        ID name = extension2.getName();
        boolean contentHashesEnumeratorOk = true;
        try {
            inputFilter = extension2.getInputFilter();
            if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                addedTypes = new HashSet();
                ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(type -> {
                    if (type != null) {
                        addedTypes.add(type);
                    }
                });
            } else {
                addedTypes = null;
            }
            if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
                contentHashesEnumeratorOk = SnapshotHashEnumeratorService.getInstance().initialize();
            }
        }
        catch (Exception e) {
            state.registerIndexInitializationProblem(name, e);
            throw e;
        }
        UpdatableIndex<K, V, FileContent> index2 = null;
        int attemptCount = 2;
        for (int attempt = 0; attempt < attemptCount; ++attempt) {
            try {
                VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                index2 = FileBasedIndexImpl.createIndex(extension2, layout);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex<K, V, FileContent> intermediateIndex = infrastructureExtension.combineIndex(extension2, index2);
                    if (intermediateIndex == null) continue;
                    index2 = intermediateIndex;
                }
                state.registerIndex(name, index2, FileBasedIndexImpl.composeInputFilter(inputFilter, file2 -> !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name)), version2 + GlobalIndexFilter.getFiltersVersion(name), addedTypes);
                break;
            }
            catch (Exception e) {
                boolean lastAttempt = attempt == attemptCount - 1;
                try {
                    VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                    layout.clearIndexData();
                }
                catch (Exception layoutEx) {
                    LOG.error((Throwable)layoutEx);
                }
                for (FileBasedIndexInfrastructureExtension ext : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    try {
                        ext.resetPersistentState(name);
                    }
                    catch (Exception extEx) {
                        LOG.error((Throwable)extEx);
                    }
                }
                registrationStatusSink.setIndexVersionDiff(name, new IndexVersion.IndexVersionDiff.CorruptedRebuild(version2));
                IndexVersion.rewriteVersion(name, version2);
                if (lastAttempt) {
                    state.registerIndexInitializationProblem(name, e);
                    throw e;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)e);
                    continue;
                }
                LOG.warn((Throwable)e);
                continue;
            }
        }
        if (StubUpdatingIndex.INDEX_ID.equals((Object)extension2.getName()) && index2 != null) {
            staleInputIdSink.addAll((IntCollection)StaleIndexesChecker.checkIndexForStaleRecords(index2, true));
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull VfsAwareIndexStorageLayout<K, V> layout) throws StorageException, IOException {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(20);
        }
        if (layout == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(21);
        }
        if (extension2 instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex<K, V, FileContent> index2;
            UpdatableIndex<K, V, FileContent> updatableIndex = index2 = ((CustomImplementationFileBasedIndexExtension)extension2).createIndexImplementation(extension2, layout);
            if (updatableIndex == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(22);
            }
            return updatableIndex;
        }
        return new TransientFileContentIndex<K, V>(extension2, layout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performShutdown(boolean keepConnection) {
        RegisteredIndexes registeredIndexes = this.myRegisteredIndexes;
        if (registeredIndexes == null) return;
        if (!registeredIndexes.performShutdown()) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> registeredIndexes.waitUntilAllIndicesAreInitialized());
        try {
            if (this.myShutDownTask != null) {
                ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutDownTask);
            }
            if (this.myFlushingFuture == null) return;
            this.myFlushingFuture.cancel(false);
            this.myFlushingFuture = null;
            return;
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                UpdatableIndex<Integer, SerializedStubTree, FileContent> index2;
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.getChangedFilesCollector().getAllPossibleFilesToUpdate()) {
                    int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
                    try {
                        this.removeDataFromIndicesForFile(fileId, file2);
                    }
                    catch (Throwable throwable) {
                        LOG.error(throwable);
                    }
                }
                this.getChangedFilesCollector().clearFilesToUpdate();
                IndexingStamp.flushCaches();
                if (ApplicationManager.getApplication().isUnitTestMode() && (index2 = this.getState().getIndex(StubUpdatingIndex.INDEX_ID)) != null) {
                    StaleIndexesChecker.checkIndexForStaleRecords(index2, false);
                }
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    try {
                        UpdatableIndex<?, ?, FileContent> index3 = this.getIndex(indexId);
                        if (!RebuildStatus.isOk(indexId)) {
                            index3.clear();
                        }
                        index3.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.shutdown());
                SnapshotHashEnumeratorService.getInstance().close();
                if (!keepConnection) {
                    this.myConnection.disconnect();
                }
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            finally {
                IndexVersion.clearCachedIndexVersions();
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    public void removeDataFromIndicesForFile(int fileId, @Nullable VirtualFile file2) {
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
        if (file2 instanceof VirtualFileSystemEntry && file2.isValid()) {
            IndexingFlag.cleanProcessingFlag(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> affectedIndices, int inputId, @Nullable VirtualFile file2) {
        if (affectedIndices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(23);
        }
        assert (ProgressManager.getInstance().isInNonCancelableSection());
        try {
            this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
            Throwable unexpectedError = null;
            for (ID<?, ?> indexId : affectedIndices) {
                try {
                    this.updateSingleIndex(indexId, null, inputId, null);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (unexpectedError != null) continue;
                    unexpectedError = e;
                }
            }
            if (unexpectedError != null) {
                LOG.error(unexpectedError);
            }
        }
        finally {
            IndexingStamp.flushCache(inputId);
        }
    }

    private void removeTransientFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> indices, int inputId, @Nullable VirtualFile file2) {
        Document document;
        if (indices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(24);
        }
        for (ID<?, ?> indexId : indices) {
            this.getIndex(indexId).removeTransientDataForFile(inputId);
        }
        Document document2 = document = file2 == null ? null : this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index2 = state.getIndex(indexId);
                if (index2 == null) continue;
                index2.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        SnapshotHashEnumeratorService.getInstance().flush();
    }

    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(25);
        }
        return IndexUpToDateCheckIn.disableUpToDateCheckIn(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> boolean ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block17: {
            if (indexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(26);
            }
            ProgressManager.checkCanceled();
            SlowOperations.assertSlowOperationsAreAllowed();
            this.getChangedFilesCollector().ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            NoAccessDuringPsiEvents.checkCallContext(indexId);
            if (!this.needsFileContentLoading(indexId)) {
                return true;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE) {
                return false;
            }
            if (project == null) {
                LOG.warn("Please provide a GlobalSearchScope with specified project. Otherwise it might lead to performance problems!", (Throwable)new Exception());
            }
            if (ActionUtil.isDumbMode((Project)project) && this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return true;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                block18: {
                    if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) break block17;
                    try {
                        if (RebuildStatus.isOk(indexId)) break block18;
                        if (this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                            throw new ServiceNotReadyException();
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof StorageException || cause instanceof IOException) {
                            this.scheduleRebuild(indexId, e);
                            break block17;
                        }
                        throw e;
                    }
                }
                if (!ActionUtil.isDumbMode((Project)project) || this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                    this.forceUpdate(project, filter, restrictedFile);
                }
                if (!this.areUnsavedDocumentsIndexed(indexId)) {
                    this.indexUnsavedDocuments(indexId, project, filter, restrictedFile);
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
        return true;
    }

    private boolean areUnsavedDocumentsIndexed(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(27);
        }
        return this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId);
    }

    private static void handleDumbMode(@Nullable Project project) throws IndexNotReadyException {
        ProgressManager.checkCanceled();
        throw IndexNotReadyException.create(project == null ? null : DumbServiceImpl.getInstance(project).getDumbModeStartTrace());
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.getChangedFilesCollector().ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
            index2.cleanupForNextTest();
        }
    }

    @ApiStatus.Internal
    public ChangedFilesCollector getChangedFilesCollector() {
        return (ChangedFilesCollector)this.myChangedFilesCollector.getValue();
    }

    public void incrementFilesModCount() {
        this.myFilesModCount.incrementAndGet();
    }

    void filesUpdateStarted(Project project) {
        this.ensureStaleIdsDeleted();
        this.getChangedFilesCollector().ensureUpToDate();
        this.myProjectsBeingUpdated.add(project);
        this.incrementFilesModCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStaleIdsDeleted() {
        this.waitUntilIndicesAreInitialized();
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            if (this.myStaleIds.isEmpty()) {
                return;
            }
            try {
                StaleIndexesChecker.clearStaleIndexes(this.myStaleIds);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myStaleIds.clear();
            }
        }
    }

    void filesUpdateFinished(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(28);
        }
        this.myProjectsBeingUpdated.remove(project);
        this.incrementFilesModCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || project.isDefault() || this.getChangedFilesCollector().isUpdateInProgress()) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project) || !UnindexedFilesUpdater.isProjectContentFullyScanned(project)) {
            return null;
        }
        SoftReference reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data2 = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
        int currentFileModCount = this.myFilesModCount.get();
        if (data2 != null && data2.getModificationCount() == currentFileModCount) {
            return data2;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
                data2 = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
                if (data2 != null) {
                    if (data2.getModificationCount() == currentFileModCount) {
                        ProjectIndexableFilesFilter projectIndexableFilesFilter = data2;
                        return projectIndexableFilesFilter;
                    }
                } else if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = null;
                    return projectIndexableFilesFilter;
                }
                long start2 = System.currentTimeMillis();
                IntArrayList fileSet = new IntArrayList();
                this.iterateIndexableFiles(arg_0 -> FileBasedIndexImpl.lambda$projectIndexableFiles$11((IntList)fileSet, arg_0), project, null);
                ProjectIndexableFilesFilter filter = new ProjectIndexableFilesFilter((IntList)fileSet, currentFileModCount);
                project.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter));
                long finish = System.currentTimeMillis();
                LOG.debug(fileSet.size() + " files iterated in " + (finish - start2) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(29);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof MapReduceIndexMappingException) {
            if (e.getCause() instanceof SnapshotInputMappingException) {
                return e.getCause();
            }
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("schedule index re-scanning, reason: " + reason);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<? extends StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                this.requestRebuild(indexId);
            }
        }
    }

    void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(30);
        }
        this.advanceIndexVersion(indexId);
        this.getIndex(indexId).clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexVersion.rewriteVersion(indexId, this.myRegisteredIndexes.getState().getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Object[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            Set<Document> set2 = Collections.emptySet();
            if (set2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(31);
            }
            return set2;
        }
        if (documents.length == 1) {
            Set<Object> set3 = Collections.singleton(documents[0]);
            if (set3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(32);
            }
            return set3;
        }
        Set set4 = ContainerUtil.set((Object[])documents);
        if (set4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(33);
        }
        return set4;
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set2 = this.myTransactionMap.keySet();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(34);
        }
        return set2;
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter, VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        Document[] uncommittedDocuments;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(35);
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        Collection<Document> documents = this.getUnsavedDocuments();
        Set<Document> transactedDocuments = this.getTransactedDocuments();
        if (documents.isEmpty()) {
            documents = transactedDocuments;
        } else if (!transactedDocuments.isEmpty()) {
            documents = new HashSet<Document>(documents);
            documents.addAll(transactedDocuments);
        }
        Document[] documentArray = uncommittedDocuments = project != null ? PsiDocumentManager.getInstance((Project)project).getUncommittedDocuments() : Document.EMPTY_ARRAY;
        if (uncommittedDocuments.length > 0) {
            List<Document> uncommittedDocumentsCollection = Arrays.asList(uncommittedDocuments);
            if (documents.isEmpty()) {
                documents = uncommittedDocumentsCollection;
            } else {
                if (!(documents instanceof HashSet)) {
                    documents = new HashSet<Document>(documents);
                }
                documents.addAll(uncommittedDocumentsCollection);
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter))).isEmpty()) {
            UpdateTask<Document> task2 = this.myRegisteredIndexes.getUnsavedDataUpdateTask(indexId);
            assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)((Computable)() -> task2.processAll(documentsToProcessForProject, project))) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                ProgressManager.checkCanceled();
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    void indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, @NotNull Project project, @NotNull VirtualFile vFile) {
        PsiFile dominantContentFile;
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(36);
        }
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(37);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(38);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(39);
        }
        DocumentContent content2 = (dominantContentFile = FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project)) != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        long currentDocStamp = PsiDocumentManager.getInstance((Project)project).getLastCommittedStamp(document);
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return;
        }
        CharSequence contentText = content2.getText();
        FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(vFile, () -> {
            IndexedFileImpl indexedFile = new IndexedFileImpl(vFile, project);
            if (this.getAffectedIndexCandidates(indexedFile).contains(requestedIndexId) && this.acceptsInput(requestedIndexId, indexedFile)) {
                int inputId = FileBasedIndexImpl.getFileId((VirtualFile)vFile);
                if (!this.isTooLarge(vFile, Long.valueOf(contentText.length()))) {
                    FileContentImpl newFc;
                    WeakReference previousContentAndStampRef = (WeakReference)document.getUserData(ourFileContentKey);
                    Pair previousContentAndStamp = (Pair)com.intellij.reference.SoftReference.dereference((Reference)previousContentAndStampRef);
                    if (previousContentAndStamp != null && currentDocStamp == (Long)previousContentAndStamp.getSecond()) {
                        newFc = (FileContentImpl)((Object)((Object)previousContentAndStamp.getFirst()));
                    } else {
                        newFc = (FileContentImpl)FileContentImpl.createByText(vFile, contentText);
                        document.putUserData(ourFileContentKey, new WeakReference<Pair>(Pair.create((Object)((Object)newFc), (Object)currentDocStamp)));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project, dominantContentFile);
                    newFc.ensureThreadSafeLighterAST();
                    if (content2 instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    FileBasedIndexImpl.markFileIndexed(vFile, (FileContent)newFc);
                    try {
                        this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, (Object)newFc).compute();
                    }
                    finally {
                        FileBasedIndexImpl.unmarkBeingIndexed();
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, null).compute();
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(40);
        }
        if (virtualFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(41);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(42);
        }
        if (ModelBranch.getFileBranch((VirtualFile)virtualFile) != null) {
            return this.getInMemoryData(id2, virtualFile, project);
        }
        Map<K, V> map2 = super.getFileData(id2, virtualFile, project);
        if (map2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(43);
        }
        return map2;
    }

    @NotNull
    private <K, V> Map<K, V> getInMemoryData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        PsiFile psiFile;
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(44);
        }
        if (virtualFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(45);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(46);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null) {
            Map indexValues = (Map)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
                try {
                    FileContentImpl fc = psiFile instanceof PsiBinaryFile ? (FileContentImpl)FileContentImpl.createByFile(virtualFile) : (FileContentImpl)FileContentImpl.createByText(virtualFile, psiFile.getViewProvider().getContents());
                    FileBasedIndexImpl.initFileContent(fc, project, psiFile);
                    Map result2 = FactoryMap.create(key -> this.getIndex((ID)key).getExtension().getIndexer().map((Object)fc));
                    return CachedValueProvider.Result.createSingleDependency((Object)result2, (Object)psiFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Map map2 = (Map)indexValues.get(id2);
            if (map2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(47);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(48);
        }
        return map3;
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(49);
        }
        Computable updateComputable = () -> {
            cleanupAction.run();
            return true;
        };
        this.runUpdateForPersistentData((Computable<Boolean>)updateComputable);
        this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)updateComputable);
    }

    public void cleanupMemoryStorage(boolean skipContentDependentIndexes) {
        this.myLastIndexedDocStamps.clear();
        if (this.myRegisteredIndexes == null) {
            return;
        }
        IndexConfiguration state = this.myRegisteredIndexes.getState();
        if (state == null) {
            return;
        }
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (skipContentDependentIndexes && this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
            index2.cleanupMemoryStorage();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, @NotNull Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(50);
        }
        if (throwable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(51);
        }
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            IndexDataInitializer.submitGenesisTask(() -> {
                this.waitUntilIndicesAreInitialized();
                this.doRequestRebuild(indexId, throwable);
                return null;
            });
        } else {
            this.doRequestRebuild(indexId, throwable);
        }
    }

    private void doRequestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(52);
        }
        IndexingFlag.cleanupProcessedFlag();
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (RebuildStatus.requestRebuild(indexId)) {
            String message2 = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message2, throwable);
            } else {
                LOG.info(message2, throwable);
            }
            IndexingFlag.cleanupProcessedFlag();
            if (!this.myRegisteredIndexes.isInitialized()) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith((Disposable)app)).submit(rebuildRunnable);
            }
        }
    }

    private static void reportUnexpectedAsyncInitState() {
        LOG.error("Unexpected async indices initialization problem");
    }

    @Override
    @NotNull
    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        UpdatableIndex<K, V, FileContent> index2 = this.getState().getIndex(indexId);
        if (index2 == null) {
            Throwable initializationProblem = this.getState().getInitializationProblem(indexId);
            String message2 = "Index is not created for `" + indexId.getName() + "`";
            throw initializationProblem != null ? new IllegalStateException(message2, initializationProblem) : new IllegalStateException(message2);
        }
        UpdatableIndex<K, V, FileContent> updatableIndex = index2;
        if (updatableIndex == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(53);
        }
        return updatableIndex;
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(54);
        }
        if (!this.myRegisteredIndexes.isInitialized()) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project) {
        List list2 = ContainerUtil.filter(this.getChangedFilesCollector().getAllFilesToUpdate(), this.filesToBeIndexedForProjectCondition(project)::test);
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(55);
        }
        return list2;
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project) {
        Predicate<VirtualFile> predicate2 = virtualFile -> {
            if (!virtualFile.isValid()) {
                return true;
            }
            for (IndexableFileSet set2 : this.myIndexableSets) {
                Project proj = this.myIndexableSetToProjectMap.get(set2);
                if (proj != null && !proj.equals(project) || !((Boolean)ReadAction.compute(() -> set2.isInSet((VirtualFile)virtualFile))).booleanValue()) continue;
                return true;
            }
            return false;
        };
        if (predicate2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(56);
        }
        return predicate2;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return file2 instanceof VirtualFileWithId && !this.getChangedFilesCollector().isScheduledForUpdate(file2);
    }

    private void processRefreshedFile(@Nullable Project project, @NotNull CachedFileContent fileContent) {
        if (fileContent == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(57);
        }
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.getChangedFilesCollector().isScheduledForUpdate(file2)) {
            this.indexFileContent(project, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public FileIndexingStatistics indexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        FileIndexingStatistics indexingStatistics;
        boolean setIndexedStatus;
        boolean isIndexesDeleted;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(58);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        boolean isValid = file2.isValid();
        if (file2.isValid() && content2.getTimeStamp() != file2.getTimeStamp()) {
            content2 = new CachedFileContent(file2);
        }
        if (!isValid || this.isTooLarge(file2)) {
            isIndexesDeleted = true;
            ProgressManager.checkCanceled();
            this.removeDataFromIndicesForFile(fileId, file2);
            setIndexedStatus = true;
            indexingStatistics = new FileIndexingStatistics(file2.getFileType(), Collections.emptySet(), false, Collections.emptyMap(), Collections.emptyMap());
        } else {
            isIndexesDeleted = false;
            Pair<Boolean, FileIndexingStatistics> pair = this.doIndexFileContent(project, content2);
            setIndexedStatus = (Boolean)pair.first;
            indexingStatistics = (FileIndexingStatistics)pair.second;
        }
        if (setIndexedStatus) {
            IndexingFlag.setFileIndexed(file2);
        }
        if (VfsEventsMerger.LOG != null) {
            VfsEventsMerger.LOG.info("File " + file2 + " indexes have been updated for indexes " + indexingStatistics.getPerIndexerUpdateTimes().keySet() + " and deleted for " + indexingStatistics.getPerIndexerDeleteTimes().keySet() + ". Indexes was wiped = " + isIndexesDeleted + "; is file valid = " + isValid);
        }
        this.getChangedFilesCollector().removeFileIdFromFilesScheduledForUpdate(fileId);
        FileIndexingStatistics fileIndexingStatistics = indexingStatistics;
        FileIndexingStatistics fileIndexingStatistics2 = fileIndexingStatistics;
        if (fileIndexingStatistics2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(59);
        }
        return fileIndexingStatistics2;
        finally {
            IndexingStamp.flushCache(fileId);
        }
    }

    @NotNull
    private Pair<Boolean, FileIndexingStatistics> doIndexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(60);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        Ref setIndexedStatus = Ref.create((Object)Boolean.TRUE);
        HashMap perIndexerUpdateTimes = new HashMap();
        HashMap perIndexerDeletionTimes = new HashMap();
        HashSet indexesProvidedByExtensions = new HashSet();
        Ref wasFullyIndexedByInfrastructureExtensions = Ref.create((Object)true);
        Ref fileTypeRef = Ref.create();
        Project guessedProject = project != null ? project : ProjectUtil.guessProjectForFile((VirtualFile)file2);
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, guessedProject);
        FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(file2, () -> {
            SingleIndexUpdateStats updateStats;
            ProgressManager.checkCanceled();
            FileContentImpl fc = null;
            PsiFile psiFile = null;
            int inputId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
            HashSet currentIndexedStates = new HashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(indexedFile);
            int size = affectedIndexCandidates.size();
            for (int i2 = 0; i2 < size; ++i2) {
                try {
                    ID<?, ?> iD;
                    ProgressManager.checkCanceled();
                    if (fc == null) {
                        fc = (FileContentImpl)FileContentImpl.createByContent(file2, (NotNullComputable<byte[]>)((NotNullComputable)() -> FileBasedIndexImpl.getBytesOrNull(content2)));
                        fc.setSubstituteFileType(indexedFile.getFileType());
                        ProgressManager.checkCanceled();
                        psiFile = (PsiFile)content2.getUserData(IndexingDataKeys.PSI_FILE);
                        FileBasedIndexImpl.initFileContent(fc, guessedProject, psiFile);
                        fileTypeRef.set((Object)fc.getFileType());
                        ProgressManager.checkCanceled();
                    }
                    if (!this.acceptsInput(iD = affectedIndexCandidates.get(i2), fc) || !this.getIndexingState(fc, iD).updateRequired()) continue;
                    ProgressManager.checkCanceled();
                    updateStats = this.updateSingleIndex(iD, file2, inputId, (FileContent)fc);
                    if (updateStats == null) {
                        setIndexedStatus.set((Object)Boolean.FALSE);
                    } else {
                        perIndexerUpdateTimes.put(iD, updateStats.mapInputTime);
                        if (updateStats.indexWasProvidedByExtension) {
                            indexesProvidedByExtensions.add(iD);
                        } else {
                            wasFullyIndexedByInfrastructureExtensions.set((Object)false);
                        }
                    }
                    currentIndexedStates.remove(iD);
                    continue;
                }
                catch (ProcessCanceledException processCanceledException) {
                    FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                    throw processCanceledException;
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
            boolean shouldClearAllIndexedStates = fc == null;
            for (ID iD : currentIndexedStates) {
                ProgressManager.checkCanceled();
                if (!shouldClearAllIndexedStates && !this.getIndex(iD).getIndexingStateForFile(inputId, fc).updateRequired()) continue;
                ProgressManager.checkCanceled();
                updateStats = this.updateSingleIndex(iD, file2, inputId, null);
                if (updateStats == null) {
                    setIndexedStatus.set((Object)Boolean.FALSE);
                    continue;
                }
                perIndexerDeletionTimes.put(iD, updateStats.mapInputTime);
            }
            fileTypeRef.set((Object)(fc != null ? fc.getFileType() : file2.getFileType()));
        });
        file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, null);
        Pair pair = Pair.create((Object)((Boolean)setIndexedStatus.get()), (Object)new FileIndexingStatistics((FileType)fileTypeRef.get(), indexesProvidedByExtensions, (Boolean)wasFullyIndexedByInfrastructureExtensions.get(), perIndexerUpdateTimes, perIndexerDeletionTimes));
        if (pair == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(61);
        }
        return pair;
    }

    private static byte @NotNull [] getBytesOrNull(@NotNull CachedFileContent content2) {
        byte[] byArray;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(62);
        }
        try {
            byArray = content2.getBytes();
        }
        catch (IOException e) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(64);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(63);
        }
        return byArray;
    }

    @NotNull
    List<ID<?, ?>> getAffectedIndexCandidates(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(65);
        }
        if (indexedFile.getFile().isDirectory()) {
            List<ID<?, ?>> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), null) ? Collections.emptyList() : this.myRegisteredIndexes.getIndicesForDirectories();
            if (list2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(66);
            }
            return list2;
        }
        FileType fileType = indexedFile.getFileType();
        if (fileType instanceof SubstitutedFileType) {
            fileType = ((SubstitutedFileType)fileType).getFileType();
        }
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(67);
            }
            return list3;
        }
        List<ID<?, ?>> list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(68);
        }
        return list4;
    }

    private static void cleanFileContent(FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            return;
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, Project project, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(69);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.setProject(project);
    }

    /*
     * Exception decompiling
     */
    @Nullable(value="null in case index update is not necessary or the update has failed")
    @Nullable(value="null in case index update is not necessary or the update has failed") SingleIndexUpdateStats updateSingleIndex(@NotNull ID<?, ?> indexId, @Nullable VirtualFile file, int inputId, @Nullable FileContent currentFC) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean runUpdateForPersistentData(Computable<Boolean> storageUpdate) {
        return this.myStorageBufferingHandler.runUpdate(false, storageUpdate);
    }

    static void setIndexedState(UpdatableIndex<?, ?, FileContent> index2, @NotNull IndexedFile currentFC, int inputId, boolean indexWasProvided) {
        if (currentFC == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(71);
        }
        if (index2 instanceof FileBasedIndexInfrastructureExtensionUpdatableIndex) {
            ((FileBasedIndexInfrastructureExtensionUpdatableIndex)index2).setIndexedStateForFile(inputId, currentFC, indexWasProvided);
        } else {
            index2.setIndexedStateForFile(inputId, currentFC);
        }
    }

    private static void markFileIndexed(@Nullable VirtualFile file2, @Nullable FileContent fc) {
        if (fc != null && (ourIndexedFile.get() != null || ourFileToBeIndexed.get() != null)) {
            throw new AssertionError((Object)"Reentrant indexing");
        }
        ourIndexedFile.set(file2);
    }

    private static void unmarkBeingIndexed() {
        ourIndexedFile.remove();
    }

    public VirtualFile getFileBeingCurrentlyIndexed() {
        return ourIndexedFile.get();
    }

    private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.getChangedFilesCollector().getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && System.currentTimeMillis() - this.myLastOtherProjectInclusionStamp > 100L;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project), filter, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project);
            }
            if (includeFilesFromOtherProjects) {
                this.myLastOtherProjectInclusionStamp = System.currentTimeMillis();
            }
        }
    }

    public boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(72);
        }
        return this.myRegisteredIndexes.isContentDependentIndex(indexId);
    }

    @Nullable
    public IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set2 : this.myIndexableSets) {
            if (!set2.isInSet(file2)) continue;
            return set2;
        }
        return null;
    }

    @NotNull
    public List<IndexableFileSet> getIndexableSets() {
        List<IndexableFileSet> list2 = this.myIndexableSets;
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(73);
        }
        return list2;
    }

    public boolean containsIndexableSet(@NotNull IndexableFileSet set2, @NotNull Project project) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(74);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(75);
        }
        return project.equals(this.myIndexableSetToProjectMap.get(set2));
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId) {
        for (ID<?, ?> id2 : IndexingStamp.getNontrivialFileIndexedStates(inputId)) {
            this.dropNontrivialIndexedStates(inputId, id2);
        }
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId, ID<?, ?> indexId) {
        UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
        index2.invalidateIndexedStateForFile(inputId);
    }

    public void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(76);
        }
        this.waitUntilIndicesAreInitialized();
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return;
        }
        Collection contentDependentIndexes = ContainerUtil.intersection(IndexingStamp.getNontrivialFileIndexedStates(fileId), this.myRegisteredIndexes.getRequiringContentIndices());
        this.removeTransientFileDataFromIndices(contentDependentIndexes, fileId, file2);
        for (ID candidate : contentDependentIndexes) {
            this.getIndex(candidate).invalidateIndexedStateForFile(fileId);
        }
        IndexingStamp.flushCache(fileId);
        this.getChangedFilesCollector().scheduleForUpdate(file2);
    }

    public void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(77);
        }
        this.waitUntilIndicesAreInitialized();
        IndexingFlag.cleanProcessedFlagRecursively(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRegisteredIndexes.getRequiringContentIndices());
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i2);
                    if (!this.needsFileContentLoading(indexId)) continue;
                    this.getIndex(indexId).invalidateIndexedStateForFile(fileId);
                }
                if (file2.isValid()) {
                    if (!this.isTooLarge(file2)) {
                        this.getChangedFilesCollector().scheduleForUpdate(file2);
                    } else {
                        this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
                    }
                } else {
                    LOG.info("Unexpected state in update:" + file2);
                }
            }
        } else {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
                this.updateSingleIndex(indexId, null, fileId, null);
            }
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
            } else {
                this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        List filters;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(78);
        }
        if (!(filters = IndexableFilesFilter.EP_NAME.getExtensionList()).isEmpty() && !ContainerUtil.exists((Iterable)filters, e -> e.shouldIndex(file2))) {
            return;
        }
        boolean fileIsDirectory = file2.isDirectory();
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, ProjectUtil.guessProjectForFile((VirtualFile)file2));
        if (!contentChange) {
            IndexedFileWrapper fileContent = null;
            for (ID<?, ?> indexId : this.getContentLessIndexes(fileIsDirectory)) {
                if (!this.acceptsInput(indexId, indexedFile)) continue;
                if (fileContent == null) {
                    fileContent = new IndexedFileWrapper(indexedFile);
                }
                this.updateSingleIndex(indexId, file2, fileId, fileContent);
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
            } else {
                ourFileToBeIndexed.set(file2);
                try {
                    FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(file2, () -> {
                        List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(indexedFile);
                        boolean scheduleForUpdate = false;
                        int size = candidates.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            ID<?, ?> indexId = candidates.get(i2);
                            if (!this.needsFileContentLoading(indexId) || !this.acceptsInput(indexId, indexedFile)) continue;
                            this.getIndex(indexId).invalidateIndexedStateForFile(fileId);
                            scheduleForUpdate = true;
                        }
                        if (scheduleForUpdate) {
                            IndexingStamp.flushCache(fileId);
                            this.getChangedFilesCollector().scheduleForUpdate(file2);
                        } else {
                            IndexingFlag.setFileIndexed(file2);
                        }
                    });
                }
                finally {
                    ourFileToBeIndexed.remove();
                }
            }
        } else {
            IndexingFlag.setFileIndexed(file2);
        }
    }

    @NotNull
    Collection<ID<?, ?>> getContentLessIndexes(boolean isDirectory) {
        Collection<ID<?, ?>> collection = isDirectory ? this.myRegisteredIndexes.getIndicesForDirectories() : this.myRegisteredIndexes.getNotRequiringContentIndices();
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(79);
        }
        return collection;
    }

    @NotNull
    public Collection<ID<?, ?>> getContentDependentIndexes() {
        Set<ID<?, ?>> set2 = this.myRegisteredIndexes.getRequiringContentIndices();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(80);
        }
        return set2;
    }

    void clearUpToDateIndexesForUnsavedOrTransactedDocs() {
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    FileIndexingState shouldIndexFile(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(81);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(82);
        }
        if (!this.acceptsInput(indexId, file2)) {
            return this.getIndexingState(file2, indexId) == FileIndexingState.NOT_INDEXED ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        return this.getIndexingState(file2, indexId);
    }

    @NotNull
    private FileIndexingState getIndexingState(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(83);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(84);
        }
        if (FileBasedIndexImpl.isMock(virtualFile = file2.getFile())) {
            FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
            if (fileIndexingState == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(85);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = this.getIndex(indexId).getIndexingStateForFile(((NewVirtualFile)virtualFile).getId(), file2);
        if (fileIndexingState == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(86);
        }
        return fileIndexingState;
    }

    public static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(87);
        }
        return this.isTooLarge(file2, null);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(88);
        }
        return FileBasedIndexImpl.isTooLarge(file2, contentSize, this.myRegisteredIndexes.getNoLimitCheckFileTypes());
    }

    @ApiStatus.Internal
    public static boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize, @NotNull Set<FileType> noLimitFileTypes) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(89);
        }
        if (noLimitFileTypes == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(90);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !noLimitFileTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set2, @NotNull Project project) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(91);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(92);
        }
        this.myIndexableSets.add(set2);
        this.myIndexableSetToProjectMap.put(set2, project);
    }

    private boolean acceptsInput(@NotNull ID<?, ?> indexId, @NotNull IndexedFile indexedFile) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(93);
        }
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(94);
        }
        FileBasedIndex.InputFilter filter = this.getInputFilter(indexId);
        return FileBasedIndexImpl.acceptsInput(filter, indexedFile);
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set2) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(95);
        }
        if (!this.myIndexableSetToProjectMap.containsKey(set2)) {
            return;
        }
        this.myIndexableSets.remove(set2);
        this.myIndexableSetToProjectMap.remove(set2);
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        for (VirtualFile file2 : changedFilesCollector.getAllFilesToUpdate()) {
            int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2);
                changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            if (ChangedFilesCollector.CLEAR_NON_INDEXABLE_FILE_DATA) {
                this.removeDataFromIndicesForFile(fileId, file2);
            }
            changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project, int id2) {
        return ManagingFS.getInstance().findFileById(id2);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        if (doc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(96);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(97);
        }
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    void setUpFlusher() {
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
            private int lastModCount;

            @Override
            public void run() {
                int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                if (this.lastModCount == currentModCount) {
                    FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                }
                this.lastModCount = currentModCount;
            }
        });
    }

    public void invalidateCaches() {
        CorruptionMarker.requestInvalidation();
    }

    public boolean isFileIndexedInCurrentSession(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(98);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(99);
        }
        if (!(file2.isValid() && file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed())) {
            return false;
        }
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        return IndexingStamp.getNontrivialFileIndexedStates(fileId).contains(indexId);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public IntPredicate getAccessibleFileIdFilter(@Nullable Project project) {
        boolean dumb = ActionUtil.isDumbMode((Project)project);
        if (!dumb) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(100);
            }
            return intPredicate;
        }
        DumbModeAccessType dumbModeAccessType = this.getCurrentDumbModeAccessType();
        if (dumbModeAccessType == null) {
            IntPredicate intPredicate = __ -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(101);
            }
            return intPredicate;
        }
        if (dumbModeAccessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(102);
            }
            return intPredicate;
        }
        assert (dumbModeAccessType == DumbModeAccessType.RELIABLE_DATA_ONLY);
        IntPredicate intPredicate = fileId -> !this.getChangedFilesCollector().containsFileId(fileId);
        if (intPredicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(103);
        }
        return intPredicate;
    }

    @ApiStatus.Internal
    public void flushIndexes() {
        for (ID<?, ?> id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            try {
                this.getIndex(id2).flush();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ApiStatus.Internal
    static <K, V> int getIndexExtensionVersion(@NotNull FileBasedIndexExtension<K, V> extension2) {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(104);
        }
        int version2 = extension2.getVersion();
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
            version2 += SnapshotInputMappings.getVersion();
        }
        return version2;
    }

    public static boolean acceptsInput(@NotNull FileBasedIndex.InputFilter filter, @NotNull IndexedFile indexedFile) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(105);
        }
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(106);
        }
        if (filter instanceof FileBasedIndex.ProjectSpecificInputFilter) {
            if (indexedFile.getProject() == null) {
                Project project = ProjectUtil.guessProjectForFile((VirtualFile)indexedFile.getFile());
                ((IndexedFileImpl)indexedFile).setProject(project);
            }
            return ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(indexedFile);
        }
        return filter.acceptInput(indexedFile.getFile());
    }

    @NotNull
    public static FileBasedIndex.InputFilter composeInputFilter(final @NotNull FileBasedIndex.InputFilter filter, final @NotNull Predicate<? super VirtualFile> condition) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(107);
        }
        if (condition == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(108);
        }
        Object object = filter instanceof FileBasedIndex.ProjectSpecificInputFilter ? new FileBasedIndex.ProjectSpecificInputFilter(){

            public boolean acceptInput(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                return ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(file2) && condition.test(file2.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$8", "acceptInput"));
            }
        } : file2 -> filter.acceptInput(file2) && condition.test(file2);
        if (object == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(109);
        }
        return object;
    }

    private static /* synthetic */ void lambda$updateSingleIndex$24(FileContent currentFC, UpdatableIndex index2, int inputId, boolean indexWasProvided) throws RuntimeException {
        if (currentFC != null) {
            if (!FileBasedIndexImpl.isMock(currentFC.getFile())) {
                FileBasedIndexImpl.setIndexedState(index2, (IndexedFile)currentFC, inputId, indexWasProvided);
            }
        } else {
            index2.setUnindexedStateForFile(inputId);
        }
    }

    private static /* synthetic */ boolean lambda$projectIndexableFiles$11(IntList fileSet, VirtualFile fileOrDir) {
        if (fileOrDir instanceof VirtualFileWithId) {
            fileSet.add(((VirtualFileWithId)fileOrDir).getId());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 109: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 109: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexesToRebuild";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 28: 
            case 38: 
            case 42: 
            case 46: 
            case 75: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: 
            case 20: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRegistrationStatusSink";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleInputIdSink";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationStatusSink";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedIndices";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 50: 
            case 52: 
            case 54: 
            case 70: 
            case 72: 
            case 82: 
            case 84: 
            case 93: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedIndexId";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 65: 
            case 94: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fc";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFC";
                break;
            }
            case 74: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLimitFileTypes";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSnapshotInputMappingStatistics";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactedDocuments";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getInMemoryData";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToBeIndexedForProjectCondition";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFileContent";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "doIndexFileContent";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesOrNull";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndexCandidates";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableSets";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLessIndexes";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDependentIndexes";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingState";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleFileIdFilter";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "composeInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFullIndexesRescan";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doClearIndices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectFileSets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectFileSets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChangedFiles";
                break;
            }
            case 7: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 109: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStaleIds";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrWorkspaceFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestReindex";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initIndexStorage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeFileDataFromIndices";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientFileDataFromIndices";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "areUnsavedDocumentsIndexed";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "filesUpdateFinished";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCauseToRebuildIndex";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "clearIndex";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocuments";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocument";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getInMemoryData";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "doRequestRebuild";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processRefreshedFile";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "indexFileContent";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFileContent";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getBytesOrNull";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndexCandidates";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "initFileContent";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleIndex";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedState";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "needsFileContentLoading";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "containsIndexableSet";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "doTransientStateChangeForFile";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidateIndicesForFile";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFileForIndexing";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexFile";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingState";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexableSet";
                break;
            }
            case 93: 
            case 94: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInput";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexableSet";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "findLatestKnownPsiForUncomittedDocument";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedInCurrentSession";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getIndexExtensionVersion";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "composeInputFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 109: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project) {
            FileBasedIndexImpl.this.processRefreshedFile(project, new CachedFileContent(item));
        }
    }

    private static final class SingleIndexUpdateStats {
        public final long mapInputTime;
        public final boolean indexWasProvidedByExtension;

        private SingleIndexUpdateStats(long mapInputTime, boolean indexWasProvidedByExtension) {
            this.mapInputTime = mapInputTime;
            this.indexWasProvidedByExtension = indexWasProvidedByExtension;
        }
    }

    static class MyShutDownTask
    implements Runnable {
        MyShutDownTask() {
        }

        @Override
        public void run() {
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            if (fileBasedIndex instanceof FileBasedIndexImpl) {
                ((FileBasedIndexImpl)fileBasedIndex).performShutdown(false);
            }
        }
    }
}

