/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexAccessValidator;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileBasedIndexEx
extends FileBasedIndex {
    private static final ThreadLocal<Stack<DumbModeAccessType>> ourDumbModeAccessTypeStack = ThreadLocal.withInitial(() -> new Stack());
    private static final RecursionGuard<Object> ourIgnoranceGuard = RecursionManager.createGuard((String)"ignoreDumbMode");
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();

    @ApiStatus.Internal
    @NotNull
    public abstract IntPredicate getAccessibleFileIdFilter(@Nullable Project var1);

    @ApiStatus.Internal
    public abstract ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project var1);

    @NotNull
    @ApiStatus.Internal
    public abstract <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> var1);

    @ApiStatus.Internal
    public abstract void waitUntilIndicesAreInitialized();

    @ApiStatus.Internal
    public abstract <K> boolean ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3, @Nullable VirtualFile var4);

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        Iterator virtualFileIterator;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(0);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(2);
        }
        VirtualFile restrictToFile = null;
        if (filter instanceof Iterable && (virtualFileIterator = ((Iterable)filter).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexEx.lambda$getValues$1((List)values, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, filter, processor2);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter, null, processor2);
        }
        SmartList smartList = values;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(5);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor(allKeys), project);
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @Nullable Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(8);
        }
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.everythingScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(11);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index2 = this.getIndex(indexId);
            if (!this.ensureUpToDate(indexId, scope.getProject(), scope, null)) {
                return true;
            }
            if (idFilter == null) {
                idFilter = this.projectIndexableFiles(scope.getProject());
            }
            @Nullable IdFilter finalIdFilter = idFilter;
            return (Boolean)this.myAccessValidator.validate(indexId, () -> index2.processAllKeys(processor2, scope, finalIdFilter));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(13);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(14);
        }
        if (!(virtualFile instanceof VirtualFileWithId)) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(15);
            }
            return map2;
        }
        int fileId = FileBasedIndexEx.getFileId((VirtualFile)virtualFile);
        if (this.getAccessibleFileIdFilter(project).test(fileId)) {
            Map map3 = (Map)this.processExceptions(id2, virtualFile, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile), index2 -> {
                if (IndexDebugProperties.DEBUG && !ApplicationManager.getApplication().isUnitTestMode() && !((FileBasedIndexExtension)index2.getExtension()).needsForwardIndexWhenSharing()) {
                    FileBasedIndexImpl.LOG.error("Index extension " + id2 + " doesn't require forward index but accesses it");
                }
                return index2.getIndexedFileData(fileId);
            });
            Map map4 = ContainerUtil.notNullize((Map)map3);
            if (map4 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(16);
            }
            return map4;
        }
        Map map5 = Collections.emptyMap();
        if (map5 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(17);
        }
        return map5;
    }

    @Nullable
    public <V> V getSingleEntryIndexData(@NotNull ID<Integer, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(18);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(19);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(20);
        }
        if (!(this.getIndex(id2).getExtension() instanceof SingleEntryFileBasedIndexExtension)) {
            throw new IllegalArgumentException("'" + id2 + "' index is not a SingleEntryFileBasedIndex");
        }
        Map<Integer, V> data2 = this.getFileData(id2, virtualFile, project);
        if (data2.isEmpty()) {
            return null;
        }
        if (data2.size() == 1) {
            return data2.values().iterator().next();
        }
        throw new IllegalStateException("Invalid single entry index data '" + id2 + "'");
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(21);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(22);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(23);
        }
        if (LightEdit.owns((Project)filter.getProject())) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(24);
            }
            return list2;
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        this.processValuesInScope(indexId, dataKey, false, filter, null, (file2, value2) -> {
            files2.add(file2);
            return true;
        });
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(26);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(28);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(29);
        }
        return this.processValues(indexId, dataKey, inFile, processor2, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(30);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(31);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(32);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(33);
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, filter, processor2) : this.processValuesInScope(indexId, dataKey, false, filter, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(@NotNull ID<K, V> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(34);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(35);
        }
        this.waitUntilIndicesAreInitialized();
        UpdatableIndex<K, V, FileContent> index2 = this.getIndex(indexId);
        this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
        return index2.getModificationStamp();
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent>, ? extends R, StorageException> computable) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(36);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(37);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(38);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index2 = this.getIndex(indexId);
            Project project = filter.getProject();
            if (!this.ensureUpToDate(indexId, project, filter, restrictToFile)) {
                return null;
            }
            return (R)this.myAccessValidator.validate(indexId, () -> ConcurrencyUtil.withLock((Lock)index2.getLock().readLock(), () -> computable.convert((Object)index2)));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(39);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(40);
        }
        if (restrictToFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(42);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(43);
        }
        Project project = scope.getProject();
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return project == null || ModelBranch.getFileBranch((VirtualFile)restrictToFile) == null || this.processInMemoryFileData(indexId, dataKey, project, restrictToFile, processor2);
        }
        int restrictedFileId = FileBasedIndexEx.getFileId((VirtualFile)restrictToFile);
        if (!this.getAccessibleFileIdFilter(project).test(restrictedFileId)) {
            return true;
        }
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                if (valueIt.getValueAssociationPredicate().contains(restrictedFileId) && !processor2.process(restrictToFile, value2)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processInMemoryFileData(ID<K, V> indexId, K dataKey, Project project, VirtualFile file2, FileBasedIndex.ValueProcessor<? super V> processor2) {
        Map<K, V> data2 = this.getFileData(indexId, file2, project);
        return !data2.containsKey(dataKey) || processor2.process(file2, data2.get(dataKey));
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        Project project;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(44);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(46);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(47);
        }
        if ((project = scope.getProject()) != null && !ModelBranchImpl.processModifiedFilesInScope(scope, (Processor<? super VirtualFile>)((Processor)file2 -> this.processInMemoryFileData(indexId, dataKey, project, (VirtualFile)file2, processor2)))) {
            return false;
        }
        PersistentFS fs = PersistentFS.getInstance();
        IdFilter filter = idFilter != null ? idFilter : this.projectIndexableFiles(project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id2 = inputIdsIterator.next();
                    if (!accessibleFileFilter.test(id2) || filter != null && !filter.containsFileId(id2)) continue;
                    NewVirtualFile file2 = fs.findFileByIdIfCached(id2);
                    if (file2 != null) {
                        for (VirtualFile eachFile : FileBasedIndexEx.filesInScopeWithBranches(scope, (VirtualFile)file2)) {
                            if (!processor2.process(eachFile, value2)) {
                                return false;
                            }
                            if (!ensureValueProcessedOnce) continue;
                            ProgressManager.checkCanceled();
                            break;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(48);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(50);
        }
        if (valueProcessor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(51);
        }
        return (result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index2 -> valueProcessor.process((Object)((InvertedIndexValueIterator)index2.getData(dataKey).getValueIterator())))) == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet;
        IntSet set2;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(52);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(53);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(54);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(55);
        }
        return (set2 = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet = this.projectIndexableFiles(filter.getProject()), null)) != null && FileBasedIndexEx.processVirtualFiles((IntCollection)set2, filter, processor2);
    }

    public boolean processFilesContainingAllKeys(@NotNull Collection<FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor2) {
        if (queries == null) {
            FileBasedIndexEx.$$$reportNull$$$0(56);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(57);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(58);
        }
        Project project = filter.getProject();
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(project);
        IntOpenHashSet set2 = null;
        if (filter instanceof GlobalSearchScope.FilesScope) {
            set2 = new IntOpenHashSet();
            for (VirtualFile file3 : (Iterable)filter) {
                if (!(file3 instanceof VirtualFileWithId)) continue;
                set2.add(((VirtualFileWithId)file3).getId());
            }
        }
        for (FileBasedIndex.AllKeysQuery<?, ?> query2 : queries) {
            IntSet queryResult = this.collectFileIdsContainingAllKeys(query2.getIndexId(), query2.getDataKeys(), filter, query2.getValueChecker(), filesSet, (IntSet)set2);
            if (queryResult == null) {
                return false;
            }
            if (queryResult.isEmpty()) {
                return true;
            }
            if (set2 == null) {
                set2 = new IntOpenHashSet((IntCollection)queryResult);
                continue;
            }
            set2 = queryResult;
        }
        if (set2 == null || !FileBasedIndexEx.processVirtualFiles((IntCollection)set2, filter, processor2)) {
            return false;
        }
        if (project == null) {
            return true;
        }
        return ModelBranchImpl.processModifiedFilesInScope(filter, (Processor<? super VirtualFile>)((Processor)file2 -> {
            for (FileBasedIndex.AllKeysQuery query2 : queries) {
                ID id2 = query2.getIndexId();
                Map data2 = this.getFileData((ID)id2, (VirtualFile)file2, project);
                if (data2.keySet().containsAll(query2.getDataKeys())) continue;
                return true;
            }
            return processor2.process(file2);
        }));
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor2, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(59);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(60);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(61);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(62);
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(63);
        }
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(64);
        }
        this.requestRebuild(indexId, e);
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(65);
        }
        this.waitUntilIndicesAreInitialized();
        this.ensureUpToDate(indexId, project, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(66);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(67);
        }
        List<IndexableFilesIterator> providers = this.getOrderedIndexableFilesProviders(project);
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        boolean wasIndeterminate = false;
        if (indicator != null) {
            wasIndeterminate = indicator.isIndeterminate();
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.pushState();
        }
        try {
            for (int i2 = 0; i2 < providers.size(); ++i2) {
                IndexableFilesIterator provider2;
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if (!(provider2 = providers.get(i2)).iterateFiles(project, processor2, (VirtualFileFilter)indexableFilesDeduplicateFilter)) {
                    break;
                }
                if (indicator == null) continue;
                indicator.setFraction((double)(i2 + 1) * 1.0 / (double)providers.size());
            }
        }
        finally {
            if (indicator != null) {
                indicator.popState();
                indicator.setIndeterminate(wasIndeterminate);
            }
        }
    }

    @NotNull
    public List<IndexableFilesIterator> getOrderedIndexableFilesProviders(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(68);
        }
        if (LightEdit.owns((Project)project)) {
            List<IndexableFilesIterator> list2 = Collections.emptyList();
            if (list2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(69);
            }
            return list2;
        }
        List list3 = (List)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            return IndexableFilesContributor.EP_NAME.getExtensionList().stream().flatMap(c -> c.getIndexableFiles(project).stream()).collect(Collectors.toList());
        });
        if (list3 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(70);
        }
        return list3;
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter, @Nullable IntSet restrictedIds) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(71);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(72);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(73);
        }
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter.getProject());
        ValueContainer.IntPredicate idChecker = projectFilesFilter == null ? accessibleFileFilter::test : id2 -> projectFilesFilter.containsFileId(id2) && accessibleFileFilter.test(id2) && (restrictedIds == null || restrictedIds.contains(id2));
        Condition keyChecker = __ -> {
            ProgressManager.checkCanceled();
            return true;
        };
        ThrowableConvertor convertor = index2 -> InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index2, (Collection)dataKeys, (Condition)keyChecker, (Condition)valueChecker, (ValueContainer.IntPredicate)idChecker);
        return (IntSet)this.processExceptions(indexId, null, filter, convertor);
    }

    private static boolean processVirtualFiles(@NotNull IntCollection ids, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor2) {
        if (ids == null) {
            FileBasedIndexEx.$$$reportNull$$$0(74);
        }
        if (filter == null) {
            FileBasedIndexEx.$$$reportNull$$$0(75);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(76);
        }
        IntArrayList sortedIds = new IntArrayList(ids);
        sortedIds.sort(null);
        PersistentFS fs = PersistentFS.getInstance();
        IntListIterator iterator2 = sortedIds.iterator();
        while (iterator2.hasNext()) {
            ProgressManager.checkCanceled();
            int id2 = iterator2.nextInt();
            NewVirtualFile file2 = fs.findFileByIdIfCached(id2);
            if (file2 == null) continue;
            for (VirtualFile fileInBranch : FileBasedIndexEx.filesInScopeWithBranches(filter, (VirtualFile)file2)) {
                boolean processNext2 = processor2.process((Object)fileInBranch);
                ProgressManager.checkCanceled();
                if (processNext2) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        DumbModeAccessType result2 = this.getCurrentDumbModeAccessType_NoDumbChecks();
        if (result2 != null) {
            FileBasedIndexImpl.LOG.assertTrue(ContainerUtil.exists((Object[])ProjectManager.getInstance().getOpenProjects(), p -> DumbService.isDumb((Project)p)), (Object)"getCurrentDumbModeAccessType may only be called during indexing");
        }
        return result2;
    }

    @Nullable
    DumbModeAccessType getCurrentDumbModeAccessType_NoDumbChecks() {
        Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
        if (dumbModeAccessTypeStack.isEmpty()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ourIgnoranceGuard.prohibitResultCaching(dumbModeAccessTypeStack.get(0));
        return (DumbModeAccessType)dumbModeAccessTypeStack.peek();
    }

    @ApiStatus.Internal
    @NotNull
    public <T> Processor<? super T> inheritCurrentDumbAccessType(@NotNull Processor<? super T> processor2) {
        Stack<DumbModeAccessType> stack;
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(77);
        }
        if ((stack = ourDumbModeAccessTypeStack.get()).isEmpty()) {
            Processor processor3 = processor2;
            if (processor3 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(78);
            }
            return processor3;
        }
        DumbModeAccessType access = (DumbModeAccessType)stack.peek();
        Processor processor4 = t -> (Boolean)this.ignoreDumbMode(access, () -> processor2.process(t));
        if (processor4 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(79);
        }
        return processor4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndexEx.$$$reportNull$$$0(80);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(81);
        }
        Application app = ApplicationManager.getApplication();
        app.assertReadAccessAllowed();
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
            boolean preventCaching = dumbModeAccessTypeStack.empty();
            dumbModeAccessTypeStack.push((Object)dumbModeAccessType);
            Disposable disposable2 = Disposer.newDisposable();
            if (app.isWriteThread()) {
                app.getMessageBus().connect(disposable2).subscribe(PsiModificationTracker.TOPIC, () -> RecursionManager.dropCurrentMemoizationCache());
            }
            try {
                Object object = preventCaching ? ourIgnoranceGuard.computePreventingRecursion((Object)dumbModeAccessType, false, computable) : computable.compute();
                return (T)object;
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
                DumbModeAccessType type = (DumbModeAccessType)dumbModeAccessTypeStack.pop();
                assert (dumbModeAccessType == type);
            }
        }
        return (T)computable.compute();
    }

    @NotNull
    @ApiStatus.Internal
    public static List<VirtualFile> filesInScopeWithBranches(@NotNull GlobalSearchScope scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(82);
        }
        if (file2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(83);
        }
        SmartList filesInScope = new SmartList();
        if (scope.contains(file2)) {
            filesInScope.add(file2);
        }
        for (ModelBranch branch : scope.getModelBranchesAffectingScope()) {
            VirtualFile copy2;
            if (((ModelBranchImpl)branch).hasModifications(copy2 = branch.findFileCopy(file2)) || !scope.contains(copy2)) continue;
            filesInScope.add(copy2);
        }
        SmartList smartList = filesInScope;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(84);
        }
        return smartList;
    }

    private static /* synthetic */ boolean lambda$getValues$1(List values, VirtualFile file2, Object value2) {
        values.add(value2);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 69: 
            case 70: 
            case 78: 
            case 79: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 69: 
            case 70: 
            case 78: 
            case 79: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: 
            case 22: 
            case 27: 
            case 31: 
            case 40: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 2: 
            case 23: 
            case 29: 
            case 33: 
            case 37: 
            case 54: 
            case 57: 
            case 62: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 69: 
            case 70: 
            case 78: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 35: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 28: 
            case 32: 
            case 43: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 66: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 42: 
            case 46: 
            case 50: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 38: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProcessor";
                break;
            }
            case 53: 
            case 60: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedIndexableFilesProviders";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritCurrentDumbAccessType";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "filesInScopeWithBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 69: 
            case 70: 
            case 78: 
            case 79: 
            case 84: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSingleEntryIndexData";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processExceptions";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processValueIterator";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithKey";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRebuild";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedIndexableFilesProviders";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAllKeys";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "inheritCurrentDumbAccessType";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "filesInScopeWithBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 69: 
            case 70: 
            case 78: 
            case 79: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

