/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

final class FileBasedIndexDataInitialization
extends IndexDataInitializer<IndexConfiguration> {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexDataInitialization.class);
    private boolean myCurrentVersionCorrupted;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final RegisteredIndexes myRegisteredIndexes;
    @NotNull
    private final IntSet myStaleIds;
    @NotNull
    private final IndexVersionRegistrationSink myRegistrationResultSink;
    @NotNull
    private final IndexConfiguration myState;

    FileBasedIndexDataInitialization(@NotNull FileBasedIndexImpl index2, @NotNull RegisteredIndexes registeredIndexes) {
        if (index2 == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(0);
        }
        if (registeredIndexes == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(1);
        }
        this.myStaleIds = IntSets.synchronize((IntSet)new IntOpenHashSet());
        this.myRegistrationResultSink = new IndexVersionRegistrationSink();
        this.myState = new IndexConfiguration();
        this.myFileBasedIndex = index2;
        this.myRegisteredIndexes = registeredIndexes;
    }

    @NotNull
    private Collection<ThrowableRunnable<?>> initAssociatedDataForExtensions() {
        FileBasedIndexExtension extension2;
        Activity activity = StartUpMeasurer.startActivity((String)"file index extensions iteration");
        Iterator extensions2 = IndexInfrastructure.hasIndices() ? ((ExtensionPointImpl)FileBasedIndexExtension.EXTENSION_POINT_NAME.getPoint()).iterator() : Collections.emptyIterator();
        ArrayList tasks = new ArrayList();
        while (extensions2.hasNext() && (extension2 = (FileBasedIndexExtension)extensions2.next()) != null) {
            ID name = extension2.getName();
            RebuildStatus.registerIndex(name);
            this.myRegisteredIndexes.registerIndexExtension(extension2);
            tasks.add(() -> {
                try {
                    FileBasedIndexImpl.registerIndexer(extension2, this.myState, this.myRegistrationResultSink, this.myStaleIds);
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    ComponentManagerImplKt.handleComponentError(t, extension2.getClass().getName(), null);
                }
            });
        }
        this.myRegisteredIndexes.extensionsDataWasLoaded();
        activity.end();
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected Collection<ThrowableRunnable<?>> prepareTasks() {
        PersistentFSImpl fs = (PersistentFSImpl)ManagingFS.getInstance();
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        Disposable disposable2 = () -> new FileBasedIndexImpl.MyShutDownTask().run();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(fileBasedIndex), disposable2);
        Disposer.register((Disposable)fs, (Disposable)disposable2);
        this.myFileBasedIndex.setUpShutDownTask();
        Collection<ThrowableRunnable<?>> tasks = this.initAssociatedDataForExtensions();
        PersistentIndicesConfiguration.loadConfiguration();
        this.myCurrentVersionCorrupted = CorruptionMarker.requireInvalidation();
        for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
            FileBasedIndexInfrastructureExtension.InitializationResult result2 = ex.initialize();
            this.myCurrentVersionCorrupted = this.myCurrentVersionCorrupted || result2 == FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED;
        }
        boolean storageLayoutChanged = FileBasedIndexLayoutSettings.INSTANCE.loadUsedLayout();
        boolean bl = this.myCurrentVersionCorrupted = this.myCurrentVersionCorrupted || storageLayoutChanged;
        if (this.myCurrentVersionCorrupted) {
            CorruptionMarker.dropIndexes();
        }
        Collection<ThrowableRunnable<?>> collection = tasks;
        if (collection == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IndexConfiguration finish() {
        this.myState.finalizeFileTypeMappingForIndices();
        this.showChangedIndexesNotification();
        this.myRegistrationResultSink.logChangedAndFullyBuiltIndices(FileBasedIndexImpl.LOG, "Indexes to be rebuilt after version change:", this.myCurrentVersionCorrupted ? "Indexes to be rebuilt after corruption:" : "Indices to be built:");
        this.myState.freeze();
        this.myRegisteredIndexes.setState(this.myState);
        for (ID<?, ?> indexId : this.myState.getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<? extends StorageException>)((ThrowableRunnable)() -> this.myFileBasedIndex.clearIndex(indexId)));
            }
            catch (StorageException e) {
                this.myFileBasedIndex.requestRebuild(indexId);
                FileBasedIndexImpl.LOG.error((Throwable)e);
            }
        }
        IndexConfiguration indexConfiguration = this.myState;
        Object object = indexConfiguration;
        if (object == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(4);
        }
        return object;
        finally {
            this.myFileBasedIndex.addStaleIds(this.myStaleIds);
            this.myFileBasedIndex.setUpFlusher();
            this.myRegisteredIndexes.ensureLoadedIndexesUpToDate();
            this.myRegisteredIndexes.markInitialized();
            FileBasedIndexDataInitialization.saveRegisteredIndicesAndDropUnregisteredOnes(this.myState.getIndexIDs());
        }
    }

    private void showChangedIndexesNotification() {
        String rebuildNotification;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !Registry.is((String)"ide.showIndexRebuildMessage", (boolean)false)) {
            return;
        }
        if (this.myCurrentVersionCorrupted) {
            rebuildNotification = IndexingBundle.message((String)"index.corrupted.notification.text", (Object[])new Object[0]);
        } else if (this.myRegistrationResultSink.hasChangedIndexes()) {
            rebuildNotification = IndexingBundle.message((String)"index.format.changed.notification.text", (Object[])new Object[]{this.myRegistrationResultSink.changedIndices()});
        } else {
            return;
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Indexing").createNotification(IndexingBundle.message((String)"index.rebuild.notification.title", (Object[])new Object[0]), rebuildNotification, NotificationType.INFORMATION, null).notify(null);
    }

    @Override
    @NotNull
    protected String getInitializationFinishedMessage(@NotNull IndexConfiguration initializationResult) {
        if (initializationResult == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(5);
        }
        String string = "Initialized indexes: " + initializationResult.getIndexIDs() + ".";
        if (string == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<? extends ID<?, ?>> ids) {
        if (ids == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        Path registeredIndicesFile = PathManager.getIndexRoot().resolve("registered");
        HashSet<String> indicesToDrop = new HashSet<String>();
        boolean exceptionThrown = false;
        if (Files.exists(registeredIndicesFile, new LinkOption[0])) {
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(registeredIndicesFile, new OpenOption[0])));){
                int size = in.readInt();
                for (int idx = 0; idx < size; ++idx) {
                    indicesToDrop.add(IOUtil.readString((DataInput)in));
                }
            }
            catch (Throwable e) {
                LOG.info(e);
                exceptionThrown = true;
                ids.stream().map(IndexId::getName).forEach(indicesToDrop::add);
            }
        }
        if (!exceptionThrown) {
            for (ID<?, ?> key : ids) {
                indicesToDrop.remove(key.getName());
            }
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + String.join((CharSequence)",", indicesToDrop));
            for (String s : indicesToDrop) {
                try {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getFileBasedIndexRootDir(s).toFile());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        try {
            Files.createDirectories(registeredIndicesFile.getParent(), new FileAttribute[0]);
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(registeredIndicesFile, new OpenOption[0])));){
                os.writeInt(ids.size());
                for (ID<?, ?> id2 : ids) {
                    IOUtil.writeString((String)id2.getName(), (DataOutput)os);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredIndexes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexDataInitialization";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializationResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexDataInitialization";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initAssociatedDataForExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializationFinishedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitializationFinishedMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveRegisteredIndicesAndDropUnregisteredOnes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyApplicationListener
    implements ApplicationListener {
        private final FileBasedIndexImpl myFileBasedIndex;

        MyApplicationListener(FileBasedIndexImpl fileBasedIndex) {
            this.myFileBasedIndex = fileBasedIndex;
        }

        public void writeActionStarted(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            this.myFileBasedIndex.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/FileBasedIndexDataInitialization$MyApplicationListener", "writeActionStarted"));
        }
    }
}

