/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "corruptionMarker", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCorruptionMarker", "()Ljava/nio/file/Path;", "dropIndexes", "", "requestInvalidation", "requireInvalidation", "", "intellij.platform.lang.impl"})
public final class CorruptionMarker {
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    @NotNull
    public static final CorruptionMarker INSTANCE;

    private final Path getCorruptionMarker() {
        return PathManager.getIndexRoot().resolve(CORRUPTION_MARKER_NAME);
    }

    @JvmStatic
    public static final void requestInvalidation() {
        FileBasedIndexImpl.LOG.info("Requesting explicit indices invalidation");
        try {
            Files.newOutputStream(INSTANCE.getCorruptionMarker(), new OpenOption[0]).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final boolean requireInvalidation() {
        return IndexInfrastructure.hasIndices() && Files.exists(INSTANCE.getCorruptionMarker(), new LinkOption[0]);
    }

    @JvmStatic
    public static final void dropIndexes() {
        File indexRoot = PathManager.getIndexRoot().toFile();
        FileUtil.deleteWithRenaming((File)indexRoot);
        indexRoot.mkdirs();
        SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
        ID.reinitializeDiskStorage();
        PersistentIndicesConfiguration.saveConfiguration();
        FileUtil.delete((Path)INSTANCE.getCorruptionMarker());
        ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
        Object[] $this$forEach$iv = objectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv;
            boolean bl = false;
            it.resetPersistentState();
        }
        FileBasedIndexLayoutSettings.INSTANCE.saveCurrentLayout();
    }

    private CorruptionMarker() {
    }

    static {
        CorruptionMarker corruptionMarker;
        INSTANCE = corruptionMarker = new CorruptionMarker();
    }
}

