/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ShortestPathFinder<Node> {
    private final InboundSemiGraph<Node> myGraph;

    public ShortestPathFinder(Graph<Node> graph2) {
        this.myGraph = graph2;
    }

    public ShortestPathFinder(InboundSemiGraph<Node> graph2) {
        this.myGraph = graph2;
    }

    @Nullable
    public List<Node> findPath(Node start2, Node finish) {
        HashMap nextNodes = new HashMap();
        ArrayDeque<Object> queue2 = new ArrayDeque<Object>();
        queue2.addLast(finish);
        boolean found = false;
        while (!queue2.isEmpty()) {
            Object node = queue2.removeFirst();
            if (node.equals(start2)) {
                found = true;
                break;
            }
            Iterator in = this.myGraph.getIn(node);
            while (in.hasNext()) {
                Object prev2 = in.next();
                if (nextNodes.containsKey(prev2)) continue;
                nextNodes.put(prev2, node);
                queue2.addLast(prev2);
            }
        }
        if (!found) {
            return null;
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Object current2 = start2;
        while (!current2.equals(finish)) {
            path.add(current2);
            current2 = nextNodes.get(current2);
        }
        path.add(finish);
        return path;
    }
}

