/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GistManagerImpl
extends GistManager {
    private static final Logger LOG = Logger.getInstance(GistManagerImpl.class);
    private static final Map<String, VirtualFileGist<?>> ourGists = ContainerUtil.createConcurrentWeakValueMap();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (id2 == null) {
            GistManagerImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(1);
        }
        if (calcData == null) {
            GistManagerImpl.$$$reportNull$$$0(2);
        }
        if (ourGists.get(id2) != null) {
            throw new IllegalArgumentException("Gist '" + id2 + "' is already registered");
        }
        VirtualFileGist virtualFileGist = ourGists.computeIfAbsent(id2, __ -> new VirtualFileGistImpl(id2, version2, externalizer, calcData));
        if (virtualFileGist == null) {
            GistManagerImpl.$$$reportNull$$$0(3);
        }
        return virtualFileGist;
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<? super PsiFile, ? extends Data> calculator) {
        if (id2 == null) {
            GistManagerImpl.$$$reportNull$$$0(4);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(5);
        }
        if (calculator == null) {
            GistManagerImpl.$$$reportNull$$$0(6);
        }
        return new PsiFileGistImpl<Data>(id2, version2, externalizer, calculator);
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        this.invalidateGists();
        GistManagerImpl.invalidateDependentCaches();
    }

    public void invalidateData(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GistManagerImpl.$$$reportNull$$$0(7);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invalidating gist " + file2);
        }
        this.invalidateData();
    }

    private void invalidateGists() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("Invalidating gists"));
        }
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    private static void invalidateDependentCaches() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    @TestOnly
    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newVirtualFileGist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newVirtualFileGist";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newPsiFileGist";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidateData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyBulkFileListener
    implements BulkFileListener {
        MyBulkFileListener() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyBulkFileListener.$$$reportNull$$$0(0);
            }
            if (events.stream().anyMatch(MyBulkFileListener::shouldDropCache)) {
                ((GistManagerImpl)GistManager.getInstance()).invalidateGists();
            }
        }

        private static boolean shouldDropCache(VFileEvent e) {
            if (!(e instanceof VFilePropertyChangeEvent)) {
                return false;
            }
            String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
            return propertyName.equals("name") || propertyName.equals("encoding");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/gist/GistManagerImpl$MyBulkFileListener", "after"));
        }
    }
}

