/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IJSwingUtilities {
    public static boolean hasFocus(Component component2) {
        Component focusOwner = IJSwingUtilities.findFocusOwner(component2);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean hasFocus2(Component component2) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        Window activeWindow = null;
        if (windowManager != null) {
            activeWindow = windowManager.getMostRecentFocusedWindow();
        }
        if (activeWindow == null) {
            return false;
        }
        Component focusedComponent = windowManager.getFocusedComponent(activeWindow);
        if (focusedComponent == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusedComponent, component2);
    }

    @NotNull
    public static Component getFocusedComponentInWindowOrSelf(@NotNull Component component2) {
        Window window;
        if (component2 == null) {
            IJSwingUtilities.$$$reportNull$$$0(0);
        }
        Component focusedComponent = (window = UIUtil.getWindow((Component)component2)) == null ? null : WindowManagerEx.getInstanceEx().getFocusedComponent(window);
        Component component3 = focusedComponent != null ? focusedComponent : component2;
        if (component3 == null) {
            IJSwingUtilities.$$$reportNull$$$0(1);
        }
        return component3;
    }

    public static HyperlinkEvent createHyperlinkEvent(@Nullable String href, @NotNull Object source) {
        if (source == null) {
            IJSwingUtilities.$$$reportNull$$$0(2);
        }
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new HyperlinkEvent(source, HyperlinkEvent.EventType.ACTIVATED, url, href);
    }

    public static void updateComponentTreeUI(@Nullable Component c) {
        JRootPane rootPane;
        if (c == null) {
            return;
        }
        if (c instanceof RootPaneContainer && (rootPane = ((RootPaneContainer)((Object)c)).getRootPane()) != null) {
            UIUtil.decorateWindowHeader((JRootPane)rootPane);
        }
        for (Component component2 : UIUtil.uiTraverser((Component)c).postOrderDfsTraversal()) {
            if (!(component2 instanceof JComponent)) continue;
            ((JComponent)component2).updateUI();
        }
        c.invalidate();
        c.validate();
        c.repaint();
    }

    public static void moveMousePointerOn(Component component2) {
        if (component2 != null && component2.isShowing() && Registry.is((String)"ide.settings.move.mouse.on.default.button", (boolean)false)) {
            Point point = component2.getLocationOnScreen();
            int dx = component2.getWidth() / 2;
            int dy = component2.getHeight() / 2;
            try {
                new Robot().mouseMove(point.x + dx, point.y + dy);
                component2.requestFocusInWindow();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    @ApiStatus.Internal
    public static void appendComponentClassNames(@NotNull StringBuilder sb, @Nullable Component root) {
        if (sb == null) {
            IJSwingUtilities.$$$reportNull$$$0(3);
        }
        UIUtil.uiTraverser((Component)root).forEach(c -> IJSwingUtilities.appendComponentClassName(sb, root, c));
    }

    private static void appendComponentClassName(@NotNull StringBuilder sb, @Nullable Component root, @NotNull Component component2) {
        if (sb == null) {
            IJSwingUtilities.$$$reportNull$$$0(4);
        }
        if (component2 == null) {
            IJSwingUtilities.$$$reportNull$$$0(5);
        }
        sb.append("\n    ");
        for (Component p = component2; root != p && p != null; p = p.getParent()) {
            sb.append("  ");
        }
        sb.append(component2.getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IJSwingUtilities";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IJSwingUtilities";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponentInWindowOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFocusedComponentInWindowOrSelf";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlinkEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendComponentClassNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendComponentClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

